# 通知設計書 59-DropFunctionEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいて関数の削除操作が完了した後に発火するイベント通知「DropFunctionEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、関数削除操作の完了を外部リスナーに通知するために使用される。

### 本通知の処理概要

DropFunctionEventは、外部カタログ（ExternalCatalog）上で関数の削除操作が正常に完了した直後に発火するイベント通知である。ExternalCatalogWithListenerクラスのdropFunctionメソッド内で、デリゲート先の実処理が成功した後にpostToAllメソッドで全リスナーに配信される。

**業務上の目的・背景**：ユーザー定義関数の削除が完了した際に、関数カタログの更新通知、キャッシュされたクエリプランの無効化、UIの表示更新、監査ログの記録などの後続処理を実行する必要がある。DropFunctionEventはこれらの後続処理をイベント駆動で実現するための基盤となる。

**通知の送信タイミング**：ExternalCatalogWithListener.dropFunctionメソッドにおいて、デリゲート先のExternalCatalog.dropFunctionが正常に完了した直後（行295）にpostToAllメソッドで発火される。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録される。

**通知内容の概要**：関数が属するデータベース名（database）と関数名（name）の2つのフィールドを含む。FunctionEventトレイトおよびDatabaseEventトレイトを継承している。

**期待されるアクション**：受信リスナーは関数削除の完了を検知し、関連するキャッシュの破棄、関数カタログの更新、依存クエリの再コンパイル検討、UIの表示更新などを実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` で登録された全ExternalCatalogEventListenerに配信。SharedState初期化時にSparkContext.listenerBusへのブリッジリスナーが登録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
DropFunctionEvent(database: String, name: String)

例：DropFunctionEvent("default", "my_udf")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | 関数が属するデータベース名 | ExternalCatalogWithListener.dropFunctionの引数db | Yes |
| name | 削除された関数名 | ExternalCatalogWithListener.dropFunctionの引数funcName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.dropFunction() | デリゲート先のdropFunctionが例外なく完了すること | 行294でdelegate.dropFunctionが成功した後、行295でpostToAll |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 関数が存在しない場合 | delegate.dropFunctionが例外をスローし、DropFunctionEventは発火しない（DropFunctionPreEventのみ発火） |
| デリゲート処理で例外発生 | PostイベントであるDropFunctionEventは発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[dropFunction呼び出し] --> B[DropFunctionPreEvent発火]
    B --> C[delegate.dropFunction実行]
    C -->|成功| D[DropFunctionEvent発火]
    C -->|例外| E[例外スロー - DropFunctionEventは未発火]
    D --> F[postToAllで全リスナーに配信]
    F --> G[SparkListenerBusへ伝播]
    G --> H[終了]
    E --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアの関数メタデータ | 削除対象関数の存在確認 | デリゲート先で実施 |

### テーブル別参照項目詳細

#### メタストア関数メタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | 関数所属DB確認 | 引数dbで指定 |
| function_name | 関数存在確認 | 引数funcNameで指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| メタストアの関数メタデータ | DELETE | デリゲート先のExternalCatalog実装が関数メタデータを削除 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 関数不存在エラー | 関数が存在しない場合 | DropFunctionPreEventのみ発火。呼び出し元に例外スロー |
| リスナー例外 | リスナーのonEvent内で例外発生 | ListenerBusがキャッチしてログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントにはデータベース名と関数名のみが含まれ、関数の実装詳細は含まれない。

## 備考

- DropFunctionEventは関数削除の「後」イベント（post-event）であり、対応する「前」イベントとしてDropFunctionPreEvent（No.58）が存在する。
- テストコード ExternalCatalogEventSuite.scala 行203-210で、関数削除の正常系（Pre+Post発火）と異常系（Preのみ発火）が確認されている。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行153-158: FunctionEventトレイト、行178: DropFunctionEventケースクラス |

**読解のコツ**: DropFunctionEventとDropFunctionPreEventは同一のフィールド構成（database, name）を持つ。発火タイミングのみが異なる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行292-296: dropFunctionメソッド。行295がDropFunctionEventの発火箇所 |

**主要処理フロー**:
1. **行293**: `postToAll(DropFunctionPreEvent(db, funcName))` でPreイベント発火
2. **行294**: `delegate.dropFunction(db, funcName)` でデリゲート処理
3. **行295**: `postToAll(DropFunctionEvent(db, funcName))` でPostイベント（本イベント）発火

#### Step 3: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行203-210: dropFunction正常時Pre+Post発火、関数不存在時Preのみ発火 |

### プログラム呼び出し階層図

```
SparkSession (SQL: DROP FUNCTION ...)
    |
    +-- SessionCatalog.dropFunction()
           |
           +-- ExternalCatalogWithListener.dropFunction()  [行292-296]
                  |
                  +-- postToAll(DropFunctionPreEvent)       [行293]
                  +-- delegate.dropFunction()               [行294]
                  +-- postToAll(DropFunctionEvent)           [行295]  <-- 本イベント
                         |
                         +-- ExternalCatalogEventListener.onEvent()
                         +-- SparkContext.listenerBus.post()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

dropFunction(db,         --> ExternalCatalogWithListener     --> DropFunctionPreEvent
 funcName)                       .dropFunction()                 (database, name)
                                 |                                    |
                                 v                                    v
                           delegate.dropFunction()            --> DropFunctionEvent
                           (関数メタデータ削除)                    (database, name)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | DropFunctionEventの定義（行178） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | dropFunctionメソッド（行292-296） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログインタフェース |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | 初期化とlistenerBus接続 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | dropFunctionの発火テスト（行203-210） |
