# 通知設計書 60-AlterFunctionPreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいて関数の変更操作が実行される前に発火するイベント通知「AlterFunctionPreEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、関数変更操作の開始を外部リスナーに事前通知するために使用される。

### 本通知の処理概要

AlterFunctionPreEventは、外部カタログ（ExternalCatalog）上で関数の変更操作が実行される直前に発火するイベント通知である。ExternalCatalogWithListenerクラスのalterFunctionメソッド内で、デリゲート先の実処理を呼び出す前にpostToAllメソッドで全リスナーに配信される。

**業務上の目的・背景**：ユーザー定義関数の変更（実装クラスの変更、リソースの更新等）は、その関数を利用するクエリの実行結果に影響を与える可能性がある重要な操作である。変更前に依存クエリの確認、影響範囲の評価、監査ログの事前記録、バリデーションなどの前処理を実行する必要がある。AlterFunctionPreEventはこれらの前処理をイベント駆動で実現するための基盤となる。

**通知の送信タイミング**：ExternalCatalogWithListener.alterFunctionメソッドにおいて、デリゲート先のExternalCatalog.alterFunctionを呼び出す前（行300）にpostToAllメソッドで発火される。関数名はCatalogFunction.identifier.funcNameから取得される（行299）。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録されるため、SparkListenerBus上の全リスナーにも伝播される。

**通知内容の概要**：関数が属するデータベース名（database）と関数名（name）の2つのフィールドを含む。FunctionEventトレイトおよびDatabaseEventトレイトを継承しており、SparkListenerEventとしても扱われる。変更内容の詳細（新しいclassNameやresources）はイベントには含まれない。

**期待されるアクション**：受信リスナーは関数変更操作の開始を検知し、依存クエリの確認、キャッシュされた関数情報の準備的無効化、監査ログの事前記録などの前処理を実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため、リスナー側の例外はログ出力後に無視） |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` メソッドで登録された全てのExternalCatalogEventListenerに対して配信される。SharedState初期化時（SharedState.scala 行175）にSparkContext.listenerBusへpostするブリッジリスナーが登録される。

## 通知テンプレート

### メール通知の場合

本イベントはインプロセスのイベントバス配信であり、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
AlterFunctionPreEvent(database: String, name: String)

例：AlterFunctionPreEvent("default", "my_udf")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | 関数が属するデータベース名 | ExternalCatalogWithListener.alterFunctionの引数db | Yes |
| name | 変更対象の関数名 | funcDefinition.identifier.funcName（行299） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.alterFunction() | メソッド呼び出し | 行300でデリゲート処理前にpostToAll |
| API呼び出し | ALTER FUNCTION SQL文の実行 | SQLパーサー経由でalterFunctionが呼ばれること | SparkSQL経由でもalterFunction APIを通じて発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventはデリゲート処理前に無条件で発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[alterFunction呼び出し] --> B[AlterFunctionPreEvent発火]
    B --> C[delegate.alterFunction実行]
    C -->|成功| D[AlterFunctionEvent発火]
    C -->|例外| E[例外スロー - AlterFunctionEventは未発火]
    D --> F[終了]
    E --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアの関数メタデータ | 変更対象関数の存在確認 | デリゲート先で実施 |

### テーブル別参照項目詳細

#### メタストア関数メタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | 関数所属DB確認 | 引数dbで指定 |
| function_name | 関数存在確認 | funcNameで指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの発火時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonEvent内で例外が発生した場合 | ListenerBusがキャッチしてログ出力。他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントにはデータベース名と関数名のみが含まれ、関数の実装クラス名（className）やリソース情報は含まれないため、機密データの漏洩リスクは限定的である。
- 関数変更の具体的内容（変更後のclassNameやresources）はイベントから読み取れない。

## 備考

- AlterFunctionPreEventは関数変更の「前」イベント（pre-event）であり、対応する「後」イベントとしてAlterFunctionEvent（No.61）が存在する。
- テストコード ExternalCatalogEventSuite.scala 行194-201で、関数変更テストが確認されている。alterFunctionが正常に完了した場合、AlterFunctionPreEventとAlterFunctionEventの両方が発火する。
- 関数名はCatalogFunction.identifierのfuncNameプロパティから取得される（行299）。
- AlterTablePreEvent（No.54）とは異なり、kindフィールドは持たない。関数の変更はテーブルのように変更種別（スキーマ、統計情報等）を区別する必要がないため。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行153-158: FunctionEventトレイト（DatabaseEvent継承、nameフィールド追加）、行183: AlterFunctionPreEventケースクラス（database, nameの2フィールド） |

**読解のコツ**: AlterFunctionPreEventはFunctionEventを継承し、AlterTablePreEventとは異なりkindフィールドを持たないシンプルな構造。FunctionEventの型階層は `SparkListenerEvent -> ExternalCatalogEvent -> DatabaseEvent -> FunctionEvent -> AlterFunctionPreEvent`。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行298-303: alterFunctionメソッド。行299でfuncNameを取得、行300でPreイベント発火、行301でデリゲート処理、行302でPostイベント発火 |

**主要処理フロー**:
1. **行299**: `val name = funcDefinition.identifier.funcName` で関数名を取得
2. **行300**: `postToAll(AlterFunctionPreEvent(db, name))` でPreイベント（本イベント）を発火
3. **行301**: `delegate.alterFunction(db, funcDefinition)` でデリゲート先の実処理を実行
4. **行302**: `postToAll(AlterFunctionEvent(db, name))` でPostイベントを発火

#### Step 3: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行194-201: alterFunction正常時のPre+Post発火テスト。classNameを"org.apache.spark.AlterFunction"に変更する操作で検証 |

### プログラム呼び出し階層図

```
SparkSession (SQL: ALTER FUNCTION ...)
    |
    +-- SessionCatalog.alterFunction()
           |
           +-- ExternalCatalogWithListener.alterFunction()  [行298-303]
                  |
                  +-- val name = funcDefinition.identifier.funcName  [行299]
                  +-- postToAll(AlterFunctionPreEvent)              [行300]  <-- 本イベント
                  |      |
                  |      +-- ExternalCatalogEventListener.onEvent()
                  |      +-- SparkContext.listenerBus.post()
                  |
                  +-- delegate.alterFunction()                      [行301]
                  |      |
                  |      +-- InMemoryCatalog.alterFunction() or HiveExternalCatalog.alterFunction()
                  |
                  +-- postToAll(AlterFunctionEvent)                 [行302]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

alterFunction(db,        --> ExternalCatalogWithListener     --> AlterFunctionPreEvent
 funcDefinition)                 .alterFunction()                (database, name)
                                 |                                    |
                                 v                                    v
                           delegate.alterFunction()           --> AlterFunctionEvent
                           (関数メタデータ更新)                    (database, name)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | AlterFunctionPreEvent、FunctionEventの定義（行153-183） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | alterFunctionメソッド（行298-303） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログインタフェース |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化とSparkListenerBusへの接続 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | alterFunctionの発火テスト（行194-201） |
