# 通知設計書 61-AlterFunctionEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおける関数変更後イベント「AlterFunctionEvent」の設計仕様を記述する。AlterFunctionEventは、外部カタログに登録された関数の定義が変更された後に発火するイベント通知であり、ExternalCatalogEvent継承階層のFunctionEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

AlterFunctionEventは、Spark SQLの外部カタログに登録されたユーザ定義関数（UDF）の定義が変更された後に、変更が完了したことをリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLでは、外部カタログ（HiveメタストアやInMemoryCatalog）に登録されたユーザ定義関数の変更操作を監視する必要がある。AlterFunctionEventは、関数のクラス名やリソースなどの定義情報が変更された後に発火することで、メタデータの変更追跡、監査ログの記録、UIの更新、および依存コンポーネントへの変更伝播を可能にする。Pre/Postイベントペアの「Post」側として、変更が正常に完了したことを保証する役割を持つ。

**通知の送信タイミング**：ExternalCatalogWithListener.alterFunction()メソッド内で、デリゲート先の実際のカタログに対するalterFunction()呼び出しが成功した直後にpostToAll()を通じて発火される。デリゲート先で例外が発生した場合、本イベントは発火されない（AlterFunctionPreEventのみ発火される）。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：変更が行われたデータベース名（database: String）と関数名（name: String）の2つのフィールドを含む。変更後の関数定義の詳細（className、resourcesなど）は含まれない。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてメタデータキャッシュの無効化、UIの更新、監査ログへの記録、または依存関係の再評価を行う。変更が完了済みであるため、ロールバック判断ではなく状態の同期が主目的となる。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。送信先のフィルタリングは行われず、登録済みの全リスナーが受信対象となる。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: AlterFunctionEvent
データベース: {database}
関数名: {name}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | 関数が属するデータベース名 | CatalogFunction.identifier経由（alterFunction引数） | Yes |
| name | 変更された関数名 | CatalogFunction.identifier.funcName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.alterFunction() | デリゲート先のalterFunction()が例外なく完了すること | ALTER FUNCTION DDL実行時またはプログラムAPIからの関数変更時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デリゲート先で例外発生 | alterFunction()の実際の実行が失敗した場合、PostイベントであるAlterFunctionEventは発火されずPreEventのみとなる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[alterFunction呼び出し] --> B[AlterFunctionPreEvent発火]
    B --> C[delegate.alterFunction実行]
    C -->|成功| D[AlterFunctionEvent発火]
    C -->|例外| E[例外スロー - PostEvent発火なし]
    D --> F[ListenerBus経由で全リスナーに配信]
    F --> G[SparkContext.listenerBusへ転送]
    G --> H[終了]
    E --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（func関連テーブル） | 関数定義の変更操作 | HiveExternalCatalog使用時。InMemoryCatalogの場合はメモリ内マップ |

### テーブル別参照項目詳細

#### Hiveメタストア func テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| FUNC_NAME | 変更対象関数の特定 | database名とfunction名で検索 |
| CLASS_NAME | 関数クラスの変更 | ALTER FUNCTION実行時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Hiveメタストア func テーブル | UPDATE | 関数定義の変更（デリゲート先で実行） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない。EventLoggingListenerが有効な場合、イベントログファイルにJSON形式で記録される |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 関数未存在 | 指定された関数がカタログに存在しない場合 | AnalysisExceptionがスローされる。AlterFunctionPreEventは発火済み、AlterFunctionEventは発火されない |
| データベース未存在 | 指定されたデータベースが存在しない場合 | AnalysisExceptionがスローされる |
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。alterFunction()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

AlterFunctionEventはデータベース名と関数名のみを含み、関数の実装クラス名やリソースパスなどの詳細情報は含まない。ただし、リスナーバス経由で全登録リスナーに配信されるため、カスタムリスナーを登録するアプリケーションコードは信頼済みである必要がある。SparkListenerEventを継承しているため、イベントログが有効な場合はログファイルにも記録される。

## 備考

- AlterFunctionEventはAlterFunctionPreEventとペアで使用される。PreEventは操作前、本イベント（PostEvent）は操作後に発火される
- FunctionEventトレイトを継承し、DatabaseEventトレイトおよびExternalCatalogEventトレイトの階層に位置する
- case classとして定義されているため、パターンマッチングでの利用が可能
- TablePartitionSpecのようなコレクション型フィールドは持たず、シンプルな文字列フィールドのみで構成される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、AlterFunctionEventおよびその継承階層であるExternalCatalogEventの型階層を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 26行目: ExternalCatalogEventトレイト定義。150-158行目: FunctionEventトレイト（database, nameフィールド）。188行目: AlterFunctionEventケースクラス定義 |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | CatalogFunction定義。FunctionIdentifierによる関数識別方法を理解する |

**読解のコツ**: Scalaのケースクラス（case class）はコンストラクタ引数が自動的にval（不変フィールド）となり、equals/hashCode/toStringが自動生成される。トレイトの階層（ExternalCatalogEvent -> DatabaseEvent -> FunctionEvent）を理解することで、イベントのパターンマッチング方法がわかる。

#### Step 2: エントリーポイントを理解する

ExternalCatalogWithListenerクラスのalterFunction()メソッドがイベント発火のエントリーポイントである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 298-303行目: alterFunction()メソッド。postToAll()でPre/Postイベントを発火する流れ |

**主要処理フロー**:
1. **299行目**: funcDefinition.identifier.funcNameから関数名を取得
2. **300行目**: postToAll(AlterFunctionPreEvent(db, name))でPreイベント発火
3. **301行目**: delegate.alterFunction(db, funcDefinition)でデリゲート先に実行委譲
4. **302行目**: postToAll(AlterFunctionEvent(db, name))でPostイベント発火

#### Step 3: リスナーバスの配信メカニズムを理解する

ListenerBusトレイトのpostToAll()メソッドが実際の配信を行う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | postToAll()メソッド: 登録された全リスナーに対してdoPostEvent()を順次呼び出す |
| 3-2 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 34-38行目: doPostEvent()オーバーライド。listener.onEvent(event)を呼び出す |

#### Step 4: SharedStateでの初期化とSparkListenerBusへの転送を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | 149-178行目: externalCatalog初期化。172行目でExternalCatalogWithListenerをラップし、175行目でSparkContext.listenerBusへの転送リスナーを登録 |

#### Step 5: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 164-211行目: functionテストケース。194-201行目: alterFunction()呼び出し時のPre/Postイベント発火検証 |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.alterFunction(db, funcDefinition)
    |
    +-- funcDefinition.identifier.funcName  // 関数名取得
    |
    +-- postToAll(AlterFunctionPreEvent(db, name))
    |       |
    |       +-- doPostEvent(listener, event)
    |               +-- listener.onEvent(event)  // 各リスナーに配信
    |
    +-- delegate.alterFunction(db, funcDefinition)  // 実際のカタログ操作
    |       |
    |       +-- InMemoryCatalog.alterFunction() or HiveExternalCatalog.alterFunction()
    |
    +-- postToAll(AlterFunctionEvent(db, name))
            |
            +-- doPostEvent(listener, event)
                    +-- listener.onEvent(event)  // 各リスナーに配信
                            +-- sparkContext.listenerBus.post(event)  // SharedState経由の転送
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ALTER FUNCTION DDL          ExternalCatalogWithListener         AlterFunctionPreEvent
  or API呼び出し ──────▶      .alterFunction()           ──────▶  (全リスナーへ配信)
                                    |
                            delegate.alterFunction()
                                    |
                            AlterFunctionEvent ─────────────────▶  (全リスナーへ配信)
                                                                      |
                                                                SparkContext.listenerBus
                                                                      |
                                                                SparkListenerイベントとして
                                                                全SparkListenerに配信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | AlterFunctionEvent、FunctionEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。alterFunction()メソッド |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | CatalogFunction、FunctionIdentifierの定義 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化とSparkListenerBusへの転送設定 |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | postToAll()によるリスナー配信メカニズム |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | AlterFunctionEventの発火テスト |
