# 通知設計書 63-RenameFunctionEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおける関数リネーム後イベント「RenameFunctionEvent」の設計仕様を記述する。RenameFunctionEventは、外部カタログに登録された関数のリネーム操作が正常に完了した後に発火するイベント通知であり、ExternalCatalogEvent継承階層のFunctionEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

RenameFunctionEventは、Spark SQLの外部カタログに登録されたユーザ定義関数（UDF）のリネーム操作が正常に完了した後に、リネーム完了をリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLでは、外部カタログに登録されたユーザ定義関数のリネーム操作の完了を検知する必要がある。RenameFunctionEventは、関数名が変更された後に発火することで、メタデータキャッシュの無効化、監査ログへの操作完了記録、UIの更新、および依存コンポーネントへの変更完了伝播を可能にする。Pre/Postイベントペアの「Post」側として、リネーム操作が正常に完了したことを保証する役割を持つ。

**通知の送信タイミング**：ExternalCatalogWithListener.renameFunction()メソッド内で、デリゲート先の実際のカタログに対するrenameFunction()呼び出しが成功した直後にpostToAll()を通じて発火される。デリゲート先で例外が発生した場合、本イベントは発火されない（RenameFunctionPreEventのみ発火される）。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：リネーム対象の関数が属するデータベース名（database: String）、リネーム前の関数名（name: String）、およびリネーム後の関数名（newName: String）の3つのフィールドを含む。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてメタデータキャッシュの更新（旧名での参照の無効化、新名での参照の登録）、UIの更新、監査ログへの完了記録、または旧名に依存するコンポーネントへの通知を行う。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。送信先のフィルタリングは行われず、登録済みの全リスナーが受信対象となる。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: RenameFunctionEvent
データベース: {database}
関数名: {name}
新関数名: {newName}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | 関数が属するデータベース名 | renameFunction()の引数db | Yes |
| name | リネーム前の関数名 | renameFunction()の引数oldName | Yes |
| newName | リネーム後の関数名 | renameFunction()の引数newName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.renameFunction() | デリゲート先のrenameFunction()が例外なく完了すること | ALTER FUNCTION RENAME DDL実行時またはプログラムAPIからの関数リネーム時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デリゲート先で例外発生 | renameFunction()の実際の実行が失敗した場合、PostイベントであるRenameFunctionEventは発火されずPreEventのみとなる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[renameFunction呼び出し] --> B[RenameFunctionPreEvent発火]
    B --> C[delegate.renameFunction実行]
    C -->|成功| D[RenameFunctionEvent発火]
    C -->|例外| E[例外スロー - PostEvent発火なし]
    D --> F[ListenerBus経由で全リスナーに配信]
    F --> G[SparkContext.listenerBusへ転送]
    G --> H[終了]
    E --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（func関連テーブル） | 関数定義のリネーム操作 | HiveExternalCatalog使用時。InMemoryCatalogの場合はメモリ内マップ |

### テーブル別参照項目詳細

#### Hiveメタストア func テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| FUNC_NAME | リネーム対象関数の特定 | database名と旧function名で検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Hiveメタストア func テーブル | UPDATE | 関数名のリネーム（デリゲート先で実行済み） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 関数未存在 | リネーム対象の関数がカタログに存在しない場合 | AnalysisExceptionがスローされる。RenameFunctionPreEventは発火済み、RenameFunctionEventは発火されない |
| 関数名重複 | リネーム先の関数名が既に存在する場合 | AnalysisExceptionがスローされる |
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。renameFunction()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

RenameFunctionEventはデータベース名、旧関数名、新関数名のみを含み、関数の実装詳細は含まない。ただし、リスナーバス経由で全登録リスナーに配信されるため、カスタムリスナーを登録するアプリケーションコードは信頼済みである必要がある。

## 備考

- RenameFunctionEventはRenameFunctionPreEventとペアで使用される。PreEventは操作前、本イベント（PostEvent）は操作後に発火される
- FunctionEventトレイトを継承するが、追加フィールドとしてnewNameを持つ
- case classとして定義されているため、パターンマッチングでの利用が可能
- テストコードで、存在しない関数のリネーム時にPreEventのみ発火されPostEventは発火されないことが検証されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 26行目: ExternalCatalogEventトレイト。150-158行目: FunctionEventトレイト。202-206行目: RenameFunctionEventケースクラス定義（database, name, newNameフィールド） |

**読解のコツ**: RenameFunctionEventはRenameFunctionPreEvent（193-197行目）と対をなす。両者のフィールド構成は同一（database, name, newName）である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 305-309行目: renameFunction()メソッド。308行目でRenameFunctionEvent発火 |

**主要処理フロー**:
1. **306行目**: postToAll(RenameFunctionPreEvent(db, oldName, newName))でPreイベント発火
2. **307行目**: delegate.renameFunction(db, oldName, newName)でデリゲート先に実行委譲
3. **308行目**: postToAll(RenameFunctionEvent(db, oldName, newName))でPostイベント発火（成功時のみ到達）

#### Step 3: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 185-188行目: 正常系のPre/Postイベントペア検証。189-192行目: 異常系でPreEventのみ発火される検証 |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.renameFunction(db, oldName, newName)
    |
    +-- postToAll(RenameFunctionPreEvent(db, oldName, newName))
    |
    +-- delegate.renameFunction(db, oldName, newName)
    |       |
    |       +-- InMemoryCatalog.renameFunction() or HiveExternalCatalog.renameFunction()
    |
    +-- postToAll(RenameFunctionEvent(db, oldName, newName))  // 成功時のみ
            |
            +-- doPostEvent(listener, event)
                    +-- listener.onEvent(event)
                            +-- sparkContext.listenerBus.post(event)  // SharedState経由
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ALTER FUNCTION RENAME       ExternalCatalogWithListener         RenameFunctionPreEvent
  or API呼び出し ──────▶      .renameFunction()           ──────▶  (常に配信)
  db, oldName, newName              |
                            delegate.renameFunction()
                                    |（成功時）
                            RenameFunctionEvent ────────────────▶  (成功時のみ配信)
                              database, name, newName                  |
                                                                SparkContext.listenerBus
                                                                全SparkListenerに配信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | RenameFunctionEvent、FunctionEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。renameFunction()メソッド |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化とSparkListenerBusへの転送設定 |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | postToAll()によるリスナー配信メカニズム |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | RenameFunctionEventの発火テスト |
