# 通知設計書 64-CreatePartitionsPreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおけるパーティション作成前イベント「CreatePartitionsPreEvent」の設計仕様を記述する。CreatePartitionsPreEventは、テーブルのパーティションが作成される直前に発火するイベント通知であり、ExternalCatalogEvent継承階層のPartitionsEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

CreatePartitionsPreEventは、Spark SQLの外部カタログに登録されたテーブルに対して新しいパーティションが作成される前に、操作の開始をリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLのパーティションテーブルでは、パーティションの追加操作をカタログレベルで監視する必要がある。CreatePartitionsPreEventは、パーティション作成操作が開始される前に発火することで、事前バリデーション、監査ログへの操作開始記録、ストレージ準備、および依存コンポーネントへの事前通知を可能にする。Pre/Postイベントペアの「Pre」側として、操作がこれから実行されることを通知する。操作が失敗した場合でもPreEventは発火済みであるため、操作の試行自体を追跡できる。

**通知の送信タイミング**：ExternalCatalogWithListener.createPartitions()メソッド内で、CatalogTablePartitionのSeqからpartSpecsを抽出した後、デリゲート先の実際のカタログに対するcreatePartitions()呼び出しの直前にpostToAll()を通じて発火される。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：パーティションが属するデータベース名（database: String）、テーブル名（name: String）、および作成対象のパーティション仕様のシーケンス（partSpecs: Seq[TablePartitionSpec]）を含む。TablePartitionSpecはMap[String, String]型のエイリアスであり、パーティションカラム名とその値のマッピングを表す。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてパーティション作成の事前チェック、ストレージディレクトリの準備、監査ログへの記録を行う。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: CreatePartitionsPreEvent
データベース: {database}
テーブル名: {name}
パーティション仕様: {partSpecs}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | パーティションが属するデータベース名 | createPartitions()の引数db | Yes |
| name | パーティションが属するテーブル名 | createPartitions()の引数table | Yes |
| partSpecs | 作成対象パーティション仕様のシーケンス | parts.map(_.spec)で抽出 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.createPartitions() | 常に発火（デリゲート先呼び出し前） | ALTER TABLE ADD PARTITION DDL実行時またはプログラムAPIからのパーティション作成時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventは常に発火される。デリゲート先の成否に関わらず発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[createPartitions呼び出し] --> B[parts.map_.specでpartSpecs抽出]
    B --> C[CreatePartitionsPreEvent発火]
    C --> D[delegate.createPartitions実行]
    D -->|成功| E[CreatePartitionsEvent発火]
    D -->|例外| F[例外スロー - PostEvent発火なし]
    E --> G[ListenerBus経由で全リスナーに配信]
    G --> H[終了]
    F --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（PARTITIONS関連テーブル） | パーティション作成操作 | HiveExternalCatalog使用時 |
| Hiveメタストア（TBLS関連テーブル） | 対象テーブルの存在確認 | パーティション操作前のテーブル検証 |

### テーブル別参照項目詳細

#### Hiveメタストア PARTITIONS テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| PART_NAME | 既存パーティションの存在確認 | database名、table名で検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。createPartitions()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

CreatePartitionsPreEventはデータベース名、テーブル名、パーティション仕様（キー名と値のマップ）を含む。パーティション値にはビジネスデータ（日付、地域コードなど）が含まれる可能性があるため、リスナーの実装において適切なアクセス制御を考慮する必要がある。

## 備考

- CreatePartitionsPreEventはCreatePartitionsEventとペアで使用される。本イベント（PreEvent）は操作前、PostEventは操作後に発火される
- PartitionsEventトレイトを継承し、TableEvent -> DatabaseEvent -> ExternalCatalogEventの階層に位置する
- partSpecsはCatalogTablePartition.specから抽出される（parts.map(_.spec)）
- TablePartitionSpecはMap[String, String]の型エイリアスであり、interface.scalaの1072行目で定義されている
- ignoreIfExists=trueの場合、パーティションが既に存在していてもPre/Post両イベントが発火される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 208-216行目: PartitionsEventトレイト（database, name, partSpecsフィールド）。221-225行目: CreatePartitionsPreEventケースクラス定義 |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | 1072行目: TablePartitionSpec型エイリアス（Map[String, String]）の定義。197行目: CatalogTablePartition.specフィールドの定義 |

**読解のコツ**: TablePartitionSpecはMap[String, String]の型エイリアスであり、パーティションカラム名をキー、パーティション値をバリューとするマップである。CreatePartitionsPreEventのnameフィールドはテーブル名を表す（コメント`/* of table */`で明示）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 202-211行目: createPartitions()メソッド。207行目でparts.map(_.spec)によるpartSpecs抽出、208行目でPreEvent発火 |

**主要処理フロー**:
1. **207行目**: val partSpecs = parts.map(_.spec) でCatalogTablePartitionからパーティション仕様を抽出
2. **208行目**: postToAll(CreatePartitionsPreEvent(db, table, partSpecs))でPreイベント発火
3. **209行目**: delegate.createPartitions(db, table, parts, ignoreIfExists)でデリゲート先に実行委譲
4. **210行目**: postToAll(CreatePartitionsEvent(db, table, partSpecs))でPostイベント発火

#### Step 3: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 213-319行目: partitionsテストケース。258-262行目: createPartitions正常系でPre/Post発火検証。270-274行目: 重複作成失敗時にPreEventのみ発火される検証 |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.createPartitions(db, table, parts, ignoreIfExists)
    |
    +-- parts.map(_.spec)  // CatalogTablePartitionからpartSpecsを抽出
    |
    +-- postToAll(CreatePartitionsPreEvent(db, table, partSpecs))
    |       |
    |       +-- doPostEvent(listener, event)
    |               +-- listener.onEvent(event)
    |
    +-- delegate.createPartitions(db, table, parts, ignoreIfExists)
    |       |
    |       +-- InMemoryCatalog.createPartitions() or HiveExternalCatalog.createPartitions()
    |
    +-- postToAll(CreatePartitionsEvent(db, table, partSpecs))  // 成功時のみ
```

### データフロー図

```
[入力]                              [処理]                                  [出力]

ALTER TABLE ADD PARTITION       ExternalCatalogWithListener             CreatePartitionsPreEvent
  or API呼び出し ──────────▶      .createPartitions()              ──────▶ (全リスナーへ配信)
  db, table,                        |                                    database, name, partSpecs
  parts(CatalogTablePartition)  parts.map(_.spec) → partSpecs
                                    |
                                delegate.createPartitions()
                                    |（成功時）
                                CreatePartitionsEvent ──────────────────▶ (成功時のみ配信)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | CreatePartitionsPreEvent、PartitionsEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。createPartitions()メソッド |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | CatalogTablePartition、TablePartitionSpec型エイリアスの定義 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化とSparkListenerBusへの転送設定 |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | postToAll()によるリスナー配信メカニズム |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | CreatePartitionsPreEventの発火テスト |
