# 通知設計書 65-CreatePartitionsEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおけるパーティション作成後イベント「CreatePartitionsEvent」の設計仕様を記述する。CreatePartitionsEventは、テーブルのパーティションが正常に作成された後に発火するイベント通知であり、ExternalCatalogEvent継承階層のPartitionsEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

CreatePartitionsEventは、Spark SQLの外部カタログに登録されたテーブルに対して新しいパーティションが正常に作成された後に、作成完了をリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLのパーティションテーブルでは、パーティションの追加完了をカタログレベルで監視する必要がある。CreatePartitionsEventは、パーティション作成が正常に完了した後に発火することで、メタデータキャッシュの更新、監査ログへの操作完了記録、UIの更新、およびデータ可用性の通知を可能にする。Pre/Postイベントペアの「Post」側として、作成操作が正常に完了したことを保証する役割を持つ。

**通知の送信タイミング**：ExternalCatalogWithListener.createPartitions()メソッド内で、デリゲート先の実際のカタログに対するcreatePartitions()呼び出しが成功した直後にpostToAll()を通じて発火される。デリゲート先で例外が発生した場合（パーティション重複時にignoreIfExists=falseなど）、本イベントは発火されない。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：パーティションが属するデータベース名（database: String）、テーブル名（name: String）、および作成されたパーティション仕様のシーケンス（partSpecs: Seq[TablePartitionSpec]）を含む。TablePartitionSpecはMap[String, String]型のエイリアスである。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてメタデータキャッシュの更新、UIの更新、データ可用性の通知、監査ログへの完了記録を行う。パーティション作成が完了済みであるため、後続のクエリでの利用準備が主目的となる。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: CreatePartitionsEvent
データベース: {database}
テーブル名: {name}
パーティション仕様: {partSpecs}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | パーティションが属するデータベース名 | createPartitions()の引数db | Yes |
| name | パーティションが属するテーブル名 | createPartitions()の引数table | Yes |
| partSpecs | 作成されたパーティション仕様のシーケンス | parts.map(_.spec)で抽出 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.createPartitions() | デリゲート先のcreatePartitions()が例外なく完了すること | ALTER TABLE ADD PARTITION DDL実行時またはプログラムAPIからのパーティション作成完了時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デリゲート先で例外発生 | パーティション重複（ignoreIfExists=false）等で例外が発生した場合、PostイベントであるCreatePartitionsEventは発火されずPreEventのみとなる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[createPartitions呼び出し] --> B[parts.map_.specでpartSpecs抽出]
    B --> C[CreatePartitionsPreEvent発火]
    C --> D[delegate.createPartitions実行]
    D -->|成功| E[CreatePartitionsEvent発火]
    D -->|例外| F[例外スロー - PostEvent発火なし]
    E --> G[ListenerBus経由で全リスナーに配信]
    G --> H[SparkContext.listenerBusへ転送]
    H --> I[終了]
    F --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（PARTITIONS関連テーブル） | パーティション作成操作 | HiveExternalCatalog使用時 |

### テーブル別参照項目詳細

#### Hiveメタストア PARTITIONS テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| PART_NAME | パーティション存在確認 | database名、table名で検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Hiveメタストア PARTITIONS テーブル | INSERT | パーティション定義の追加（デリゲート先で実行済み） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パーティション重複 | 同一パーティションが既に存在しignoreIfExists=falseの場合 | AnalysisExceptionがスローされる。PreEventは発火済み、PostEventは発火されない |
| テーブル未存在 | 対象テーブルが存在しない場合 | AnalysisExceptionがスローされる |
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。createPartitions()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

CreatePartitionsEventはデータベース名、テーブル名、パーティション仕様を含む。パーティション値にはビジネスデータが含まれる可能性があるため、リスナーの実装において適切なアクセス制御を考慮する必要がある。

## 備考

- CreatePartitionsEventはCreatePartitionsPreEventとペアで使用される。PreEventは操作前、本イベント（PostEvent）は操作後に発火される
- PartitionsEventトレイトを継承する
- ignoreIfExists=trueの場合、パーティションが既に存在していてもPre/Post両イベントが発火される（テストコードで検証済み）
- partSpecsのSeqには複数のパーティション仕様を含むことができ、一度のAPI呼び出しで複数パーティションの一括作成が可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 208-216行目: PartitionsEventトレイト。230-234行目: CreatePartitionsEventケースクラス定義 |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | 1072行目: TablePartitionSpec型エイリアス。197行目: CatalogTablePartition.specフィールド |

**読解のコツ**: CreatePartitionsEventのnameフィールドにはコメント`/* of table */`が付与されており、テーブル名であることが明示されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 202-211行目: createPartitions()メソッド。210行目でCreatePartitionsEvent発火 |

**主要処理フロー**:
1. **207行目**: val partSpecs = parts.map(_.spec) でpartSpecs抽出
2. **208行目**: postToAll(CreatePartitionsPreEvent(db, table, partSpecs))
3. **209行目**: delegate.createPartitions(db, table, parts, ignoreIfExists)
4. **210行目**: postToAll(CreatePartitionsEvent(db, table, partSpecs)) - 成功時のみ到達

#### Step 3: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 258-268行目: 正常系・ignoreIfExists検証。270-274行目: 重複失敗時のPreEventのみ発火検証 |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.createPartitions(db, table, parts, ignoreIfExists)
    |
    +-- parts.map(_.spec)  // partSpecs抽出
    |
    +-- postToAll(CreatePartitionsPreEvent(db, table, partSpecs))
    |
    +-- delegate.createPartitions(db, table, parts, ignoreIfExists)
    |       |
    |       +-- InMemoryCatalog.createPartitions() or HiveExternalCatalog.createPartitions()
    |
    +-- postToAll(CreatePartitionsEvent(db, table, partSpecs))  // 成功時のみ
            |
            +-- doPostEvent(listener, event)
                    +-- listener.onEvent(event)
                            +-- sparkContext.listenerBus.post(event)
```

### データフロー図

```
[入力]                              [処理]                                  [出力]

ALTER TABLE ADD PARTITION       ExternalCatalogWithListener             CreatePartitionsPreEvent
  or API呼び出し ──────────▶      .createPartitions()              ──────▶ (常に配信)
  db, table,                        |
  parts(CatalogTablePartition)  parts.map(_.spec) → partSpecs
                                    |
                                delegate.createPartitions()
                                    |（成功時）
                                CreatePartitionsEvent ──────────────────▶ (成功時のみ配信)
                                  database, name, partSpecs
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | CreatePartitionsEvent、PartitionsEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。createPartitions()メソッド |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | CatalogTablePartition、TablePartitionSpec型エイリアスの定義 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | CreatePartitionsEventの発火テスト |
