# 通知設計書 66-DropPartitionsPreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおけるパーティション削除前イベント「DropPartitionsPreEvent」の設計仕様を記述する。DropPartitionsPreEventは、テーブルのパーティションが削除される直前に発火するイベント通知であり、ExternalCatalogEvent継承階層のPartitionsEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

DropPartitionsPreEventは、Spark SQLの外部カタログに登録されたテーブルのパーティションが削除される前に、操作の開始をリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLのパーティションテーブルでは、パーティションの削除操作をカタログレベルで事前に検知する必要がある。DropPartitionsPreEventは、パーティション削除操作が実行される前に発火することで、事前バリデーション、データバックアップの実行、監査ログへの操作開始記録、および依存コンポーネントへの事前通知を可能にする。Pre/Postイベントペアの「Pre」側として、削除操作がこれから実行されることを通知する。

**通知の送信タイミング**：ExternalCatalogWithListener.dropPartitions()メソッド内で、デリゲート先の実際のカタログに対するdropPartitions()呼び出しの直前にpostToAll()を通じて発火される。デリゲート先の成否にかかわらず必ず発火される。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：パーティションが属するデータベース名（database: String）、テーブル名（name: String）、および削除対象のパーティション仕様のシーケンス（partSpecs: Seq[TablePartitionSpec]）を含む。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてパーティションデータのバックアップ、依存関係の事前チェック、監査ログへの記録を行う。削除操作はまだ実行されていないため、事前対策が可能である。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: DropPartitionsPreEvent
データベース: {database}
テーブル名: {name}
パーティション仕様: {partSpecs}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | パーティションが属するデータベース名 | dropPartitions()の引数db | Yes |
| name | パーティションが属するテーブル名 | dropPartitions()の引数table | Yes |
| partSpecs | 削除対象パーティション仕様のシーケンス | dropPartitions()の引数partSpecs | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.dropPartitions() | 常に発火（デリゲート先呼び出し前） | ALTER TABLE DROP PARTITION DDL実行時またはプログラムAPIからのパーティション削除時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventは常に発火される。デリゲート先の成否に関わらず発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[dropPartitions呼び出し] --> B[DropPartitionsPreEvent発火]
    B --> C[delegate.dropPartitions実行]
    C -->|成功| D[DropPartitionsEvent発火]
    C -->|例外| E[例外スロー - PostEvent発火なし]
    D --> F[ListenerBus経由で全リスナーに配信]
    F --> G[終了]
    E --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（PARTITIONS関連テーブル） | パーティション削除操作 | HiveExternalCatalog使用時 |

### テーブル別参照項目詳細

#### Hiveメタストア PARTITIONS テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| PART_NAME | 削除対象パーティションの存在確認 | database名、table名、partSpecで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。dropPartitions()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

DropPartitionsPreEventはデータベース名、テーブル名、パーティション仕様を含む。パーティション値にはビジネスデータが含まれる可能性がある。また、パーティション削除は破壊的操作であるため、監査ログリスナーの登録を推奨する。

## 備考

- DropPartitionsPreEventはDropPartitionsEventとペアで使用される。本イベント（PreEvent）は操作前、PostEventは操作後に発火される
- dropPartitions()はpartSpecsを直接引数として受け取る（createPartitionsのようにparts.map(_.spec)での変換は不要）
- dropPartitions()にはpurgeフラグとretainDataフラグがあるが、イベントにはこれらの情報は含まれない
- ignoreIfNotExists=trueの場合、パーティションが存在しなくてもPre/Post両イベントが発火される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 208-216行目: PartitionsEventトレイト。239-243行目: DropPartitionsPreEventケースクラス定義 |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | 1072行目: TablePartitionSpec型エイリアス |

**読解のコツ**: DropPartitionsPreEventのpartSpecsはdropPartitions()の引数から直接渡される（createPartitionsと異なりmap変換は不要）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 213-223行目: dropPartitions()メソッド。220行目でPreEvent発火、221行目でデリゲート実行、222行目でPostEvent発火 |

**主要処理フロー**:
1. **220行目**: postToAll(DropPartitionsPreEvent(db, table, partSpecs))でPreイベント発火
2. **221行目**: delegate.dropPartitions(db, table, partSpecs, ignoreIfNotExists, purge, retainData)
3. **222行目**: postToAll(DropPartitionsEvent(db, table, partSpecs))でPostイベント発火

#### Step 3: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 296-318行目: dropPartitionsテスト。300-304行目: 存在しないパーティション削除失敗時のPreEventのみ発火検証。307-311行目: 正常系Pre/Post検証。314-318行目: ignoreIfNotExists=true検証 |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.dropPartitions(db, table, partSpecs, ignoreIfNotExists, purge, retainData)
    |
    +-- postToAll(DropPartitionsPreEvent(db, table, partSpecs))
    |       |
    |       +-- doPostEvent(listener, event)
    |               +-- listener.onEvent(event)
    |
    +-- delegate.dropPartitions(db, table, partSpecs, ignoreIfNotExists, purge, retainData)
    |       |
    |       +-- InMemoryCatalog.dropPartitions() or HiveExternalCatalog.dropPartitions()
    |
    +-- postToAll(DropPartitionsEvent(db, table, partSpecs))  // 成功時のみ
```

### データフロー図

```
[入力]                              [処理]                                  [出力]

ALTER TABLE DROP PARTITION      ExternalCatalogWithListener             DropPartitionsPreEvent
  or API呼び出し ──────────▶      .dropPartitions()               ──────▶ (全リスナーへ配信)
  db, table, partSpecs              |                                    database, name, partSpecs
  ignoreIfNotExists,            delegate.dropPartitions()
  purge, retainData                 |（成功時）
                                DropPartitionsEvent ───────────────────▶ (成功時のみ配信)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | DropPartitionsPreEvent、PartitionsEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。dropPartitions()メソッド |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | TablePartitionSpec型エイリアスの定義 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | DropPartitionsPreEventの発火テスト |
