# 通知設計書 67-DropPartitionsEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおけるパーティション削除後イベント「DropPartitionsEvent」の設計仕様を記述する。DropPartitionsEventは、テーブルのパーティションが正常に削除された後に発火するイベント通知であり、ExternalCatalogEvent継承階層のPartitionsEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

DropPartitionsEventは、Spark SQLの外部カタログに登録されたテーブルのパーティションが正常に削除された後に、削除完了をリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLのパーティションテーブルでは、パーティションの削除完了をカタログレベルで監視する必要がある。DropPartitionsEventは、パーティション削除が正常に完了した後に発火することで、メタデータキャッシュの更新（削除されたパーティションの除去）、監査ログへの操作完了記録、UIの更新、および依存コンポーネントへの変更伝播を可能にする。Pre/Postイベントペアの「Post」側として、削除操作が正常に完了したことを保証する役割を持つ。

**通知の送信タイミング**：ExternalCatalogWithListener.dropPartitions()メソッド内で、デリゲート先の実際のカタログに対するdropPartitions()呼び出しが成功した直後にpostToAll()を通じて発火される。デリゲート先で例外が発生した場合（パーティション未存在時にignoreIfNotExists=falseなど）、本イベントは発火されない。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：パーティションが属するデータベース名（database: String）、テーブル名（name: String）、および削除されたパーティション仕様のシーケンス（partSpecs: Seq[TablePartitionSpec]）を含む。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてメタデータキャッシュからの当該パーティション情報の削除、UIの更新、監査ログへの完了記録を行う。削除が完了済みであるため、キャッシュの同期が主目的となる。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: DropPartitionsEvent
データベース: {database}
テーブル名: {name}
パーティション仕様: {partSpecs}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | パーティションが属するデータベース名 | dropPartitions()の引数db | Yes |
| name | パーティションが属するテーブル名 | dropPartitions()の引数table | Yes |
| partSpecs | 削除されたパーティション仕様のシーケンス | dropPartitions()の引数partSpecs | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.dropPartitions() | デリゲート先のdropPartitions()が例外なく完了すること | ALTER TABLE DROP PARTITION DDL実行時またはプログラムAPIからのパーティション削除完了時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デリゲート先で例外発生 | パーティション未存在（ignoreIfNotExists=false）等で例外が発生した場合、PostイベントであるDropPartitionsEventは発火されずPreEventのみとなる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[dropPartitions呼び出し] --> B[DropPartitionsPreEvent発火]
    B --> C[delegate.dropPartitions実行]
    C -->|成功| D[DropPartitionsEvent発火]
    C -->|例外| E[例外スロー - PostEvent発火なし]
    D --> F[ListenerBus経由で全リスナーに配信]
    F --> G[SparkContext.listenerBusへ転送]
    G --> H[終了]
    E --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（PARTITIONS関連テーブル） | パーティション削除操作 | HiveExternalCatalog使用時 |

### テーブル別参照項目詳細

#### Hiveメタストア PARTITIONS テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| PART_NAME | 削除対象パーティションの特定 | database名、table名、partSpecで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Hiveメタストア PARTITIONS テーブル | DELETE | パーティション定義の削除（デリゲート先で実行済み） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パーティション未存在 | 削除対象パーティションが存在せずignoreIfNotExists=falseの場合 | AnalysisExceptionがスローされる。PreEventは発火済み、PostEventは発火されない |
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。dropPartitions()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

DropPartitionsEventはデータベース名、テーブル名、パーティション仕様を含む。パーティション削除は破壊的操作であり、監査ログリスナーの登録を推奨する。purgeフラグやretainDataフラグの値はイベントに含まれないため、リスナー側で操作の詳細を把握する場合は別途確認が必要である。

## 備考

- DropPartitionsEventはDropPartitionsPreEventとペアで使用される。PreEventは操作前、本イベント（PostEvent）は操作後に発火される
- dropPartitions()のpurge, retainDataフラグはイベントには含まれない
- ignoreIfNotExists=trueの場合、パーティションが存在しなくてもPre/Post両イベントが発火される（テストコードで検証済み）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 208-216行目: PartitionsEventトレイト。248-252行目: DropPartitionsEventケースクラス定義 |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | 1072行目: TablePartitionSpec型エイリアス |

**読解のコツ**: DropPartitionsEventはDropPartitionsPreEvent（239-243行目）と対をなす。両者のフィールド構成は同一（database, name, partSpecs）である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 213-223行目: dropPartitions()メソッド。222行目でDropPartitionsEvent発火 |

**主要処理フロー**:
1. **220行目**: postToAll(DropPartitionsPreEvent(db, table, partSpecs))
2. **221行目**: delegate.dropPartitions(db, table, partSpecs, ignoreIfNotExists, purge, retainData)
3. **222行目**: postToAll(DropPartitionsEvent(db, table, partSpecs)) - 成功時のみ

#### Step 3: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 296-318行目: dropPartitionsテスト。300-304行目: 失敗時PreEventのみ。307-311行目: 正常系。314-318行目: ignoreIfNotExists=true |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.dropPartitions(db, table, partSpecs, ignoreIfNotExists, purge, retainData)
    |
    +-- postToAll(DropPartitionsPreEvent(db, table, partSpecs))
    |
    +-- delegate.dropPartitions(db, table, partSpecs, ignoreIfNotExists, purge, retainData)
    |       |
    |       +-- InMemoryCatalog.dropPartitions() or HiveExternalCatalog.dropPartitions()
    |
    +-- postToAll(DropPartitionsEvent(db, table, partSpecs))  // 成功時のみ
            |
            +-- doPostEvent(listener, event)
                    +-- listener.onEvent(event)
                            +-- sparkContext.listenerBus.post(event)
```

### データフロー図

```
[入力]                              [処理]                                  [出力]

ALTER TABLE DROP PARTITION      ExternalCatalogWithListener             DropPartitionsPreEvent
  or API呼び出し ──────────▶      .dropPartitions()               ──────▶ (常に配信)
  db, table, partSpecs              |
  ignoreIfNotExists,            delegate.dropPartitions()
  purge, retainData                 |（成功時）
                                DropPartitionsEvent ───────────────────▶ (成功時のみ配信)
                                  database, name, partSpecs
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | DropPartitionsEvent、PartitionsEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。dropPartitions()メソッド |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | TablePartitionSpec型エイリアスの定義 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | DropPartitionsEventの発火テスト |
