# 通知設計書 68-RenamePartitionsPreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおけるパーティションリネーム前イベント「RenamePartitionsPreEvent」の設計仕様を記述する。RenamePartitionsPreEventは、テーブルのパーティションがリネームされる直前に発火するイベント通知であり、ExternalCatalogEvent継承階層のPartitionsEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

RenamePartitionsPreEventは、Spark SQLの外部カタログに登録されたテーブルのパーティション仕様がリネーム（変更）される前に、操作の開始をリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLのパーティションテーブルでは、パーティションのリネーム操作をカタログレベルで事前に検知する必要がある。RenamePartitionsPreEventは、パーティション仕様が変更される前に発火することで、事前バリデーション、データ移行の準備、監査ログへの操作開始記録、および依存コンポーネントへの事前通知を可能にする。Pre/Postイベントペアの「Pre」側として、操作がこれから実行されることを通知する。パーティションのリネームはパーティション値の変更を意味し、例えば「year=2025」から「year=2026」への変更に相当する。

**通知の送信タイミング**：ExternalCatalogWithListener.renamePartitions()メソッド内で、デリゲート先の実際のカタログに対するrenamePartitions()呼び出しの直前にpostToAll()を通じて発火される。デリゲート先の成否にかかわらず必ず発火される。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：パーティションが属するデータベース名（database: String）、テーブル名（name: String）、リネーム前のパーティション仕様（partSpecs: Seq[TablePartitionSpec]）、およびリネーム後のパーティション仕様（newPartSpecs: Seq[TablePartitionSpec]）の4つのフィールドを含む。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてパーティションデータの移行準備、依存関係の事前チェック、監査ログへの記録を行う。操作はまだ実行されていないため、事前対策が可能である。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: RenamePartitionsPreEvent
データベース: {database}
テーブル名: {name}
旧パーティション仕様: {partSpecs}
新パーティション仕様: {newPartSpecs}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | パーティションが属するデータベース名 | renamePartitions()の引数db | Yes |
| name | パーティションが属するテーブル名 | renamePartitions()の引数table | Yes |
| partSpecs | リネーム前のパーティション仕様 | renamePartitions()の引数specs | Yes |
| newPartSpecs | リネーム後のパーティション仕様 | renamePartitions()の引数newSpecs | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.renamePartitions() | 常に発火（デリゲート先呼び出し前） | ALTER TABLE PARTITION RENAME DDL実行時またはプログラムAPIからのパーティションリネーム時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventは常に発火される。デリゲート先の成否に関わらず発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[renamePartitions呼び出し] --> B[RenamePartitionsPreEvent発火]
    B --> C[delegate.renamePartitions実行]
    C -->|成功| D[RenamePartitionsEvent発火]
    C -->|例外| E[例外スロー - PostEvent発火なし]
    D --> F[ListenerBus経由で全リスナーに配信]
    F --> G[終了]
    E --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（PARTITIONS関連テーブル） | パーティションリネーム操作 | HiveExternalCatalog使用時 |

### テーブル別参照項目詳細

#### Hiveメタストア PARTITIONS テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| PART_NAME | リネーム対象パーティションの特定 | database名、table名、旧partSpecで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。renamePartitions()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

RenamePartitionsPreEventはデータベース名、テーブル名、旧/新パーティション仕様を含む。パーティション値にはビジネスデータが含まれる可能性があるため、リスナーの実装において適切なアクセス制御を考慮する必要がある。

## 備考

- RenamePartitionsPreEventはRenamePartitionsEventとペアで使用される。本イベント（PreEvent）は操作前、PostEventは操作後に発火される
- PartitionsEventトレイトを継承するが、追加フィールドとしてnewPartSpecsを持つ（PartitionsEventのpartSpecsに加えて）
- partSpecsとnewPartSpecsは同じ長さのシーケンスであり、対応するインデックスの要素がリネーム前後のペアを表す
- リネーム対象パーティションが存在しない場合、デリゲート先でAnalysisExceptionがスローされPreEventのみ発火される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 208-216行目: PartitionsEventトレイト。257-262行目: RenamePartitionsPreEventケースクラス定義（database, name, partSpecs, newPartSpecsフィールド） |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | 1072行目: TablePartitionSpec型エイリアス |

**読解のコツ**: RenamePartitionsPreEventはPartitionsEventを継承するが、PartitionsEventで定義されているpartSpecsに加えてnewPartSpecsフィールドを持つ。これにより、リネーム前後のパーティション仕様の対応を表現する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 225-233行目: renamePartitions()メソッド。230行目でPreEvent発火 |

**主要処理フロー**:
1. **230行目**: postToAll(RenamePartitionsPreEvent(db, table, specs, newSpecs))でPreイベント発火
2. **231行目**: delegate.renamePartitions(db, table, specs, newSpecs)でデリゲート先に実行委譲
3. **232行目**: postToAll(RenamePartitionsEvent(db, table, specs, newSpecs))でPostイベント発火

#### Step 3: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 283-294行目: renamePartitionsテスト。284-287行目: 正常系Pre/Post検証。291-294行目: リネーム対象不存在時のPreEventのみ発火検証 |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.renamePartitions(db, table, specs, newSpecs)
    |
    +-- postToAll(RenamePartitionsPreEvent(db, table, specs, newSpecs))
    |       |
    |       +-- doPostEvent(listener, event)
    |               +-- listener.onEvent(event)
    |
    +-- delegate.renamePartitions(db, table, specs, newSpecs)
    |       |
    |       +-- InMemoryCatalog.renamePartitions() or HiveExternalCatalog.renamePartitions()
    |
    +-- postToAll(RenamePartitionsEvent(db, table, specs, newSpecs))  // 成功時のみ
```

### データフロー図

```
[入力]                              [処理]                                      [出力]

ALTER TABLE PARTITION RENAME     ExternalCatalogWithListener                 RenamePartitionsPreEvent
  or API呼び出し ──────────▶      .renamePartitions()                  ──────▶ (全リスナーへ配信)
  db, table, specs, newSpecs        |                                        database, name,
                                delegate.renamePartitions()                  partSpecs, newPartSpecs
                                    |（成功時）
                                RenamePartitionsEvent ─────────────────────▶ (成功時のみ配信)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | RenamePartitionsPreEvent、PartitionsEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。renamePartitions()メソッド |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | TablePartitionSpec型エイリアスの定義 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | RenamePartitionsPreEventの発火テスト |
