# 通知設計書 69-RenamePartitionsEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおけるパーティションリネーム後イベント「RenamePartitionsEvent」の設計仕様を記述する。RenamePartitionsEventは、テーブルのパーティションが正常にリネームされた後に発火するイベント通知であり、ExternalCatalogEvent継承階層のPartitionsEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

RenamePartitionsEventは、Spark SQLの外部カタログに登録されたテーブルのパーティション仕様がリネーム（変更）された後に、リネーム完了をリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLのパーティションテーブルでは、パーティションのリネーム完了をカタログレベルで監視する必要がある。RenamePartitionsEventは、パーティション仕様の変更が正常に完了した後に発火することで、メタデータキャッシュの更新（旧パーティション仕様の無効化と新パーティション仕様の登録）、監査ログへの操作完了記録、UIの更新、および依存コンポーネントへの変更伝播を可能にする。Pre/Postイベントペアの「Post」側として、リネーム操作が正常に完了したことを保証する役割を持つ。

**通知の送信タイミング**：ExternalCatalogWithListener.renamePartitions()メソッド内で、デリゲート先の実際のカタログに対するrenamePartitions()呼び出しが成功した直後にpostToAll()を通じて発火される。デリゲート先で例外が発生した場合、本イベントは発火されない（RenamePartitionsPreEventのみ発火される）。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：パーティションが属するデータベース名（database: String）、テーブル名（name: String）、リネーム前のパーティション仕様（partSpecs: Seq[TablePartitionSpec]）、およびリネーム後のパーティション仕様（newPartSpecs: Seq[TablePartitionSpec]）の4つのフィールドを含む。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてメタデータキャッシュの更新、旧パーティション仕様に基づくキャッシュの無効化、UIの更新、監査ログへの完了記録を行う。リネームが完了済みであるため、状態の同期が主目的となる。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: RenamePartitionsEvent
データベース: {database}
テーブル名: {name}
旧パーティション仕様: {partSpecs}
新パーティション仕様: {newPartSpecs}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | パーティションが属するデータベース名 | renamePartitions()の引数db | Yes |
| name | パーティションが属するテーブル名 | renamePartitions()の引数table | Yes |
| partSpecs | リネーム前のパーティション仕様 | renamePartitions()の引数specs | Yes |
| newPartSpecs | リネーム後のパーティション仕様 | renamePartitions()の引数newSpecs | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.renamePartitions() | デリゲート先のrenamePartitions()が例外なく完了すること | ALTER TABLE PARTITION RENAME DDL実行時またはプログラムAPIからのパーティションリネーム完了時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デリゲート先で例外発生 | リネーム対象パーティション未存在等で例外が発生した場合、PostイベントであるRenamePartitionsEventは発火されずPreEventのみとなる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[renamePartitions呼び出し] --> B[RenamePartitionsPreEvent発火]
    B --> C[delegate.renamePartitions実行]
    C -->|成功| D[RenamePartitionsEvent発火]
    C -->|例外| E[例外スロー - PostEvent発火なし]
    D --> F[ListenerBus経由で全リスナーに配信]
    F --> G[SparkContext.listenerBusへ転送]
    G --> H[終了]
    E --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（PARTITIONS関連テーブル） | パーティションリネーム操作 | HiveExternalCatalog使用時 |

### テーブル別参照項目詳細

#### Hiveメタストア PARTITIONS テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| PART_NAME | リネーム対象パーティションの特定と更新 | database名、table名、旧partSpecで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Hiveメタストア PARTITIONS テーブル | UPDATE | パーティション仕様のリネーム（デリゲート先で実行済み） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パーティション未存在 | リネーム対象パーティションが存在しない場合 | AnalysisExceptionがスローされる。PreEventは発火済み、PostEventは発火されない |
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。renamePartitions()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

RenamePartitionsEventはデータベース名、テーブル名、旧/新パーティション仕様を含む。パーティション値にはビジネスデータが含まれる可能性があるため、リスナーの実装において適切なアクセス制御を考慮する必要がある。

## 備考

- RenamePartitionsEventはRenamePartitionsPreEventとペアで使用される。PreEventは操作前、本イベント（PostEvent）は操作後に発火される
- PartitionsEventトレイトを継承するが、追加フィールドとしてnewPartSpecsを持つ
- partSpecsとnewPartSpecsは同じ長さのシーケンスであり、対応するインデックスの要素がリネーム前後のペアを表す
- テストコードで、リネーム済みパーティションを再度リネームしようとした場合にPreEventのみ発火されることが検証されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 208-216行目: PartitionsEventトレイト。267-272行目: RenamePartitionsEventケースクラス定義（database, name, partSpecs, newPartSpecsフィールド） |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | 1072行目: TablePartitionSpec型エイリアス |

**読解のコツ**: RenamePartitionsEventはRenamePartitionsPreEvent（257-262行目）と対をなす。両者のフィールド構成は同一（database, name, partSpecs, newPartSpecs）である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 225-233行目: renamePartitions()メソッド。232行目でRenamePartitionsEvent発火 |

**主要処理フロー**:
1. **230行目**: postToAll(RenamePartitionsPreEvent(db, table, specs, newSpecs))
2. **231行目**: delegate.renamePartitions(db, table, specs, newSpecs)
3. **232行目**: postToAll(RenamePartitionsEvent(db, table, specs, newSpecs)) - 成功時のみ

#### Step 3: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 283-294行目: renamePartitionsテスト。284-287行目: 正常系。291-294行目: 失敗時PreEventのみ |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.renamePartitions(db, table, specs, newSpecs)
    |
    +-- postToAll(RenamePartitionsPreEvent(db, table, specs, newSpecs))
    |
    +-- delegate.renamePartitions(db, table, specs, newSpecs)
    |       |
    |       +-- InMemoryCatalog.renamePartitions() or HiveExternalCatalog.renamePartitions()
    |
    +-- postToAll(RenamePartitionsEvent(db, table, specs, newSpecs))  // 成功時のみ
            |
            +-- doPostEvent(listener, event)
                    +-- listener.onEvent(event)
                            +-- sparkContext.listenerBus.post(event)
```

### データフロー図

```
[入力]                              [処理]                                      [出力]

ALTER TABLE PARTITION RENAME     ExternalCatalogWithListener                 RenamePartitionsPreEvent
  or API呼び出し ──────────▶      .renamePartitions()                  ──────▶ (常に配信)
  db, table, specs, newSpecs        |
                                delegate.renamePartitions()
                                    |（成功時）
                                RenamePartitionsEvent ─────────────────────▶ (成功時のみ配信)
                                  database, name, partSpecs, newPartSpecs
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | RenamePartitionsEvent、PartitionsEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。renamePartitions()メソッド |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | TablePartitionSpec型エイリアスの定義 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | RenamePartitionsEventの発火テスト |
