# 通知設計書 7-SparkListenerJobStart

## 概要

本ドキュメントは、Apache Sparkのコアイベント通知である`SparkListenerJobStart`の設計について記述する。このイベントは、ジョブの実行が開始された際に発火するイベント通知である。

### 本通知の処理概要

SparkListenerJobStartは、Sparkアプリケーション内でRDDアクション（collect, count, save等）がトリガーしたジョブの開始をリスナーに通知するイベントである。

**業務上の目的・背景**：ジョブの開始はSparkアプリケーションの実行において最も重要な境界イベントの一つである。Spark UIのジョブタブにおけるジョブ一覧の表示、ジョブに含まれるステージの関連付け、ジョブの実行時間の計測開始、フェアスケジューラのプール割り当て情報の記録など、多くの用途に利用される。ExecutorAllocationManagerはジョブ開始時にリソース要求の計算を更新する。

**通知の送信タイミング**：DAGSchedulerの複数箇所から発火する。(1) handleJobSubmitted（L1443-1445）: 通常のジョブ送信時にfinalStageとそのステージ情報と共にpost。(2) handleMapStageSubmitted（L1490-1492）: MapStageジョブの送信時。(3) submitJob（L973-974）: パーティションが空のジョブで即座にJobStartとJobEndが連続post。(4) runApproximateJob（L1054）: 近似ジョブで空パーティションの場合。

**通知の受信者**：SparkListenerInterfaceを実装し、LiveListenerBusに登録されたすべてのリスナーが受信する。

**通知内容の概要**：jobId、time（ジョブ送信時刻）、stageInfos（ジョブに含まれる全ステージの情報）、properties（ジョブプロパティ、フェアスケジューラプール名等）を含む。また、stageInfosから派生した`stageIds`フィールドも持つ。

**期待されるアクション**：受信したリスナーは、ジョブの実行状態をUIに反映する、イベントログに記録する、リソース管理の判断材料とする。

## 通知種別

アプリ内通知（Sparkイベントバス経由の非同期インプロセス通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

LiveListenerBusに登録された全リスナーに対してブロードキャスト配信される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、Sparkイベントバス経由のインプロセス通知である。

### 本文テンプレート

```
イベントクラス: SparkListenerJobStart
シリアライズ形式: JSON（Jackson, @JsonTypeInfo）

{
  "Event": "org.apache.spark.scheduler.SparkListenerJobStart",
  "Job ID": <int>,
  "Submission Time": <long>,
  "Stage Infos": [ ... ],
  "Stage IDs": [ ... ],
  "Properties": { ... }
}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| 該当なし | - | - | インプロセス通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobId | ジョブID | nextJobId.getAndIncrement() | Yes |
| time | ジョブ送信時刻（ミリ秒） | clock.getTimeMillis() / jobSubmissionTime | Yes |
| stageInfos | ジョブに含まれる全ステージの情報 | stageIdToStage.get(id).map(_.latestInfo) | Yes |
| properties | ジョブプロパティ | Utils.cloneProperties(properties) | No（デフォルトnull） |
| stageIds | ステージIDリスト（派生フィールド） | stageInfos.map(_.stageId) | Yes（自動計算） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジューラ内部処理 | DAGScheduler.handleJobSubmitted | ジョブ送信時 | DAGScheduler.scala L1443-1445 |
| スケジューラ内部処理 | DAGScheduler.handleMapStageSubmitted | MapStageジョブ送信時 | DAGScheduler.scala L1490-1492 |
| スケジューラ内部処理 | DAGScheduler.submitJob（空パーティション） | 0タスクのジョブ | DAGScheduler.scala L973-974 |
| スケジューラ内部処理 | DAGScheduler.runApproximateJob（空パーティション） | 0タスクの近似ジョブ | DAGScheduler.scala L1054 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| LiveListenerBus停止後 | イベントは配信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[RDDアクション呼び出し] --> B[DAGScheduler.submitJob]
    B --> C{パーティションが空?}
    C -->|Yes| D[即座にJobStart+JobEnd post]
    C -->|No| E[eventProcessLoop.post JobSubmitted]
    E --> F[handleJobSubmitted]
    F --> G[finalStage生成]
    G --> H[stageInfos収集]
    H --> I[SparkListenerJobStart生成]
    I --> J[listenerBus.post]
    J --> K[submitStage呼び出し]
    K --> L[終了]
    D --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| KVStore | AppStatusListenerがジョブ情報を格納 | UI表示用 |

### テーブル別参照項目詳細

#### KVStore

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| JobDataWrapper | ジョブの実行状態情報 | jobIdで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| KVStore | INSERT | AppStatusListenerがJobDataWrapperを新規作成 |
| イベントログファイル | APPEND | イベントをJSON記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | JobDataWrapper | ジョブ状態=RUNNING | AppStatusListenerによる新規作成 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キューオーバーフロー | イベント生成速度超過 | イベントドロップ |
| リスナー例外 | onJobStart内で例外 | 例外キャッチ、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| キュー容量 | デフォルト10,000イベント |

### 配信時間帯

時間帯制限なし。

## セキュリティ考慮事項

- PropertiesにはSpark設定情報やフェアスケジューラプール名が含まれる
- StageInfoにはユーザーコードのcallSite情報が含まれる

## 備考

- SparkListenerJobStartは4フィールドのケースクラスであり、加えて`stageIds`という派生valフィールドを持つ（SparkListener.scala L79-88）
- stageIdsは後方互換性のために残されているフィールドで、旧バージョンではstageInfosではなくstageIdsのみが保存されていた（L85-87コメント）
- propertiesのデフォルト値はnull（L83）
- 空パーティションのジョブではstageInfosがSeq.emptyまたはSeq[StageInfo]()でpost後、即座にJobEndもpostされる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | L79-88: SparkListenerJobStartケースクラス。4フィールド（jobId, time, stageInfos, properties）+派生val stageIds |

**読解のコツ**: L85-87のコメントに後方互換性の理由が記されている。`stageIds`はstageInfosから自動計算される`val stageIds: Seq[Int] = stageInfos.map(_.stageId)`。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | L1443-1445: handleJobSubmittedでのpost。L1490-1492: handleMapStageSubmittedでのpost |
| 2-2 | DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | L973-974: submitJobの空パーティションパス。L1054: runApproximateJobの空パーティションパス |

**主要処理フロー（handleJobSubmitted）**:
1. **L1422**: ActiveJobオブジェクトを生成
2. **L1432**: jobSubmissionTimeを取得
3. **L1439**: finalStageにActiveJobを設定
4. **L1440-1442**: stageInfosを収集
5. **L1443-1445**: `SparkListenerJobStart(job.jobId, jobSubmissionTime, stageInfos, Utils.cloneProperties(properties))`を生成しpost
6. **L1446**: submitStage(finalStage)を呼び出し

#### Step 3: イベントディスパッチを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | L36-37: SparkListenerJobStartのパターンマッチ → listener.onJobStart()呼び出し |

### プログラム呼び出し階層図

```
SparkContext.runJob() / submitJob()
    |
    +-- DAGScheduler.submitJob() [DAGScheduler.scala L946]
            |
            +-- [空パーティション] listenerBus.post(SparkListenerJobStart(...)) [L973]
            |
            +-- [通常] eventProcessLoop.post(JobSubmitted(...))
                    |
                    +-- DAGScheduler.handleJobSubmitted() [L1443]
                            |
                            +-- listenerBus.post(SparkListenerJobStart(...))
                                    |
                                    +-- LiveListenerBus.post()
                                            |
                                            +-- listener.onJobStart()
```

### データフロー図

```
[入力]                         [処理]                            [出力]

DAGScheduler               LiveListenerBus                   各リスナー
(jobId, time,             (AsyncEventQueue x N)
 stageInfos, properties)
                                                              AppStatusListener
jobId, time ------------> SparkListenerJobStart ------------> (KVStore更新)
stageInfos                                                    EventLoggingListener
properties                                                    (イベントログ)
stageIds (派生)                                               ExecutorAllocationManager
                                                              (リソース管理)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | SparkListenerJobStartケースクラス定義（L79-88） |
| DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | ソース | 複数箇所からのイベント発火（L973, L1054, L1443, L1490） |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ（L36-37） |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期配信制御 |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | UI用ジョブステータス更新 |
