# 通知設計書 70-AlterPartitionsPreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおけるパーティション変更前イベント「AlterPartitionsPreEvent」の設計仕様を記述する。AlterPartitionsPreEventは、テーブルのパーティションが変更される直前に発火するイベント通知であり、ExternalCatalogEvent継承階層のPartitionsEventトレイトを実装するケースクラスとして定義されている。

### 本通知の処理概要

AlterPartitionsPreEventは、Spark SQLの外部カタログに登録されたテーブルのパーティション定義が変更される前に、操作の開始をリスナーに通知するためのイベントである。

**業務上の目的・背景**：Spark SQLのパーティションテーブルでは、パーティションのメタデータ変更操作（ストレージフォーマット、パラメータなどの変更）をカタログレベルで事前に検知する必要がある。AlterPartitionsPreEventは、パーティション定義の変更が実行される前に発火することで、事前バリデーション、現在のパーティション状態のスナップショット取得、監査ログへの操作開始記録、および依存コンポーネントへの事前通知を可能にする。Pre/Postイベントペアの「Pre」側として、変更操作がこれから実行されることを通知する。

**通知の送信タイミング**：ExternalCatalogWithListener.alterPartitions()メソッド内で、CatalogTablePartitionのSeqからpartSpecsを抽出した後、デリゲート先の実際のカタログに対するalterPartitions()呼び出しの直前にpostToAll()を通じて発火される。デリゲート先の成否にかかわらず必ず発火される。

**通知の受信者**：ExternalCatalogEventListenerインターフェースを実装し、ExternalCatalogWithListenerに登録されたすべてのリスナーが受信する。SharedState初期化時にSparkContext.listenerBusへの転送リスナーが登録されるため、SparkListenerBus上の全リスナーにも配信される。

**通知内容の概要**：パーティションが属するデータベース名（database: String）、テーブル名（name: String）、および変更対象のパーティション仕様のシーケンス（partSpecs: Seq[TablePartitionSpec]）を含む。変更後のパーティション定義の詳細（ストレージフォーマットやパラメータなど）は含まれない。

**期待されるアクション**：リスナーは本イベントを受信後、必要に応じてパーティションの現在の状態のスナップショット取得、依存関係の事前チェック、監査ログへの記録を行う。操作はまだ実行されていないため、事前対策が可能である。

## 通知種別

アプリケーション内イベント通知（Sparkイベントバス経由の同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため） |

### 送信先決定ロジック

ExternalCatalogWithListenerのListenerBusに登録された全ExternalCatalogEventListenerに対して順次配信される。SharedState初期化時に登録される転送リスナーにより、SparkContext.listenerBus経由でSparkListenerEventとしても全SparkListenerに配信される。

## 通知テンプレート

### メール通知の場合

本通知はアプリケーション内イベント通知であり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベント種別: AlterPartitionsPreEvent
データベース: {database}
テーブル名: {name}
パーティション仕様: {partSpecs}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | パーティションが属するデータベース名 | alterPartitions()の引数db | Yes |
| name | パーティションが属するテーブル名 | alterPartitions()の引数table | Yes |
| partSpecs | 変更対象パーティション仕様のシーケンス | parts.map(_.spec)で抽出 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.alterPartitions() | 常に発火（デリゲート先呼び出し前） | ALTER TABLE PARTITION DDL実行時またはプログラムAPIからのパーティション変更時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventは常に発火される。デリゲート先の成否に関わらず発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[alterPartitions呼び出し] --> B[parts.map_.specでpartSpecs抽出]
    B --> C[AlterPartitionsPreEvent発火]
    C --> D[delegate.alterPartitions実行]
    D -->|成功| E[AlterPartitionsEvent発火]
    D -->|例外| F[例外スロー - PostEvent発火なし]
    E --> G[ListenerBus経由で全リスナーに配信]
    G --> H[終了]
    F --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Hiveメタストア（PARTITIONS関連テーブル） | パーティション変更操作 | HiveExternalCatalog使用時 |

### テーブル別参照項目詳細

#### Hiveメタストア PARTITIONS テーブル（HiveExternalCatalog使用時）

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| PART_NAME | 変更対象パーティションの特定 | database名、table名、partSpecで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベント送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー内例外 | リスナーのonEvent()内で例外が発生した場合 | ListenerBusがログに記録し、他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A（同期配信のためリトライ機構なし） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限はない。alterPartitions()が呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

AlterPartitionsPreEventはデータベース名、テーブル名、パーティション仕様を含む。パーティション値にはビジネスデータが含まれる可能性があるため、リスナーの実装において適切なアクセス制御を考慮する必要がある。変更後のパーティション定義の詳細はイベントに含まれないため、変更内容を確認するにはカタログに直接問い合わせる必要がある。

## 備考

- AlterPartitionsPreEventはAlterPartitionsEventとペアで使用される。本イベント（PreEvent）は操作前、PostEventは操作後に発火される
- PartitionsEventトレイトを継承する（newPartSpecsのような追加フィールドは持たない）
- partSpecsはCatalogTablePartition.specから抽出される（parts.map(_.spec)）。これはcreatePartitions()と同様のパターンである
- alterPartitions()はパーティションのメタデータ（ストレージフォーマット、パラメータ等）を変更するが、パーティション仕様自体（キーと値）は変更しない。パーティション仕様の変更にはrenamePartitions()を使用する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 208-216行目: PartitionsEventトレイト（database, name, partSpecsフィールド）。277-280行目: AlterPartitionsPreEventケースクラス定義 |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | 1072行目: TablePartitionSpec型エイリアス（Map[String, String]）。197行目: CatalogTablePartition.specフィールド |

**読解のコツ**: AlterPartitionsPreEventはPartitionsEventをそのまま継承し、追加フィールドは持たない（RenamePartitionsPreEventのnewPartSpecsとは異なる）。これは、alter操作がパーティション仕様自体ではなくパーティションのメタデータを変更するためである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 235-243行目: alterPartitions()メソッド。239行目でparts.map(_.spec)によるpartSpecs抽出、240行目でPreEvent発火 |

**主要処理フロー**:
1. **239行目**: val partSpecs = parts.map(_.spec) でCatalogTablePartitionからパーティション仕様を抽出
2. **240行目**: postToAll(AlterPartitionsPreEvent(db, table, partSpecs))でPreイベント発火
3. **241行目**: delegate.alterPartitions(db, table, parts)でデリゲート先に実行委譲
4. **242行目**: postToAll(AlterPartitionsEvent(db, table, partSpecs))でPostイベント発火

#### Step 3: テストコードで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 276-281行目: alterPartitionsテスト。Pre/Postイベントペアの発火検証 |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.alterPartitions(db, table, parts)
    |
    +-- parts.map(_.spec)  // CatalogTablePartitionからpartSpecsを抽出
    |
    +-- postToAll(AlterPartitionsPreEvent(db, table, partSpecs))
    |       |
    |       +-- doPostEvent(listener, event)
    |               +-- listener.onEvent(event)
    |
    +-- delegate.alterPartitions(db, table, parts)
    |       |
    |       +-- InMemoryCatalog.alterPartitions() or HiveExternalCatalog.alterPartitions()
    |
    +-- postToAll(AlterPartitionsEvent(db, table, partSpecs))  // 成功時のみ
```

### データフロー図

```
[入力]                              [処理]                                  [出力]

ALTER TABLE PARTITION           ExternalCatalogWithListener             AlterPartitionsPreEvent
  or API呼び出し ──────────▶      .alterPartitions()              ──────▶ (全リスナーへ配信)
  db, table,                        |                                    database, name, partSpecs
  parts(CatalogTablePartition)  parts.map(_.spec) → partSpecs
                                    |
                                delegate.alterPartitions()
                                    |（成功時）
                                AlterPartitionsEvent ──────────────────▶ (成功時のみ配信)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | AlterPartitionsPreEvent、PartitionsEvent、ExternalCatalogEventの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を含むカタログラッパー。alterPartitions()メソッド |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | CatalogTablePartition、TablePartitionSpec型エイリアスの定義 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化とSparkListenerBusへの転送設定 |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | postToAll()によるリスナー配信メカニズム |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | AlterPartitionsPreEventの発火テスト |
