# 通知設計書 74-QueryIdleEvent

## 概要

本ドキュメントは、Apache SparkのStructured Streamingにおいて、ストリーミングクエリがアイドル状態で新データ待ちの際に発火されるイベント通知「QueryIdleEvent」の設計を記述する。

### 本通知の処理概要

QueryIdleEventは、Structured Streamingのクエリが新しいデータの到着を待っているアイドル状態にある場合に定期的に発火されるイベント通知である。Since 3.5.0で導入された比較的新しいイベントであり、クエリが長時間データなしの状態が続いた際に、クエリがまだ生存していることを示すハートビート的な役割を果たす。

**業務上の目的・背景**：ストリーミングクエリの運用監視において、QueryProgressEventが発火されない期間が長く続くと、クエリが停止しているのか単にデータがないだけなのかの区別がつかない。QueryIdleEventは、クエリがアクティブだがデータがない状態を明示的に通知することで、運用担当者がクエリの生存確認を行えるようにする。データパイプラインの上流障害検知にも活用可能である。

**通知の送信タイミング**：ProgressReporter.updateIdlenessメソッドにおいて、`noDataProgressEventInterval`（デフォルト10秒、`spark.sql.streaming.noDataProgressEventInterval`で設定）の間隔以上経過し、かつ初回のアイドル判定時ではない場合に発火される。最初のアイドル判定ではprogressのみ更新し、2回目以降でイベントが発火される仕様となっている。

**通知の受信者**：StreamingQueryListenerインタフェースを実装し、SparkSessionのStreamingQueryManagerに登録されたすべてのリスナーが受信する。onQueryIdleメソッドにはデフォルト実装（空実装）があるため、既存リスナーとの後方互換が維持されている。

**通知内容の概要**：クエリの永続ID（id: UUID）、実行ID（runId: UUID）、最新のノーバッチトリガーのタイムスタンプ（timestamp: String）が含まれる。

**期待されるアクション**：リスナーは通知を受けて、クエリの生存確認ステータスの更新、データソースの健全性チェックのトリガー、長時間アイドル状態のアラート発報、監視ダッシュボードの更新などを実行することが期待される。

## 通知種別

アプリ内通知（StreamingQueryListenerBus + Spark LiveListenerBus経由の非同期イベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Spark LiveListenerBus経由で非同期配信） |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

StreamingQueryListenerBusに登録されたすべてのStreamingQueryListenerに対して配信される。doPostEvent内でactiveQueryRunIdsに含まれるrunIdのイベントのみがリスナーに配信される。onQueryIdleにはデフォルト実装（空メソッド）があるため、このイベントに関心のないリスナーは何もしない。

## 通知テンプレート

### メール通知の場合

該当なし。本イベントはSpark内部のリスナーバスを通じたプログラム内通知である。

### 本文テンプレート

```json
{
  "id": "{id}",
  "runId": "{runId}",
  "timestamp": "{timestamp}"
}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| id | クエリの永続一意ID | StreamExecution.id | Yes |
| runId | 実行ごとの一意ID | StreamExecution.runId | Yes |
| timestamp | 最新ノーバッチトリガーのタイムスタンプ（ISO8601形式） | ProgressReporter.formatTimestamp(currentTriggerStartTimestamp) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| タイマー | トリガー実行時にデータなし | noDataProgressEventInterval経過かつ初回判定でない | ProgressReporter.updateIdlenessで発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 初回アイドル判定 | lastNoExecutionProgressEventTimeがLong.MinValueの場合（初回判定時）はイベントを発火せず、タイムスタンプのみ更新 |
| 間隔未経過 | noDataProgressEventInterval未経過の場合はイベントを発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[トリガー実行・データなし] --> B[ProgressReporter.updateIdleness呼び出し]
    B --> C{now - noDataProgressEventInterval >= lastNoExecutionProgressEventTime?}
    C -->|No| D[スキップ]
    C -->|Yes| E[addNewProgress]
    E --> F{lastNoExecutionProgressEventTime > Long.MinValue?}
    F -->|No 初回| G[lastNoExecutionProgressEventTime更新のみ]
    F -->|Yes 2回目以降| H[QueryIdleEvent生成・postEvent]
    H --> I[StreamingQueryListenerBus.post]
    I --> J[SparkListenerBus.post 非同期]
    J --> K[listener.onQueryIdle]
    G --> L[lastNoExecutionProgressEventTime = now]
    K --> L
    D --> M[終了]
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。本イベントはメモリ上の状態情報から生成される。

### 更新テーブル一覧

該当なし。

#### 送信ログテーブル

Sparkイベントログが有効な場合、SparkListenerEventとしてイベントログに記録される。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonQueryIdleメソッドで例外発生 | ListenerBusが例外をキャッチしてログ出力。他のリスナーへの配信は継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | noDataProgressEventIntervalに依存（デフォルト10秒間隔） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。アイドル状態のトリガー実行時に発火される。

## セキュリティ考慮事項

- イベントにはクエリIDとタイムスタンプのみが含まれ、機密情報は含まれない
- イベントはSparkプロセス内部でのみ配信される

## 備考

- QueryIdleEventはSince 3.5.0で導入された比較的新しいイベント
- StreamingQueryListener.onQueryIdleにはデフォルト実装（空メソッド）があり、後方互換が維持されている
- noDataProgressEventIntervalはspark.sql.streaming.noDataProgressEventIntervalで設定可能
- 初回のアイドル判定ではイベントが発火されない設計は、クエリ開始直後の誤検知を防ぐ目的がある
- QueryProgressEventのように進捗情報オブジェクトではなく、シンプルなid, runId, timestampのみを含む

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StreamingQueryListener.scala | `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` | QueryIdleEventクラス（237-248行目）のフィールド定義（id, runId, timestamp）。Since 3.5.0のアノテーションを確認 |
| 1-2 | StreamingQueryListener.scala | `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` | onQueryIdleメソッド（74行目）のデフォルト実装（空メソッド）を確認 |

**読解のコツ**: QueryIdleEventはQueryStartedEventと同様にid, runId, timestampを持つが、nameやjobTagsは含まない。最小限の生存確認情報のみを持つ設計。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProgressReporter.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/ProgressReporter.scala` | updateIdlenessメソッド（112-128行目）でのイベント発火条件とロジック。noDataProgressEventIntervalとlastNoExecutionProgressEventTimeの関係を理解 |

**主要処理フロー**:
1. **117行目**: `val now = triggerClock.getTimeMillis()` - 現在時刻取得
2. **118行目**: `if (now - noDataProgressEventInterval >= lastNoExecutionProgressEventTime)` - 間隔チェック
3. **119行目**: `addNewProgress(newProgress)` - progressBuffer更新
4. **120行目**: `if (lastNoExecutionProgressEventTime > Long.MinValue)` - 初回判定チェック
5. **121行目**: `postEvent(new QueryIdleEvent(id, runId, formatTimestamp(...)))` - イベント発火
6. **126行目**: `lastNoExecutionProgressEventTime = now` - タイムスタンプ更新

#### Step 3: リスナーバスの配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingQueryListenerBus.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` | doPostEvent（137-139行目）でshouldReportチェック後にlistener.onQueryIdleを呼び出し |

### プログラム呼び出し階層図

```
MicroBatchExecution（データなしトリガー）
    |
    +-- ProgressReporter.updateIdleness(id, runId, timestamp, progress)
            |
            +-- [間隔チェック: now - interval >= lastTime]
            |
            +-- addNewProgress(newProgress)
            |
            +-- [初回判定チェック: lastTime > Long.MinValue]
            |
            +-- postEvent(new QueryIdleEvent(id, runId, timestamp))
                    |
                    +-- SparkSession.streams.postListenerEvent(event)
                            |
                            +-- StreamingQueryListenerBus.post(event)
                                    |
                                    +-- sparkListenerBus.post(event)  [非同期]
                                            |
                                            +-- doPostEvent(listener, event)
                                                    |
                                                    +-- listener.onQueryIdle(event)
```

### データフロー図

```
[入力]                          [処理]                           [出力]

id, runId              --->  ProgressReporter            --->  QueryIdleEvent
currentTriggerStart           .updateIdleness()                  |
Timestamp                     |                                  v
noDataProgress           [間隔チェック]                     StreamingQueryListenerBus
EventInterval            [初回判定チェック]                     .post()
                                                                 |
                                                                 v
                                                           StreamingQueryListener
                                                             .onQueryIdle()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingQueryListener.scala | `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` | ソース | QueryIdleEventクラス定義（237-248行目）、onQueryIdleデフォルト実装（74行目） |
| ProgressReporter.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/ProgressReporter.scala` | ソース | イベント発火元updateIdleness（112-128行目） |
| StreamingQueryListenerBus.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamingQueryListenerBus.scala` | ソース | イベント配信バス（137-139行目） |
| StreamExecution.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/StreamExecution.scala` | ソース | ストリーミングクエリ実行基盤 |
