# 通知設計書 76-StreamingListenerStreamingStarted

## 概要

本ドキュメントは、Apache SparkのDStream（Discretized Stream）ベースのStreaming処理において、Streaming処理が開始された際に発火されるイベント通知「StreamingListenerStreamingStarted」の設計を記述する。

### 本通知の処理概要

StreamingListenerStreamingStartedは、StreamingContextが開始されStreaming処理がアクティブ状態になった際に発火されるイベント通知である。Streaming処理の開始時刻を含み、登録されたStreamingListenerに配信される。DStreamベースのSpark Streamingの起動完了を監視するための基本的なイベントである。

**業務上の目的・背景**：DStreamベースのSpark Streamingアプリケーションの運用監視において、Streaming処理の開始を正確に検知することは基本要件である。StreamingListenerStreamingStartedにより、アプリケーションの起動完了を検知し、監視の開始、ダッシュボードの更新、運用ログへの記録などのアクションを実行できる。クラスタ管理ツールとの連携にも利用される。

**通知の送信タイミング**：StreamingContext.start()メソッドの内部で、JobSchedulerの起動完了後、状態がACTIVEに遷移した直後に`scheduler.listenerBus.post`を通じて発火される。System.currentTimeMillis()で取得した現在時刻がイベントのtimeフィールドとして使用される。

**通知の受信者**：StreamingListenerインタフェースを実装し、StreamingContext.addStreamingListener()で登録されたすべてのリスナーが受信する。onStreamingStartedメソッドにはデフォルト実装（空メソッド）があるため、必要なイベントのみを処理するリスナーの実装が可能。

**通知内容の概要**：Streaming処理の開始時刻（time: Long、エポックミリ秒）のみが含まれる。

**期待されるアクション**：リスナーは通知を受けて、Streaming処理の開始記録、監視開始、UIの初期化、動的リソース割り当ての開始などを実行することが期待される。

## 通知種別

アプリ内通知（StreamingListenerBus経由。WrappedStreamingListenerEventとしてSpark LiveListenerBusにラップして非同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（StreamingListenerBusがWrappedStreamingListenerEventとしてSparkListenerBusにpost） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

StreamingListenerBusに登録されたすべてのStreamingListenerに対して配信される。StreamingListenerBusはSparkのLiveListenerBusにWrappedStreamingListenerEventとしてイベントをポストし、それをonOtherEventで受信してStreamingListenerに配信する。

## 通知テンプレート

### メール通知の場合

該当なし。本イベントはSpark内部のリスナーバスを通じたプログラム内通知である。

### 本文テンプレート

```
イベント型: StreamingListenerStreamingStarted
開始時刻: {time} (エポックミリ秒)
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | Streaming処理の開始時刻（エポックミリ秒） | System.currentTimeMillis() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | StreamingContext.start() | 状態がACTIVEに遷移後 | JobScheduler起動完了後に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 起動失敗 | StreamingContextの起動中に例外が発生した場合、ACTIVEに遷移せずイベントは発火されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[StreamingContext.start 呼び出し] --> B[バリデーション チェック]
    B --> C[JobScheduler.start]
    C --> D[state = ACTIVE]
    D --> E[StreamingListenerStreamingStarted生成]
    E --> F[scheduler.listenerBus.post]
    F --> G[WrappedStreamingListenerEventにラップ]
    G --> H[SparkListenerBus.post 非同期]
    H --> I[onOtherEvent: アンラップ]
    I --> J[postToAll: 各リスナーに配信]
    J --> K[listener.onStreamingStarted]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。

### 更新テーブル一覧

該当なし。

#### 送信ログテーブル

WrappedStreamingListenerEventのlogEventがfalseに設定されているため（SPARK-12140）、Sparkイベントログには記録されない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonStreamingStartedメソッドで例外発生 | ListenerBusが例外をキャッチしてログ出力。他のリスナーへの配信は継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（StreamingContext起動時のみ発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。StreamingContext起動時に発火される。

## セキュリティ考慮事項

- イベントにはタイムスタンプのみが含まれ、機密情報は含まれない
- イベントはSparkプロセス内部でのみ配信される

## 備考

- StreamingListenerStreamingStartedはStreamingListenerEvent sealed traitを継承するcase class
- @DeveloperApiアノテーションが付与されており、開発者向けAPIとして提供
- WrappedStreamingListenerEventはlogEvent=falseのため、Sparkイベントログには記録されない（SPARK-12140）
- DStreamベースのSpark StreamingはStructured Streamingに置き換えられつつあるレガシーAPI

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | StreamingListenerStreamingStartedのcase class定義（33行目）。timeフィールド（Long型）のみを持つシンプルな構造 |
| 1-2 | StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | StreamingListenerEventのsealed trait定義（30行目）とStreamingListenerのonStreamingStartedメソッド（73行目） |

**読解のコツ**: StreamingListenerEventはsealed traitであり、同一ファイル内で定義されたcase classのみがサブタイプとなる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StreamingContext.scala | `streaming/src/main/scala/org/apache/spark/streaming/StreamingContext.scala` | start()メソッド内（598-599行目）でのイベント発火。state=ACTIVE設定後にscheduler.listenerBus.postで配信 |

**主要処理フロー**:
1. **597行目**: `state = StreamingContextState.ACTIVE` - 状態遷移
2. **598-599行目**: `scheduler.listenerBus.post(StreamingListenerStreamingStarted(System.currentTimeMillis()))` - イベント発火

#### Step 3: リスナーバスの配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | postメソッド（36-38行目）でWrappedStreamingListenerEventにラップしてSparkListenerBusにpost |
| 3-2 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | onOtherEventメソッド（40-46行目）でアンラップしてpostToAll |
| 3-3 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | doPostEvent（48-72行目）のcase分岐（68-69行目）でlistener.onStreamingStartedを呼び出し |

### プログラム呼び出し階層図

```
StreamingContext.start()
    |
    +-- scheduler.start()  [JobScheduler起動]
    |
    +-- state = ACTIVE
    |
    +-- scheduler.listenerBus.post(StreamingListenerStreamingStarted(time))
            |
            +-- sparkListenerBus.post(WrappedStreamingListenerEvent(event))  [非同期]
                    |
                    +-- StreamingListenerBus.onOtherEvent(wrappedEvent)
                            |
                            +-- postToAll(unwrappedEvent)
                                    |
                                    +-- doPostEvent(listener, event)
                                            |
                                            +-- listener.onStreamingStarted(event)
```

### データフロー図

```
[入力]                         [処理]                             [出力]

System.currentTimeMillis() --> StreamingContext.start()    --> StreamingListenerStreamingStarted
                                    |                              |
                                    v                              v
                               StreamingListenerBus          StreamingListener
                                 .post(event)                  .onStreamingStarted()
                                    |
                                    v
                               WrappedStreamingListenerEvent
                                    |
                                    v
                               SparkListenerBus (非同期)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | ソース | イベントクラス定義（33行目）、リスナーインタフェース（73行目） |
| StreamingContext.scala | `streaming/src/main/scala/org/apache/spark/streaming/StreamingContext.scala` | ソース | イベント発火元（598-599行目） |
| StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | ソース | イベント配信バス（36-38行目、68-69行目） |
| JobScheduler.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` | ソース | listenerBusの所有者（57行目） |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | UI用リスナー実装（71行目） |
