# 通知設計書 77-StreamingListenerBatchSubmitted

## 概要

本ドキュメントは、Apache SparkのDStream（Discretized Stream）ベースのStreaming処理において、バッチジョブが処理のために送信された際に発火されるイベント通知「StreamingListenerBatchSubmitted」の設計を記述する。

### 本通知の処理概要

StreamingListenerBatchSubmittedは、DStreamベースのSpark Streamingにおいて、JobGeneratorが生成したバッチのジョブセットがJobSchedulerに送信された際に発火されるイベント通知である。バッチの時間、入力ストリーム情報、送信時刻、出力操作情報などを含むBatchInfoオブジェクトを内包する。

**業務上の目的・背景**：DStreamベースのStreaming処理において、バッチの送信は処理パイプラインの最初のステップである。StreamingListenerBatchSubmittedにより、バッチが処理キューに投入されたことを検知し、キューの深さの監視、スケジューリング遅延の予測、バックプレッシャの検知などの運用監視が可能となる。送信されたバッチ数が処理完了バッチ数を大幅に上回る場合、処理のボトルネックを示唆する。

**通知の送信タイミング**：JobScheduler.submitJobSetメソッドにおいて、ジョブセットが空でない場合、ジョブの実行キューへの投入前に`listenerBus.post`で発火される。バッチの実際の処理開始前に送信されるため、スケジューリング遅延の計測起点となる。

**通知の受信者**：StreamingListenerインタフェースを実装し、StreamingContext.addStreamingListener()で登録されたすべてのリスナーが受信する。onBatchSubmittedメソッドにはデフォルト実装（空メソッド）がある。

**通知内容の概要**：BatchInfoオブジェクトが含まれ、batchTime（バッチ時間）、streamIdToInputInfo（入力ストリーム情報）、submissionTime（送信時刻）、processingStartTime（None）、processingEndTime（None）、outputOperationInfos（出力操作情報）が格納される。送信時点ではprocessingStartTimeとprocessingEndTimeは未設定。

**期待されるアクション**：リスナーは通知を受けて、バッチ送信の記録、キュー深さの監視更新、スケジューリング遅延の追跡開始、UIの更新などを実行することが期待される。

## 通知種別

アプリ内通知（StreamingListenerBus経由。WrappedStreamingListenerEventとしてSpark LiveListenerBusにラップして非同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（StreamingListenerBus経由でSpark LiveListenerBusにラップして非同期配信） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

StreamingListenerBusに登録されたすべてのStreamingListenerに対して配信される。

## 通知テンプレート

### メール通知の場合

該当なし。本イベントはSpark内部のリスナーバスを通じたプログラム内通知である。

### 本文テンプレート

```
イベント型: StreamingListenerBatchSubmitted
バッチ時間: {batchTime}
送信時刻: {submissionTime}
入力レコード数: {numRecords}
出力操作数: {outputOperationInfos.size}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| batchInfo | バッチ情報オブジェクト | JobSet.toBatchInfo | Yes |
| batchInfo.batchTime | バッチの時間（Time型） | JobSet.time | Yes |
| batchInfo.streamIdToInputInfo | 入力ストリームIDと入力情報のマップ | InputInfoTracker | Yes |
| batchInfo.submissionTime | ジョブセット送信時刻 | System.currentTimeMillis() | Yes |
| batchInfo.outputOperationInfos | 出力操作情報のマップ | JobSet.outputOperationInfos | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ送信 | JobScheduler.submitJobSet | jobSet.jobsが空でない | ジョブセットにジョブが含まれる場合のみ発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 空のジョブセット | jobSet.jobs.isEmptyの場合はイベントが発火されず、ログメッセージのみ出力 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[JobGenerator.generateJobs] --> B[JobScheduler.submitJobSet呼び出し]
    B --> C{jobSet.jobs.isEmpty?}
    C -->|Yes| D[ログ出力のみ・イベントなし]
    C -->|No| E[listenerBus.post StreamingListenerBatchSubmitted]
    E --> F[jobSets.put jobSet登録]
    F --> G[各ジョブをjobExecutorに投入]
    G --> H[WrappedStreamingListenerEventにラップ]
    H --> I[SparkListenerBus.post 非同期]
    I --> J[listener.onBatchSubmitted]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。

### 更新テーブル一覧

該当なし。

#### 送信ログテーブル

WrappedStreamingListenerEventのlogEventがfalseに設定されているため、Sparkイベントログには記録されない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonBatchSubmittedメソッドで例外発生 | ListenerBusが例外をキャッチしてログ出力。他のリスナーへの配信は継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（バッチ間隔に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。バッチ送信時に発火される。

## セキュリティ考慮事項

- BatchInfoには入力ストリーム情報が含まれるが、データ内容自体は含まれない
- イベントはSparkプロセス内部でのみ配信される

## 備考

- StreamingListenerBatchSubmittedはStreamingListenerEvent sealed traitを継承するcase class
- @DeveloperApiアノテーションが付与されている
- BatchInfoにはschedulingDelay, processingDelay, totalDelayなどの計算プロパティがあるが、送信時点ではprocessingStartTime/EndTimeがNoneのためこれらは利用不可
- バッチの送信はジョブの実行開始とは異なる。実行開始はStreamingListenerBatchStartedで通知される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | StreamingListenerBatchSubmittedのcase class定義（36行目）。batchInfo: BatchInfoフィールドを確認 |
| 1-2 | BatchInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/BatchInfo.scala` | BatchInfoのcase class定義（35-42行目）。batchTime, streamIdToInputInfo, submissionTime, processingStartTime, processingEndTime, outputOperationInfosの各フィールドを確認 |

**読解のコツ**: BatchInfoのschedulingDelay, processingDelay, totalDelayはOption型の計算プロパティであり、送信時点ではprocessingStartTimeがNoneのため結果もNoneとなる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | JobScheduler.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` | submitJobSetメソッド（145-154行目）でのイベント発火。空チェック後にlistenerBus.postで配信 |

**主要処理フロー**:
1. **146行目**: `if (jobSet.jobs.isEmpty)` - 空チェック
2. **149行目**: `listenerBus.post(StreamingListenerBatchSubmitted(jobSet.toBatchInfo))` - イベント発火
3. **150行目**: `jobSets.put(jobSet.time, jobSet)` - ジョブセット登録
4. **151行目**: `jobSet.jobs.foreach(job => jobExecutor.execute(new JobHandler(job)))` - ジョブ投入

#### Step 3: リスナーバスの配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | doPostEvent（58-59行目）でlistener.onBatchSubmittedを呼び出し |

### プログラム呼び出し階層図

```
JobGenerator.generateJobs(time)
    |
    +-- JobScheduler.submitJobSet(jobSet)
            |
            +-- [空チェック: jobSet.jobs.isEmpty]
            |
            +-- listenerBus.post(StreamingListenerBatchSubmitted(jobSet.toBatchInfo))
            |       |
            |       +-- sparkListenerBus.post(WrappedStreamingListenerEvent(event))
            |               |
            |               +-- StreamingListenerBus.onOtherEvent(event)
            |                       |
            |                       +-- postToAll(event)
            |                               |
            |                               +-- listener.onBatchSubmitted(event)
            |
            +-- jobSets.put(jobSet.time, jobSet)
            |
            +-- jobSet.jobs.foreach(job => jobExecutor.execute(new JobHandler(job)))
```

### データフロー図

```
[入力]                         [処理]                              [出力]

JobSet                   --> JobScheduler.submitJobSet()    --> StreamingListenerBatchSubmitted
  batchTime                     |                                  |
  jobs                          v                                  v
  toBatchInfo()            listenerBus.post()               StreamingListener
                                                              .onBatchSubmitted()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | ソース | イベントクラス定義（36行目）、リスナーインタフェース（85行目） |
| BatchInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/BatchInfo.scala` | ソース | BatchInfoデータクラス定義（35-42行目） |
| JobScheduler.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` | ソース | イベント発火元submitJobSet（145-154行目） |
| StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | ソース | イベント配信バス（58-59行目） |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | UI用リスナー実装 |
