# 通知設計書 80-StreamingListenerOutputOperationStarted

## 概要

本ドキュメントは、Apache SparkのDStream（Discretized Stream）ベースのStreaming処理において、バッチの出力操作処理が開始された際に発火されるイベント通知「StreamingListenerOutputOperationStarted」の設計を記述する。

### 本通知の処理概要

StreamingListenerOutputOperationStartedは、DStreamベースのSpark Streamingにおいて、バッチ内の個別の出力操作（output operation）が処理を開始した際に発火されるイベント通知である。OutputOperationInfoオブジェクトを内包し、バッチ時間、操作ID、操作名、説明、開始時刻などの情報が含まれる。1つのバッチに複数の出力操作がある場合、各操作の開始時にそれぞれイベントが発火される。

**業務上の目的・背景**：DStream Streamingでは1つのバッチに複数の出力操作（foreachRDD, print, saveAsTextFile等）を持つことが可能である。StreamingListenerOutputOperationStartedにより、個々の出力操作の開始を検知し、操作レベルの細粒度な監視が可能となる。特定の出力操作のみが遅延している場合のボトルネック特定や、出力操作ごとの処理時間計測の起点として利用される。

**通知の送信タイミング**：JobScheduler.handleJobStartメソッドにおいて、ジョブの開始時刻設定後に`listenerBus.post`で発火される。BatchStartedイベントの後に発火され、各ジョブの処理開始を個別に通知する。

**通知の受信者**：StreamingListenerインタフェースを実装し、StreamingContext.addStreamingListener()で登録されたすべてのリスナーが受信する。onOutputOperationStartedメソッドにはデフォルト実装（空メソッド）がある。

**通知内容の概要**：OutputOperationInfoオブジェクトが含まれ、batchTime（バッチ時間）、id（出力操作ID）、name（操作名）、description（操作の説明）、startTime（開始時刻、設定済み）、endTime（None）、failureReason（None）が格納される。

**期待されるアクション**：リスナーは通知を受けて、出力操作の開始記録、UIの更新、操作レベルの処理時間計測の開始などを実行することが期待される。

## 通知種別

アプリ内通知（StreamingListenerBus経由。WrappedStreamingListenerEventとしてSpark LiveListenerBusにラップして非同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（StreamingListenerBus経由でSpark LiveListenerBusにラップして非同期配信） |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

StreamingListenerBusに登録されたすべてのStreamingListenerに対して配信される。

## 通知テンプレート

### メール通知の場合

該当なし。

### 本文テンプレート

```
イベント型: StreamingListenerOutputOperationStarted
バッチ時間: {batchTime}
操作ID: {id}
操作名: {name}
説明: {description}
開始時刻: {startTime}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| outputOperationInfo | 出力操作情報オブジェクト | Job.toOutputOperationInfo | Yes |
| outputOperationInfo.batchTime | バッチの時間 | Job.time | Yes |
| outputOperationInfo.id | 出力操作ID | Job.outputOpId | Yes |
| outputOperationInfo.name | 操作名（foreachRDD等） | Job.callSite.shortForm | Yes |
| outputOperationInfo.description | 操作の説明 | Job.callSite.longForm | Yes |
| outputOperationInfo.startTime | 開始時刻 | Job.startTime | Yes |
| outputOperationInfo.endTime | 終了時刻（開始時はNone） | None | No |
| outputOperationInfo.failureReason | 失敗理由（開始時はNone） | None | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ジョブ開始 | JobScheduler.handleJobStart | 各ジョブの開始時 | バッチ内のすべてのジョブ開始時にそれぞれ発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | ジョブが開始されれば必ず発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[JobHandler.run実行] --> B[eventLoop.post JobStarted]
    B --> C[processEvent: handleJobStart呼び出し]
    C --> D[jobSet.handleJobStart job]
    D --> E{isFirstJobOfJobSet?}
    E -->|Yes| F[StreamingListenerBatchStarted発火]
    E -->|No| G[スキップ]
    F --> H[job.setStartTime startTime]
    G --> H
    H --> I[listenerBus.post StreamingListenerOutputOperationStarted]
    I --> J[WrappedStreamingListenerEventにラップ]
    J --> K[SparkListenerBus.post 非同期]
    K --> L[listener.onOutputOperationStarted]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。

### 更新テーブル一覧

該当なし。

#### 送信ログテーブル

WrappedStreamingListenerEventのlogEventがfalseに設定されているため、Sparkイベントログには記録されない。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonOutputOperationStartedメソッドで例外発生 | ListenerBusが例外をキャッチしてログ出力。他のリスナーへの配信は継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ジョブ数に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- OutputOperationInfoにはジョブの説明文（description）が含まれ、ユーザーのコードのコールサイト情報が露出する
- イベントはSparkプロセス内部でのみ配信される

## 備考

- StreamingListenerOutputOperationStartedはStreamingListenerEvent sealed traitを継承するcase class
- @DeveloperApiアノテーションが付与されている
- 1つのバッチに複数の出力操作がある場合、それぞれの開始時にイベントが発火される
- 対応する完了イベントはStreamingListenerOutputOperationCompleted
- OutputOperationInfoのdurationプロパティはstartTimeとendTimeの差分で計算されるが、開始時点ではendTimeがNoneのためNone
- handleJobStart内で、BatchStartedイベントの後にOutputOperationStartedイベントが発火される（190-191行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | StreamingListenerOutputOperationStartedのcase class定義（45-46行目）。outputOperationInfo: OutputOperationInfoフィールドを確認 |
| 1-2 | OutputOperationInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/OutputOperationInfo.scala` | OutputOperationInfoのcase class定義（35-42行目）。batchTime, id, name, description, startTime, endTime, failureReasonの各フィールドとduration計算プロパティ（47行目）を確認 |

**読解のコツ**: OutputOperationInfoはバッチ内の個別ジョブ（出力操作）に対応する。idはバッチ内での出力操作の順番を示す整数値。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | JobScheduler.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` | handleJobStartメソッド（181-194行目）。job.setStartTime後にlistenerBus.postでOutputOperationStartedを発火 |

**主要処理フロー**:
1. **184行目**: `jobSet.handleJobStart(job)` - ジョブ開始処理
2. **185-188行目**: [isFirstJobの場合] BatchStarted発火
3. **190行目**: `job.setStartTime(startTime)` - 開始時刻設定
4. **191行目**: `listenerBus.post(StreamingListenerOutputOperationStarted(job.toOutputOperationInfo))` - イベント発火

#### Step 3: リスナーバスの配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | doPostEvent（64-65行目）でlistener.onOutputOperationStartedを呼び出し |

### プログラム呼び出し階層図

```
JobHandler.run()
    |
    +-- eventLoop.post(JobStarted(job, clock.getTimeMillis()))
            |
            +-- processEvent(JobStarted)
                    |
                    +-- handleJobStart(job, startTime)
                            |
                            +-- jobSet.handleJobStart(job)
                            |
                            +-- [isFirstJob] listenerBus.post(BatchStarted)
                            |
                            +-- job.setStartTime(startTime)
                            |
                            +-- listenerBus.post(OutputOperationStarted(job.toOutputOperationInfo))
                                    |
                                    +-- sparkListenerBus.post(WrappedStreamingListenerEvent(event))
                                            |
                                            +-- StreamingListenerBus.onOtherEvent(event)
                                                    |
                                                    +-- postToAll(event)
                                                            |
                                                            +-- listener.onOutputOperationStarted(event)
```

### データフロー図

```
[入力]                            [処理]                                [出力]

JobStarted(job, startTime) --> handleJobStart()               --> StreamingListenerOutputOperationStarted
                                    |                                    |
                                    v                                    v
                               job.setStartTime()                StreamingListener
                               job.toOutputOperationInfo()         .onOutputOperationStarted()
                                    |
                                    v
                               OutputOperationInfo
                                 batchTime, id, name,
                                 description, startTime
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | ソース | イベントクラス定義（45-46行目）、リスナーインタフェース（94-95行目） |
| OutputOperationInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/OutputOperationInfo.scala` | ソース | OutputOperationInfoデータクラス定義（35-42行目） |
| JobScheduler.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` | ソース | イベント発火元handleJobStart（181-194行目、特に191行目） |
| StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | ソース | イベント配信バス（64-65行目） |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | UI用リスナー実装 |
