# 通知設計書 81-StreamingListenerOutputOperationCompleted

## 概要

本ドキュメントは、Apache Spark Streaming (DStream) における `StreamingListenerOutputOperationCompleted` イベント通知の設計を定義する。本イベントはバッチ内の出力操作（Output Operation）が完了した際に発火し、StreamingListenerインターフェースを通じて非同期に配信される。

### 本通知の処理概要

`StreamingListenerOutputOperationCompleted` は、DStream Streamingのバッチ処理において、個別の出力操作（foreachRDD等）が完了した際にJobSchedulerから発火されるイベントである。このイベントは、出力操作の完了状態、処理時間、失敗理由などの情報を含むOutputOperationInfoオブジェクトを保持する。

**業務上の目的・背景**：Spark Streamingでは、1つのバッチ内に複数の出力操作が含まれることがある。各出力操作の完了を個別に追跡することで、バッチ全体の処理状況をきめ細かく監視できる。特に、どの出力操作が遅延しているか、どの出力操作が失敗したかを特定するために不可欠なイベントである。

**通知の送信タイミング**：JobScheduler内のhandleJobCompletionメソッドにおいて、ジョブ（出力操作に対応）の完了処理が行われた後、即座にStreamingListenerBus経由で発火される。具体的には、ジョブのendTimeが設定された直後にpostされる。

**通知の受信者**：StreamingListenerインターフェースを実装したすべてのリスナーが受信対象となる。主な受信者は、StreamingJobProgressListener（UI更新用）、StatsReportListener（統計レポート用）、およびユーザーが独自に実装したカスタムリスナーである。

**通知内容の概要**：OutputOperationInfo（batchTime、出力操作ID、名前、説明、開始時刻、終了時刻、失敗理由）を含む。これにより、出力操作の処理時間や成否を把握できる。

**期待されるアクション**：リスナーはこのイベントを受信して、UI上の出力操作ステータスを更新する、処理時間の統計を記録する、失敗時にはアラートを発行する等の処理を行う。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中（STATUS_QUEUEで配信） |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

StreamingListenerBusに登録されたすべてのStreamingListenerインターフェース実装クラスに対してブロードキャスト配信される。StreamingListenerBusはSparkのLiveListenerBusのSTATUS_QUEUEにWrappedStreamingListenerEventとして登録され、StreamingListenerBusのdoPostEventメソッドで各リスナーのonOutputOperationCompletedメソッドが呼び出される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- batchTime: {バッチ処理の時刻}
- id: {出力操作ID}
- name: {出力操作名}
- description: {出力操作の説明}
- startTime: {処理開始時刻（ミリ秒）}
- endTime: {処理終了時刻（ミリ秒）}
- failureReason: {失敗理由（成功時はNone）}
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| outputOperationInfo.batchTime | バッチの処理時刻 | Job.time | Yes |
| outputOperationInfo.id | 出力操作の識別子 | Job.outputOpId | Yes |
| outputOperationInfo.name | 出力操作の名前 | Job.callSite.shortForm | Yes |
| outputOperationInfo.description | 出力操作の説明 | Job.callSite.longForm | Yes |
| outputOperationInfo.startTime | 処理開始時刻 | Job.startTime | Yes |
| outputOperationInfo.endTime | 処理終了時刻 | Job.endTime | Yes |
| outputOperationInfo.failureReason | 失敗理由 | Job.result(Failure時) | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ処理 | ジョブ完了（成功/失敗） | 常に送信 | JobScheduler.handleJobCompletionで出力操作の完了時に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| JobScheduler未起動 | eventLoopがnullの場合、イベントはpostされない |
| StreamingListenerBus停止後 | バスが停止された後はイベントが配信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[JobHandler.run完了] --> B[EventLoop.post JobCompleted]
    B --> C[JobScheduler.handleJobCompletion]
    C --> D[job.setEndTime completedTime]
    D --> E[listenerBus.post StreamingListenerOutputOperationCompleted]
    E --> F[StreamingListenerBus.post]
    F --> G[sparkListenerBus.post WrappedStreamingListenerEvent]
    G --> H[StreamingListenerBus.doPostEvent]
    H --> I[listener.onOutputOperationCompleted]
    I --> J[StreamingJobProgressListener更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

### 更新テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イベントドロップ | LiveListenerBusのキューが満杯の場合 | イベントはドロップされログに記録される |
| リスナー例外 | リスナーのonOutputOperationCompleted内で例外発生 | ListenerBusが例外をキャッチしログに記録。他のリスナーへの配信は継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（バッチ頻度に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。Streaming処理のバッチ間隔に従って、出力操作完了時に随時発火される。

## セキュリティ考慮事項

本イベントは同一JVM内のリスナーバスで配信されるため、ネットワーク経由の送信は発生しない。ただし、イベントログに書き込まれる場合（logEventがfalseなので通常は書き込まれない）、出力操作の説明に機密情報が含まれないよう注意が必要である。

## 備考

- StreamingListenerEventはWrappedStreamingListenerEventとしてSparkListenerBus経由で配信されるが、logEventプロパティはfalseに設定されているため、イベントログには記録されない（SPARK-12140）。
- 本イベントはonBatchCompletedの前に呼び出される。すべての出力操作が完了した後、バッチ完了イベントが発火される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントが保持するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OutputOperationInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/OutputOperationInfo.scala` | OutputOperationInfoのフィールド（batchTime, id, name, description, startTime, endTime, failureReason）を確認する |
| 1-2 | StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | 行49-50: StreamingListenerOutputOperationCompletedケースクラスの定義を確認する |

**読解のコツ**: Scalaのcase classは自動的にequals、hashCode、toString等が生成される。OutputOperationInfoはイミュータブルなデータコンテナとして機能する。

#### Step 2: エントリーポイントを理解する

処理の起点となるJobSchedulerのジョブ完了ハンドリングを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | JobScheduler.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` | 行196-219: handleJobCompletionメソッドでイベント発火の流れを理解する |

**主要処理フロー**:
1. **行197**: jobSets.get(job.time)でジョブセットを取得
2. **行198**: jobSet.handleJobCompletion(job)でジョブ完了を記録
3. **行199**: job.setEndTime(completedTime)で終了時刻を設定
4. **行200**: listenerBus.post(StreamingListenerOutputOperationCompleted(job.toOutputOperationInfo))でイベントを発火

#### Step 3: イベントバスの配信メカニズムを理解する

StreamingListenerBusがどのようにイベントを配信するかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | 行36-38: postメソッドでWrappedStreamingListenerEventへのラップ処理を確認する |
| 3-2 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | 行64-67: doPostEventメソッドでOutputOperationCompletedイベントのディスパッチを確認する |

#### Step 4: リスナーの処理を理解する

主要なリスナーであるStreamingJobProgressListenerの処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | 行131-136: onOutputOperationCompletedメソッドでUI用データの更新を確認する |

### プログラム呼び出し階層図

```
JobHandler.run() [JobScheduler.scala:230]
    |
    +-- EventLoop.post(JobCompleted) [JobScheduler.scala:261]
           |
           +-- JobScheduler.handleJobCompletion() [JobScheduler.scala:196]
                  |
                  +-- job.setEndTime(completedTime) [JobScheduler.scala:199]
                  |
                  +-- listenerBus.post(StreamingListenerOutputOperationCompleted) [JobScheduler.scala:200]
                         |
                         +-- StreamingListenerBus.post() [StreamingListenerBus.scala:36]
                                |
                                +-- sparkListenerBus.post(WrappedStreamingListenerEvent) [StreamingListenerBus.scala:37]
                                       |
                                       +-- StreamingListenerBus.doPostEvent() [StreamingListenerBus.scala:48]
                                              |
                                              +-- listener.onOutputOperationCompleted() [StreamingListenerBus.scala:67]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

Job完了通知          ───▶ JobScheduler.handleJobCompletion()    ───▶ StreamingListenerOutputOperationCompleted
(JobCompleted)              |                                            |
                            +-- job.toOutputOperationInfo()              +-- StreamingListenerBus
                            |   (OutputOperationInfo生成)                 |
                            +-- listenerBus.post()                       +-- StreamingJobProgressListener
                                                                         |   (UI更新)
                                                                         +-- カスタムリスナー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | ソース | イベントクラスとリスナーインターフェースの定義 |
| StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | ソース | イベント配信バスの実装 |
| JobScheduler.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/JobScheduler.scala` | ソース | イベント発火元のジョブスケジューラ |
| OutputOperationInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/OutputOperationInfo.scala` | ソース | イベントが保持するデータ構造 |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | UI更新用のリスナー実装 |
| JavaStreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/api/java/JavaStreamingListener.scala` | ソース | Java API用のリスナーラッパー |
