# 通知設計書 82-StreamingListenerReceiverStarted

## 概要

本ドキュメントは、Apache Spark Streaming (DStream) における `StreamingListenerReceiverStarted` イベント通知の設計を定義する。本イベントはレシーバー（Receiver）がドライバに正常に登録され、アクティブ状態になった際に発火する。

### 本通知の処理概要

`StreamingListenerReceiverStarted` は、DStream Streamingにおいてデータ受信を担当するレシーバーがExecutor上で起動し、ドライバのReceiverTrackerに正常登録された際に発火されるイベントである。このイベントはReceiverInfo（ストリームID、名前、アクティブ状態、ロケーション、Executor ID等）を保持する。

**業務上の目的・背景**：Spark Streamingではレシーバーがデータソースからリアルタイムにデータを受信する重要なコンポーネントである。レシーバーの起動状態を追跡することで、データ取り込みパイプラインの正常性を監視し、レシーバーが想定通りに動作しているかを確認できる。特にクラスタ環境では、レシーバーがどのExecutorに配置されたかの情報が運用上重要となる。

**通知の送信タイミング**：ReceiverTracker.registerReceiverメソッドにおいて、レシーバーの登録が成功した後（ReceiverTrackingInfoにACTIVE状態で記録された後）に即座にStreamingListenerBus経由で発火される。

**通知の受信者**：StreamingListenerインターフェースを実装したすべてのリスナーが受信対象となる。主な受信者はStreamingJobProgressListener（UI上のレシーバー情報更新）およびユーザー実装のカスタムリスナーである。

**通知内容の概要**：ReceiverInfo（streamId、name、active状態、location、executorId、lastErrorMessage、lastError、lastErrorTime）を含む。レシーバー起動時はactive=trueとなる。

**期待されるアクション**：リスナーはレシーバーの起動を検知し、UI上のレシーバーステータスを「アクティブ」に更新する。運用監視ツールでレシーバー起動の確認ログを記録する等の処理を行う。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中（STATUS_QUEUEで配信） |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

StreamingListenerBusに登録されたすべてのStreamingListenerインターフェース実装クラスに対してブロードキャスト配信される。doPostEventメソッド内でreceiverStartedパターンマッチにより、各リスナーのonReceiverStartedメソッドが呼び出される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- streamId: {レシーバーのストリームID}
- name: {レシーバー名（typ-streamIdの形式）}
- active: true
- location: {Executorのホスト名}
- executorId: {ExecutorのID}
- lastErrorMessage: ""
- lastError: ""
- lastErrorTime: -1
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| receiverInfo.streamId | レシーバーのストリームID | ReceiverTrackingInfo.streamId | Yes |
| receiverInfo.name | レシーバー名 | ReceiverTrackingInfo.name | Yes |
| receiverInfo.active | アクティブ状態 | ReceiverState.ACTIVE判定 | Yes |
| receiverInfo.location | レシーバーのホスト | ExecutorCacheTaskLocation.host | Yes |
| receiverInfo.executorId | Executor ID | ExecutorCacheTaskLocation.executorId | Yes |
| receiverInfo.lastErrorMessage | 最後のエラーメッセージ | ReceiverTrackingInfo.errorInfo | No |
| receiverInfo.lastError | 最後のエラー詳細 | ReceiverTrackingInfo.errorInfo | No |
| receiverInfo.lastErrorTime | 最後のエラー時刻 | ReceiverTrackingInfo.errorInfo | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| レシーバー登録 | RegisterReceiverメッセージ受信 | レシーバー登録成功時 | ReceiverTrackerEndpointでRegisterReceiverを受信し、registerReceiverが成功（trueを返却）した場合に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| レシーバー登録失敗 | スケジュールされたExecutorと異なるExecutorからの登録要求の場合、isAcceptableがfalseとなりイベントは発火されない |
| ReceiverTracker停止中 | isTrackerStoppingまたはisTrackerStoppedがtrueの場合、registerReceiverはfalseを返しイベントは発火されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Executor上のReceiverSupervisor起動] --> B[RegisterReceiverメッセージ送信]
    B --> C[ReceiverTrackerEndpoint.receiveAndReply]
    C --> D[ReceiverTracker.registerReceiver]
    D --> E{isAcceptable?}
    E -->|Yes| F[ReceiverTrackingInfo更新 ACTIVE]
    E -->|No| G[登録拒否 false返却]
    F --> H[listenerBus.post StreamingListenerReceiverStarted]
    H --> I[StreamingListenerBus.doPostEvent]
    I --> J[listener.onReceiverStarted]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

### 更新テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イベントドロップ | LiveListenerBusのキューが満杯の場合 | イベントはドロップされログに記録される |
| リスナー例外 | リスナーのonReceiverStarted内で例外発生 | ListenerBusが例外をキャッチしログに記録。他リスナーへの配信は継続 |
| 未知のストリームID | receiverInputStreamIdsに含まれないstreamIdでの登録要求 | SparkExceptionがスローされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（レシーバー登録時のみ発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。レシーバーの登録成功時に随時発火される。

## セキュリティ考慮事項

本イベントは同一JVM内のリスナーバスで配信されるため、ネットワーク経由の送信は発生しない。ReceiverInfoにはExecutorのホスト名やIDが含まれるが、これらはクラスタ内部の情報であり、通常のセキュリティ範囲内である。

## 備考

- レシーバー名は `${typ}-${streamId}` の形式で自動生成される（ReceiverTracker.scala 行300）。
- レシーバー登録はReceiverTrackerEndpointのreceiveAndReplyメソッドで処理されるため、呼び出し元にはレジスタ成否がBoolean値で返却される。
- StreamingListenerEventはWrappedStreamingListenerEventとしてラップされ、logEventはfalseのためイベントログには記録されない。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ReceiverInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` | 行27-37: ReceiverInfoのフィールド（streamId, name, active, location, executorId等）を確認する |
| 1-2 | StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | 行52-54: StreamingListenerReceiverStartedケースクラスの定義を確認する |

**読解のコツ**: ReceiverInfoはcase classであり、レシーバーの状態スナップショットを表す。activeフィールドはReceiverState.ACTIVEかどうかで判定される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ReceiverTracker.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` | 行264-314: registerReceiverメソッドでレシーバー登録とイベント発火の流れを理解する |

**主要処理フロー**:
1. **行272**: receiverInputStreamIdsにstreamIdが含まれるか検証
2. **行280**: scheduledLocationsからacceptableExecutorsを取得
3. **行291-294**: isAcceptableでExecutor/ホストの一致を確認
4. **行300-308**: ReceiverTrackingInfoをACTIVE状態で更新
5. **行309**: listenerBus.post(StreamingListenerReceiverStarted(receiverTrackingInfo.toReceiverInfo))でイベント発火

#### Step 3: イベント配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | 行52-53: doPostEventでreceiverStartedイベントのディスパッチを確認する |

#### Step 4: リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | 行75-79: onReceiverStartedメソッドでreceiverInfosの更新を確認する |

### プログラム呼び出し階層図

```
ReceiverSupervisorImpl (Executor側)
    |
    +-- ReceiverTrackerEndpoint.receiveAndReply(RegisterReceiver) [ReceiverTracker.scala:517]
           |
           +-- ReceiverTracker.registerReceiver() [ReceiverTracker.scala:264]
                  |
                  +-- ReceiverTrackingInfo更新 (ACTIVE) [ReceiverTracker.scala:301-308]
                  |
                  +-- listenerBus.post(StreamingListenerReceiverStarted) [ReceiverTracker.scala:309]
                         |
                         +-- StreamingListenerBus.post() [StreamingListenerBus.scala:36]
                                |
                                +-- StreamingListenerBus.doPostEvent() [StreamingListenerBus.scala:52]
                                       |
                                       +-- listener.onReceiverStarted() [StreamingListenerBus.scala:53]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

RegisterReceiver    ───▶ ReceiverTracker.registerReceiver()      ───▶ StreamingListenerReceiverStarted
(RPC message)               |                                            |
                            +-- ReceiverTrackingInfo更新                  +-- StreamingListenerBus
                            |   (state=ACTIVE)                           |
                            +-- toReceiverInfo()                         +-- StreamingJobProgressListener
                            |   (ReceiverInfo生成)                       |   (receiverInfos更新)
                            +-- listenerBus.post()                       +-- カスタムリスナー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | ソース | イベントクラスとリスナーインターフェースの定義 |
| ReceiverTracker.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` | ソース | レシーバー管理とイベント発火元 |
| ReceiverInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` | ソース | レシーバー情報のデータ構造 |
| StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | ソース | イベント配信バスの実装 |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | UI更新用のリスナー実装 |
| JavaStreamingListenerWrapper.scala | `streaming/src/main/scala/org/apache/spark/streaming/api/java/JavaStreamingListenerWrapper.scala` | ソース | Java API用のリスナーラッパー |
