# 通知設計書 83-StreamingListenerReceiverError

## 概要

本ドキュメントは、Apache Spark Streaming (DStream) における `StreamingListenerReceiverError` イベント通知の設計を定義する。本イベントはレシーバーがエラーを報告した際に発火し、StreamingListenerインターフェースを通じて非同期に配信される。

### 本通知の処理概要

`StreamingListenerReceiverError` は、DStream Streamingにおいてデータ受信を担当するレシーバーがエラーを検出し、ドライバのReceiverTrackerにエラーを報告した際に発火されるイベントである。このイベントはReceiverInfo（ストリームID、名前、アクティブ状態、エラーメッセージ、エラー詳細、エラー時刻等）を保持する。

**業務上の目的・背景**：レシーバーはデータソースからリアルタイムにデータを受信するコンポーネントであり、ネットワーク障害、データソースの問題、内部エラー等さまざまな理由でエラーが発生しうる。エラー発生時にリスナーに通知することで、運用監視ツールやUIがエラー状態を表示し、運用者が迅速に問題を認識・対処できるようにする。レシーバーエラーはレシーバーの停止とは異なり、レシーバーは引き続きアクティブな場合がある点に注意が必要である。

**通知の送信タイミング**：ReceiverTracker.reportErrorメソッドにおいて、レシーバーからのReportErrorメッセージを受信した後、ReceiverTrackingInfoのerrorInfoを更新し、即座にStreamingListenerBus経由で発火される。

**通知の受信者**：StreamingListenerインターフェースを実装したすべてのリスナーが受信対象となる。主な受信者はStreamingJobProgressListener（UI上のレシーバーエラー情報更新）およびユーザー実装のカスタムリスナーである。

**通知内容の概要**：ReceiverInfo（streamId、name、active、location、executorId、lastErrorMessage、lastError、lastErrorTime）を含む。エラー情報が更新された状態のReceiverInfoが配信される。

**期待されるアクション**：リスナーはレシーバーのエラーを検知し、UI上のレシーバーエラー情報を更新する。運用監視ツールでアラートを発行し、エラーの原因調査を開始する等の処理を行う。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中（STATUS_QUEUEで配信） |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

StreamingListenerBusに登録されたすべてのStreamingListenerインターフェース実装クラスに対してブロードキャスト配信される。doPostEventメソッド内でreceiverErrorパターンマッチにより、各リスナーのonReceiverErrorメソッドが呼び出される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- streamId: {レシーバーのストリームID}
- name: {レシーバー名}
- active: {アクティブ状態}
- location: {Executorのホスト名}
- executorId: {ExecutorのID}
- lastErrorMessage: {エラーメッセージ}
- lastError: {エラー詳細（スタックトレース等）}
- lastErrorTime: {エラー発生時刻（ミリ秒）}
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| receiverInfo.streamId | レシーバーのストリームID | ReceiverTrackingInfo.streamId | Yes |
| receiverInfo.name | レシーバー名 | ReceiverTrackingInfo.name | No |
| receiverInfo.active | アクティブ状態 | ReceiverState判定 | Yes |
| receiverInfo.location | レシーバーのホスト | ExecutorCacheTaskLocation.host | No |
| receiverInfo.executorId | Executor ID | ExecutorCacheTaskLocation.executorId | No |
| receiverInfo.lastErrorMessage | エラーメッセージ | ReportError.message | Yes |
| receiverInfo.lastError | エラー詳細 | ReportError.error | Yes |
| receiverInfo.lastErrorTime | エラー時刻 | errorInfo.lastErrorTimeまたはclock.getTimeMillis() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| レシーバーエラー | ReportErrorメッセージ受信 | 常に送信 | ReceiverTrackerEndpointでReportErrorを受信し、reportErrorメソッドが呼ばれた場合に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | ReportErrorメッセージを受信すれば常にイベントが発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Executor上のレシーバーでエラー発生] --> B[ReportErrorメッセージ送信]
    B --> C[ReceiverTrackerEndpoint.receive]
    C --> D[ReceiverTracker.reportError]
    D --> E[ReceiverTrackingInfo.errorInfo更新]
    E --> F[listenerBus.post StreamingListenerReceiverError]
    F --> G[StreamingListenerBus.doPostEvent]
    G --> H[listener.onReceiverError]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

### 更新テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イベントドロップ | LiveListenerBusのキューが満杯の場合 | イベントはドロップされログに記録される |
| リスナー例外 | リスナーのonReceiverError内で例外発生 | ListenerBusが例外をキャッチしログに記録。他リスナーへの配信は継続 |
| 未知のstreamId | receiverTrackingInfosに存在しないstreamIdの場合 | logWarningが出力され、新規のReceiverTrackingInfoがINACTIVE状態で作成される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（エラー発生時に都度発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。レシーバーのエラー報告時に随時発火される。

## セキュリティ考慮事項

本イベントは同一JVM内のリスナーバスで配信されるため、ネットワーク経由の送信は発生しない。ただし、lastErrorMessageやlastErrorにスタックトレースが含まれる可能性があり、これにはファイルパスやシステム情報が含まれうる。UIに表示する際は適切なサニタイズが推奨される。

## 備考

- reportErrorメソッドは、既存のReceiverTrackingInfoが存在する場合はcopyでerrorInfoを更新し、存在しない場合はINACTIVE状態で新規作成する（ReceiverTracker.scala 行354-366）。
- lastErrorTimeは、既存情報がある場合は以前のlastErrorTimeを引き継ぎ、ない場合はclock.getTimeMillis()が使用される（ReceiverTracker.scala 行358, 363）。
- ReportErrorはReceiveメソッド（非同期）で処理され、応答を返さない。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ReceiverInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` | 行27-37: ReceiverInfoのフィールド、特にlastErrorMessage、lastError、lastErrorTimeを確認する |
| 1-2 | StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | 行56-58: StreamingListenerReceiverErrorケースクラスの定義を確認する |

**読解のコツ**: ReceiverInfoのデフォルト値に注目する。lastErrorMessage=""、lastError=""、lastErrorTime=-1Lがデフォルトであり、エラー発生時にこれらが更新される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ReceiverTracker.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` | 行354-377: reportErrorメソッドでエラー情報の更新とイベント発火の流れを理解する |
| 2-2 | ReceiverTracker.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` | 行511-512: ReceiverTrackerEndpoint.receiveでReportErrorメッセージのハンドリングを確認する |

**主要処理フロー**:
1. **行355-358**: 既存のReceiverTrackingInfoがある場合、errorInfoをcopyで更新
2. **行360-365**: 既存情報がない場合、新規ReceiverTrackingInfoをINACTIVE状態で作成
3. **行368**: receiverTrackingInfosを更新
4. **行369**: listenerBus.post(StreamingListenerReceiverError(newReceiverTrackingInfo.toReceiverInfo))でイベント発火

#### Step 3: イベント配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | 行54-55: doPostEventでreceiverErrorイベントのディスパッチを確認する |

#### Step 4: リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | 行81-84: onReceiverErrorメソッドでreceiverInfosの更新を確認する |

### プログラム呼び出し階層図

```
ReceiverSupervisorImpl (Executor側) - エラー検出
    |
    +-- ReportErrorメッセージ送信 (RPC)
           |
           +-- ReceiverTrackerEndpoint.receive(ReportError) [ReceiverTracker.scala:511]
                  |
                  +-- ReceiverTracker.reportError() [ReceiverTracker.scala:354]
                         |
                         +-- ReceiverTrackingInfo.errorInfo更新 [ReceiverTracker.scala:355-368]
                         |
                         +-- listenerBus.post(StreamingListenerReceiverError) [ReceiverTracker.scala:369]
                                |
                                +-- StreamingListenerBus.post() [StreamingListenerBus.scala:36]
                                       |
                                       +-- StreamingListenerBus.doPostEvent() [StreamingListenerBus.scala:54]
                                              |
                                              +-- listener.onReceiverError() [StreamingListenerBus.scala:55]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

ReportError         ───▶ ReceiverTracker.reportError()           ───▶ StreamingListenerReceiverError
(RPC message)               |                                            |
                            +-- ReceiverTrackingInfo更新                  +-- StreamingListenerBus
                            |   (errorInfo設定)                          |
                            +-- toReceiverInfo()                         +-- StreamingJobProgressListener
                            |   (ReceiverInfo生成)                       |   (receiverInfos更新)
                            +-- listenerBus.post()                       +-- カスタムリスナー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | ソース | イベントクラスとリスナーインターフェースの定義 |
| ReceiverTracker.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` | ソース | レシーバー管理とイベント発火元 |
| ReceiverInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` | ソース | レシーバー情報のデータ構造 |
| StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | ソース | イベント配信バスの実装 |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | UI更新用のリスナー実装 |
