# 通知設計書 84-StreamingListenerReceiverStopped

## 概要

本ドキュメントは、Apache Spark Streaming (DStream) における `StreamingListenerReceiverStopped` イベント通知の設計を定義する。本イベントはレシーバーが停止（登録解除）された際に発火し、StreamingListenerインターフェースを通じて非同期に配信される。

### 本通知の処理概要

`StreamingListenerReceiverStopped` は、DStream Streamingにおいてデータ受信を担当するレシーバーが登録解除（deregister）された際に発火されるイベントである。このイベントはReceiverInfoを保持し、レシーバーの最終状態（INACTIVE）とエラー情報を含む。レシーバーの停止は正常停止・異常停止のいずれの場合も発生する。

**業務上の目的・背景**：レシーバーの停止はデータ取り込みの中断を意味するため、運用上極めて重要なイベントである。正常なシャットダウンプロセスの一環として停止される場合もあれば、Executorの障害やレシーバー内部のエラーによって非予期的に停止される場合もある。いずれの場合も、停止の事実と理由を即座にリスナーに通知することで、運用者が適切な対応を取れるようにする。

**通知の送信タイミング**：ReceiverTracker.deregisterReceiverメソッドにおいて、レシーバーのDeregisterReceiverメッセージを受信した後、ReceiverTrackingInfoをINACTIVE状態に更新し、即座にStreamingListenerBus経由で発火される。

**通知の受信者**：StreamingListenerインターフェースを実装したすべてのリスナーが受信対象となる。主な受信者はStreamingJobProgressListener（UI上のレシーバー情報更新）およびユーザー実装のカスタムリスナーである。

**通知内容の概要**：ReceiverInfo（streamId、name、active=false、location、executorId、lastErrorMessage、lastError、lastErrorTime）を含む。停止理由のメッセージとエラー文字列が格納される。

**期待されるアクション**：リスナーはレシーバーの停止を検知し、UI上のレシーバーステータスを「非アクティブ」に更新する。非予期的な停止の場合、アラートを発行しレシーバーの再起動を検討する。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中（STATUS_QUEUEで配信） |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

StreamingListenerBusに登録されたすべてのStreamingListenerインターフェース実装クラスに対してブロードキャスト配信される。doPostEventメソッド内でreceiverStoppedパターンマッチにより、各リスナーのonReceiverStoppedメソッドが呼び出される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- streamId: {レシーバーのストリームID}
- name: {レシーバー名}
- active: false (INACTIVE)
- location: {Executorのホスト名}
- executorId: {ExecutorのID}
- lastErrorMessage: {停止理由メッセージ}
- lastError: {エラー文字列（ある場合）}
- lastErrorTime: {エラー時刻（エラーがない場合は-1）}
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| receiverInfo.streamId | レシーバーのストリームID | DeregisterReceiver.streamId | Yes |
| receiverInfo.name | レシーバー名 | ReceiverTrackingInfo.name | No |
| receiverInfo.active | アクティブ状態（常にfalse） | ReceiverState.INACTIVE判定 | Yes |
| receiverInfo.location | レシーバーのホスト | ReceiverTrackingInfo.runningExecutor | No |
| receiverInfo.executorId | Executor ID | ReceiverTrackingInfo.runningExecutor | No |
| receiverInfo.lastErrorMessage | 停止理由メッセージ | DeregisterReceiver.msg | Yes |
| receiverInfo.lastError | エラー文字列 | DeregisterReceiver.error | Yes |
| receiverInfo.lastErrorTime | エラー時刻 | clock.getTimeMillis() (エラーあり時) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| レシーバー登録解除 | DeregisterReceiverメッセージ受信 | 常に送信 | ReceiverTrackerEndpointでDeregisterReceiverを受信し、deregisterReceiverが呼ばれた場合に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | DeregisterReceiverメッセージを受信すれば常にイベントが発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[レシーバー停止またはExecutor障害] --> B[DeregisterReceiverメッセージ送信]
    B --> C[ReceiverTrackerEndpoint.receiveAndReply]
    C --> D[ReceiverTracker.deregisterReceiver]
    D --> E[ReceiverTrackingInfo更新 INACTIVE]
    E --> F[listenerBus.post StreamingListenerReceiverStopped]
    F --> G[StreamingListenerBus.doPostEvent]
    G --> H[listener.onReceiverStopped]
    H --> I[StreamingJobProgressListener receiverInfos更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

### 更新テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イベントドロップ | LiveListenerBusのキューが満杯の場合 | イベントはドロップされログに記録される |
| リスナー例外 | リスナーのonReceiverStopped内で例外発生 | ListenerBusが例外をキャッチしログに記録。他リスナーへの配信は継続 |
| 未知のstreamId | receiverTrackingInfosに存在しないstreamIdの場合 | logWarningが出力され、新規のReceiverTrackingInfoがINACTIVE状態で作成される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（レシーバー停止時のみ発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。レシーバーの登録解除時に随時発火される。

## セキュリティ考慮事項

本イベントは同一JVM内のリスナーバスで配信されるため、ネットワーク経由の送信は発生しない。lastErrorMessageやlastErrorにスタックトレースが含まれる可能性があり、システム情報が含まれうるため、UIでの表示時は適切なサニタイズが推奨される。

## 備考

- deregisterReceiverはreceiveAndReplyメソッドで処理され、応答としてtrue（Boolean）が返却される（ReceiverTracker.scala 行534-536）。
- lastErrorTimeは、errorがnullまたは空文字列の場合は-1、それ以外の場合はclock.getTimeMillis()が設定される（ReceiverTracker.scala 行318-319）。
- レシーバーの再起動はReceiverTrackerEndpointのstartReceiver/RestartReceiverメカニズムによって別途管理される。停止イベントの発火後、条件に応じてレシーバーが再起動される場合がある。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ReceiverInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` | 行27-37: ReceiverInfoのフィールド構成を確認する。停止時はactive=falseとなる |
| 1-2 | StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | 行60-62: StreamingListenerReceiverStoppedケースクラスの定義を確認する |

**読解のコツ**: ReceiverInfoのactiveフィールドは、ReceiverTrackingInfo.toReceiverInfoの変換時にstate == ReceiverState.ACTIVEで判定される。停止時はstate=INACTIVEなのでactive=falseとなる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ReceiverTracker.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` | 行317-339: deregisterReceiverメソッドで登録解除とイベント発火の流れを理解する |
| 2-2 | ReceiverTracker.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` | 行534-536: ReceiverTrackerEndpointでDeregisterReceiverメッセージのハンドリングを確認する |

**主要処理フロー**:
1. **行318-319**: lastErrorTimeの算出（errorが空でなければclock.getTimeMillis()）
2. **行320-321**: ReceiverErrorInfoの作成
3. **行322-329**: 既存/新規のReceiverTrackingInfoをINACTIVE状態に更新
4. **行330**: receiverTrackingInfosの更新
5. **行331**: listenerBus.post(StreamingListenerReceiverStopped(newReceiverTrackingInfo.toReceiverInfo))でイベント発火

#### Step 3: イベント配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | 行56-57: doPostEventでreceiverStoppedイベントのディスパッチを確認する |

#### Step 4: リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | 行87-90: onReceiverStoppedメソッドでreceiverInfosの更新を確認する |

### プログラム呼び出し階層図

```
ReceiverSupervisorImpl (Executor側) - 停止検出
    |
    +-- DeregisterReceiverメッセージ送信 (RPC)
           |
           +-- ReceiverTrackerEndpoint.receiveAndReply(DeregisterReceiver) [ReceiverTracker.scala:534]
                  |
                  +-- ReceiverTracker.deregisterReceiver() [ReceiverTracker.scala:317]
                         |
                         +-- ReceiverTrackingInfo更新 (INACTIVE) [ReceiverTracker.scala:322-330]
                         |
                         +-- listenerBus.post(StreamingListenerReceiverStopped) [ReceiverTracker.scala:331]
                                |
                                +-- StreamingListenerBus.post() [StreamingListenerBus.scala:36]
                                       |
                                       +-- StreamingListenerBus.doPostEvent() [StreamingListenerBus.scala:56]
                                              |
                                              +-- listener.onReceiverStopped() [StreamingListenerBus.scala:57]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

DeregisterReceiver  ───▶ ReceiverTracker.deregisterReceiver()    ───▶ StreamingListenerReceiverStopped
(RPC message)               |                                            |
                            +-- ReceiverTrackingInfo更新                  +-- StreamingListenerBus
                            |   (state=INACTIVE, errorInfo設定)          |
                            +-- toReceiverInfo()                         +-- StreamingJobProgressListener
                            |   (ReceiverInfo生成, active=false)         |   (receiverInfos更新)
                            +-- listenerBus.post()                       +-- カスタムリスナー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StreamingListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` | ソース | イベントクラスとリスナーインターフェースの定義 |
| ReceiverTracker.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverTracker.scala` | ソース | レシーバー管理とイベント発火元 |
| ReceiverInfo.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/ReceiverInfo.scala` | ソース | レシーバー情報のデータ構造 |
| StreamingListenerBus.scala | `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` | ソース | イベント配信バスの実装 |
| StreamingJobProgressListener.scala | `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingJobProgressListener.scala` | ソース | UI更新用のリスナー実装 |
