# 通知設計書 85-SparkListenerConnectServiceStarted

## 概要

本ドキュメントは、Apache Spark Connect における `SparkListenerConnectServiceStarted` イベント通知の設計を定義する。本イベントはSpark ConnectのgRPCサービスが起動し、インバウンドリクエストの受付準備が完了した際に発火する。

### 本通知の処理概要

`SparkListenerConnectServiceStarted` は、Spark ConnectサービスのgRPCサーバーが正常に起動し、クライアントからのリクエストを受け付けられる状態になった際に、SparkConnectServiceオブジェクトのstartメソッドから発火されるイベントである。このイベントはサービスのホストアドレス、バインドポート、イベント生成時刻を含む。

**業務上の目的・背景**：Spark Connectはクライアントサーバー型アーキテクチャを採用しており、gRPCサーバーの起動はサービス提供開始を意味する。サービスの起動完了を通知することで、運用監視ツールやUI（SparkConnectServerTab）がサービスの稼働状態を把握でき、クライアントへの接続許可判断や、サービスの可用性モニタリングに活用できる。

**通知の送信タイミング**：SparkConnectService.startメソッドの最後、gRPCサーバーの起動・ListenerBusの作成・UIタブの作成がすべて完了し、started=trueが設定された直後にpostSparkConnectServiceStartedが呼ばれ、LiveListenerBus経由で発火される。

**通知の受信者**：SparkListenerインターフェースを実装したすべてのリスナーが受信対象となる。主な受信者はSparkConnectServerListener（UI用のセッション・オペレーション管理）である。onOtherEventメソッドを通じて処理される。

**通知内容の概要**：hostAddress（サービスのホストアドレス）、bindingPort（バインドポート番号）、eventTime（イベント生成時刻のミリ秒）を含む。

**期待されるアクション**：リスナーはサービス起動を検知し、内部状態を「サービス稼働中」に更新する。運用監視ツールでサービス起動ログを記録する。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

SparkContextのLiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャスト配信される。SparkListenerConnectServiceStartedはSparkListenerEventを継承しているため、onOtherEventメソッドを通じてリスナーに配信される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- hostAddress: {サービスのホストアドレス（例: "192.168.1.100"）}
- bindingPort: {バインドポート番号（例: 15002）}
- eventTime: {イベント生成時刻（ミリ秒、例: 1706000000000）}
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| hostAddress | サービスのホストアドレス | Utils.localCanonicalHostName() | Yes |
| bindingPort | バインドポート番号 | bindingAddress.getPort | Yes |
| eventTime | イベント生成時刻 | System.currentTimeMillis() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス起動 | SparkConnectService.start完了 | gRPCサーバー起動成功時 | startメソッドの最後でpostSparkConnectServiceStartedが呼ばれる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| serverがnull | gRPCサーバーが未作成の場合、postServiceEventでイベントがドロップされる |
| bindingAddressがnull | サーバーのバインドアドレスが未設定の場合、イベントがドロップされる |
| listenerBusがnull | ListenerBusが未設定の場合、イベントがドロップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SparkConnectService.start呼び出し] --> B[sessionManager初期化]
    B --> C[startGRPCService gRPCサーバー起動]
    C --> D[createListenerAndUI リスナーとUI作成]
    D --> E[started = true]
    E --> F[postSparkConnectServiceStarted]
    F --> G{server != null?}
    G -->|Yes| H{bindingAddress != null?}
    G -->|No| I[logWarning イベントドロップ]
    H -->|Yes| J{listenerBus != null?}
    H -->|No| I
    J -->|Yes| K[listenerBus.post SparkListenerConnectServiceStarted]
    J -->|No| I
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

### 更新テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| gRPCサーバー起動失敗 | ポートバインド失敗等 | startメソッドが例外をスローし、イベントは発火されない |
| イベントドロップ | server/bindingAddress/listenerBusがnullの場合 | logWarningが出力されイベントがドロップされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし（ポートバインドのリトライはCONNECT_GRPC_PORT_MAX_RETRIESで別途制御） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（サービス起動時に1回のみ発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。サービス起動完了時に1回のみ発火される。

## セキュリティ考慮事項

本イベントにはサービスのホストアドレスとバインドポートが含まれる。これらはネットワーク接続情報であり、セキュリティ上重要な情報となりうる。イベントログに記録される場合、アクセス制御が適切に設定されていることを確認する必要がある。

## 備考

- SparkConnectService.startメソッドはsynchronizedで保護されており、二重起動は防止される（既にstarted=trueの場合はlogWarningのみ）。
- hostAddressはUtils.localCanonicalHostName()で取得されるローカルホストの正規名である。
- bindingPortはgRPCサーバーが実際にバインドしたポートであり、設定値（CONNECT_GRPC_BINDING_PORT）と異なる場合がある（ポート0指定時等）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | 行548-552: SparkListenerConnectServiceStartedケースクラスの定義を確認する。hostAddress, bindingPort, eventTimeの3フィールド |

**読解のコツ**: SparkListenerEventを直接継承しているため、SparkListenerBusのonOtherEventを通じて配信される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | 行435-449: startメソッドの全体フローを理解する |
| 2-2 | SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | 行484-487: postSparkConnectServiceStartedメソッドでイベント生成を確認する |

**主要処理フロー**:
1. **行441-442**: sessionManager.initializeBaseSession
2. **行443**: startGRPCService() でgRPCサーバー起動
3. **行444**: createListenerAndUI(sc) でリスナーとUI作成
4. **行446-447**: started=true, stopped=false
5. **行448**: postSparkConnectServiceStarted() でイベント発火

#### Step 3: イベント配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | 行501-521: postServiceEventメソッドでnullチェックと配信ロジックを理解する |

#### Step 4: リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 行118-132: onOtherEventメソッドでSparkListenerConnectServiceStartedのハンドリングを確認する（直接のハンドリングはないがフレームワークとして確認） |

### プログラム呼び出し階層図

```
SparkConnectService.start(sc) [SparkConnectService.scala:435]
    |
    +-- sessionManager.initializeBaseSession() [SparkConnectService.scala:441]
    +-- startGRPCService() [SparkConnectService.scala:443]
    |      +-- NettyServerBuilder.build().start() [SparkConnectService.scala:411]
    +-- createListenerAndUI(sc) [SparkConnectService.scala:444]
    |      +-- SparkConnectServerListener作成 [SparkConnectService.scala:361]
    |      +-- sc.listenerBus.addToStatusQueue(listener) [SparkConnectService.scala:362]
    +-- postSparkConnectServiceStarted() [SparkConnectService.scala:448]
           |
           +-- postServiceEvent() [SparkConnectService.scala:501]
                  |
                  +-- listenerBus.post(SparkListenerConnectServiceStarted) [SparkConnectService.scala:520]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

SparkContext       ───▶ SparkConnectService.start()               ───▶ SparkListenerConnectServiceStarted
(sc)                        |                                            |
                            +-- gRPCサーバー起動                          +-- LiveListenerBus
                            +-- bindingAddress取得                        |
                            +-- hostAddress取得                           +-- SparkConnectServerListener
                            +-- System.currentTimeMillis()               |   (UI用状態管理)
                            +-- postServiceEvent()                       +-- カスタムリスナー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | ソース | イベントクラス定義とサービス起動・イベント発火元 |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | UI用のリスナー実装 |
| Connect.scala (config) | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/config/Connect.scala` | 設定 | CONNECT_GRPC_BINDING_PORT等の設定定義 |
