# 通知設計書 86-SparkListenerConnectServiceEnd

## 概要

本ドキュメントは、Apache Spark Connect における `SparkListenerConnectServiceEnd` イベント通知の設計を定義する。本イベントはSpark ConnectのgRPCサービスがシャットダウンされた際に発火する。

### 本通知の処理概要

`SparkListenerConnectServiceEnd` は、Spark ConnectサービスのgRPCサーバーがシャットダウンされた際に、SparkConnectServiceオブジェクトのstopメソッドから発火されるイベントである。このイベントはサービスのホストアドレス、バインドポート、イベント生成時刻を含む。本イベントの発火後は、処理中のリクエストや新規リクエストの適切な処理は保証されない。

**業務上の目的・背景**：Spark Connectサービスのシャットダウンは、すべてのクライアント接続が切断されることを意味する。サービスの終了を通知することで、運用監視ツールがサービスの停止を検知し、必要に応じてアラートを発行したり、クライアントのフェイルオーバーを促進したりできる。

**通知の送信タイミング**：SparkConnectService.stopメソッドにおいて、gRPCサーバーのシャットダウン、StreamingSessionManager・ExecutionManager・SessionManagerのシャットダウン、UIタブのデタッチがすべて完了し、stopped=trueが設定された直後にpostSparkConnectServiceEndが呼ばれる。

**通知の受信者**：SparkListenerインターフェースを実装したすべてのリスナーが受信対象となる。onOtherEventメソッドを通じて処理される。

**通知内容の概要**：hostAddress（サービスのホストアドレス）、bindingPort（バインドポート番号）、eventTime（イベント生成時刻のミリ秒）を含む。

**期待されるアクション**：リスナーはサービス停止を検知し、内部状態を「サービス停止」に更新する。運用監視ツールでサービス停止ログを記録し、必要に応じてアラートを発行する。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

SparkContextのLiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャスト配信される。SparkListenerConnectServiceEndはSparkListenerEventを継承しているため、onOtherEventメソッドを通じてリスナーに配信される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- hostAddress: {サービスのホストアドレス}
- bindingPort: {バインドポート番号}
- eventTime: {イベント生成時刻（ミリ秒）}
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| hostAddress | サービスのホストアドレス | Utils.localCanonicalHostName() | Yes |
| bindingPort | バインドポート番号 | bindingAddress.getPort | Yes |
| eventTime | イベント生成時刻 | System.currentTimeMillis() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス停止 | SparkConnectService.stop完了 | gRPCサーバーシャットダウン成功時 | stopメソッドの最後でpostSparkConnectServiceEndが呼ばれる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| serverがnull | gRPCサーバーが未作成の場合、postServiceEventでイベントがドロップされる |
| bindingAddressがnull | サーバーのバインドアドレスが未設定の場合、イベントがドロップされる |
| listenerBusがnull | ListenerBusが未設定の場合、イベントがドロップされる |
| 未起動状態 | started=falseの場合、IllegalStateExceptionがスローされイベントは発火されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SparkConnectService.stop呼び出し] --> B{既に停止済み?}
    B -->|Yes| C[logWarning 早期リターン]
    B -->|No| D{起動済み?}
    D -->|No| E[IllegalStateException]
    D -->|Yes| F[gRPCサーバーシャットダウン]
    F --> G[streamingSessionManager.shutdown]
    G --> H[executionManager.shutdown]
    H --> I[sessionManager.shutdown]
    I --> J[uiTab.detach]
    J --> K[started=false stopped=true]
    K --> L[postSparkConnectServiceEnd]
    L --> M[listenerBus.post SparkListenerConnectServiceEnd]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

### 更新テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 未起動状態での停止 | started=falseの場合 | IllegalStateExceptionがスローされる |
| イベントドロップ | server/bindingAddress/listenerBusがnullの場合 | logWarningが出力されイベントがドロップされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（サービス停止時に1回のみ発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。サービス停止完了時に1回のみ発火される。

## セキュリティ考慮事項

本イベントにはサービスのホストアドレスとバインドポートが含まれる。セキュリティ上、サービスの停止情報は攻撃者にとって有用な情報となりうるため、イベントログへのアクセス制御が適切に設定されていることを確認する必要がある。

## 備考

- SparkConnectService.stopメソッドはsynchronizedで保護されており、二重停止は防止される（既にstopped=trueの場合はlogWarningのみ）。
- stopメソッドはtimeoutとunitのオプションパラメータを受け取り、指定された場合はgracefulシャットダウンが行われる。未指定の場合はshutdownNow()が呼ばれる。
- postSparkConnectServiceEndはprivate[connect]スコープであり、テスト等から直接呼び出すことが可能。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | 行566-567: SparkListenerConnectServiceEndケースクラスの定義を確認する |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | 行451-478: stopメソッドの全体フローを理解する |
| 2-2 | SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | 行492-495: postSparkConnectServiceEndメソッドを確認する |

**主要処理フロー**:
1. **行452-455**: 二重停止チェック
2. **行457-459**: 未起動チェック
3. **行462-469**: gRPCサーバーシャットダウン
4. **行470-473**: 各マネージャーのシャットダウンとUIデタッチ
5. **行475-476**: started=false, stopped=true
6. **行477**: postSparkConnectServiceEnd()でイベント発火

#### Step 3: イベント配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | 行501-521: postServiceEventメソッドのnullチェックと配信ロジック |

### プログラム呼び出し階層図

```
SparkConnectService.stop() [SparkConnectService.scala:451]
    |
    +-- server.shutdownNow() / server.shutdown() [SparkConnectService.scala:464-465]
    +-- streamingSessionManager.shutdown() [SparkConnectService.scala:470]
    +-- executionManager.shutdown() [SparkConnectService.scala:471]
    +-- sessionManager.shutdown() [SparkConnectService.scala:472]
    +-- uiTab.detach() [SparkConnectService.scala:473]
    +-- postSparkConnectServiceEnd() [SparkConnectService.scala:477]
           |
           +-- postServiceEvent() [SparkConnectService.scala:501]
                  |
                  +-- listenerBus.post(SparkListenerConnectServiceEnd) [SparkConnectService.scala:520]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

stop()呼び出し      ───▶ SparkConnectService.stop()               ───▶ SparkListenerConnectServiceEnd
(timeout, unit)             |                                            |
                            +-- gRPCサーバーシャットダウン                  +-- LiveListenerBus
                            +-- 各マネージャーシャットダウン                 |
                            +-- postServiceEvent()                       +-- SparkConnectServerListener
                                                                         +-- カスタムリスナー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkConnectService.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` | ソース | イベントクラス定義とサービス停止・イベント発火元 |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | UI用のリスナー実装 |
