# 通知設計書 87-SparkListenerConnectSessionStarted

## 概要

本ドキュメントは、Apache Spark Connect における `SparkListenerConnectSessionStarted` イベント通知の設計を定義する。本イベントはConnectセッションが開始された際に発火する。

### 本通知の処理概要

`SparkListenerConnectSessionStarted` は、Spark Connectにおいてクライアントからの接続要求に応じてセッションが作成・開始された際に、SessionEventsManagerのpostStartedメソッドから発火されるイベントである。このイベントはセッションID、ユーザーID、イベント時刻、追加タグを含む。

**業務上の目的・背景**：Spark Connectはマルチテナント環境でのクライアント接続を管理しており、各クライアントに独立したセッションが割り当てられる。セッションの開始を通知することで、接続中のクライアント数の追跡、UIでのセッション一覧表示、セッションのライフサイクル監視が可能となる。

**通知の送信タイミング**：SessionEventsManager.postStartedメソッドにおいて、セッションのステータスがPendingからStartedに遷移する際に発火される。assertStatusにより、Pending状態からのみStartedへの遷移が許可される。

**通知の受信者**：SparkListenerインターフェースを実装したすべてのリスナーが受信対象となる。主な受信者はSparkConnectServerListener（onOtherEvent経由でonSessionStartedが呼ばれ、LiveSessionDataの作成・管理が行われる）。

**通知内容の概要**：sessionId（セッション識別子）、userId（ユーザー識別子）、eventTime（イベント生成時刻のミリ秒）、extraTags（追加メタデータ、デフォルトは空Map）を含む。

**期待されるアクション**：リスナーはセッション開始を検知し、UIにセッション情報を追加する。セッション数の監視やリソース割り当ての追跡に活用する。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

SparkContextのLiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャスト配信される。onOtherEventメソッドを通じてSparkConnectServerListenerに配信され、onSessionStartedハンドラが呼ばれる。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- sessionId: {クライアントまたはConnectが割り当てたセッションID}
- userId: {ユーザー識別子}
- eventTime: {イベント生成時刻（ミリ秒）}
- extraTags: {追加メタデータ（デフォルト: 空Map）}
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| sessionId | セッション識別子 | sessionHolder.sessionId | Yes |
| userId | ユーザー識別子 | sessionHolder.userId | Yes |
| eventTime | イベント生成時刻 | clock.getTimeMillis() | Yes |
| extraTags | 追加メタデータ | デフォルト空Map | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| セッション開始 | SessionEventsManager.postStarted呼び出し | ステータスがPendingの場合 | セッションホルダー作成時にpostStartedが呼ばれる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスがPending以外 | assertStatusにより、Pending以外の状態からStartedへの遷移はIllegalStateExceptionがスローされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[クライアント接続要求] --> B[SessionHolder作成]
    B --> C[SessionEventsManager.postStarted]
    C --> D{status == Pending?}
    D -->|Yes| E[status = Started]
    D -->|No| F[IllegalStateException]
    E --> G[sparkContext.listenerBus.post SparkListenerConnectSessionStarted]
    G --> H[SparkConnectServerListener.onOtherEvent]
    H --> I[onSessionStarted LiveSessionData作成]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | INSERT | SessionInfo（セッション情報）をKVStoreに書き込む（SparkConnectServerListener経由） |

#### SessionInfo (KVStore)

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | sessionId | セッションID | LiveSessionDataとして作成 |
| INSERT | startTimestamp | イベント時刻 | e.eventTime |
| INSERT | userName | ユーザーID | e.userId |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不正状態遷移 | status != Pendingの場合 | IllegalStateExceptionがスローされる |
| イベントドロップ | LiveListenerBusのキューが満杯の場合 | イベントはドロップされログに記録される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（セッション開始時に1回発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。セッション開始時に随時発火される。

## セキュリティ考慮事項

本イベントにはsessionIdとuserIdが含まれる。これらはユーザー識別情報であり、イベントログに記録される場合はアクセス制御が適切に設定されていることを確認する必要がある。特にマルチテナント環境では、他テナントのセッション情報が漏洩しないよう注意が必要である。

## 備考

- SessionEventsManagerはSessionHolderとClockを受け取るケースクラスであり、テスト時にClockを差し替えることで時刻をモック可能。
- extraTagsフィールドはデフォルトで空Mapであり、将来的な拡張ポイントとして設計されている。
- セッションのステータス遷移はPending -> Started -> Closedの一方向のみ許可されている。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SessionEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` | 行104-109: SparkListenerConnectSessionStartedケースクラスの定義（sessionId, userId, eventTime, extraTags）を確認する |
| 1-2 | SessionEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` | 行23-29: SessionStatus列挙（Pending, Started, Closed）を確認する |

**読解のコツ**: SessionStatusはsealed abstract classで定義されており、Pending/Started/Closedの3つの状態を持つ。assertStatusメソッドで状態遷移の妥当性が検証される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SessionEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` | 行58-66: postStartedメソッドでステータス検証とイベント発火の流れを理解する |

**主要処理フロー**:
1. **行59**: assertStatus(List(SessionStatus.Pending), SessionStatus.Started)で遷移検証
2. **行60-65**: sessionHolder.session.sparkContext.listenerBus.postでイベント発火
3. **行62-64**: SparkListenerConnectSessionStarted(sessionId, userId, clock.getTimeMillis())でイベント生成

#### Step 3: リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 行128: onOtherEventでSparkListenerConnectSessionStartedをマッチング |
| 3-2 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 行280-283: onSessionStartedメソッドでLiveSessionDataの作成を確認する |

### プログラム呼び出し階層図

```
SessionHolder作成/初期化
    |
    +-- SessionEventsManager.postStarted() [SessionEventsManager.scala:58]
           |
           +-- assertStatus(Pending, Started) [SessionEventsManager.scala:81]
           |
           +-- sparkContext.listenerBus.post(SparkListenerConnectSessionStarted) [SessionEventsManager.scala:60]
                  |
                  +-- SparkConnectServerListener.onOtherEvent() [SparkConnectServerListener.scala:118]
                         |
                         +-- onSessionStarted() [SparkConnectServerListener.scala:280]
                                |
                                +-- getOrCreateSession() [SparkConnectServerListener.scala:322]
                                +-- updateLiveStore() [SparkConnectServerListener.scala:312]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

SessionHolder      ───▶ SessionEventsManager.postStarted()       ───▶ SparkListenerConnectSessionStarted
(sessionId, userId)         |                                            |
                            +-- assertStatus (Pending->Started)          +-- LiveListenerBus
                            +-- clock.getTimeMillis()                    |
                            +-- listenerBus.post()                       +-- SparkConnectServerListener
                                                                         |   (LiveSessionData作成)
                                                                         +-- KVStore (SessionInfo保存)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SessionEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` | ソース | イベントクラス定義とイベント発火元 |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | UI用のリスナー実装 |
| SessionEventsManagerSuite.scala | `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/service/SessionEventsManagerSuite.scala` | テスト | イベント発火のテスト |
