# 通知設計書 88-SparkListenerConnectSessionClosed

## 概要

本ドキュメントは、Apache Spark Connect における `SparkListenerConnectSessionClosed` イベント通知の設計を定義する。本イベントはConnectセッションが閉じられた際に発火する。

### 本通知の処理概要

`SparkListenerConnectSessionClosed` は、Spark Connectにおいてクライアントのセッションが閉じられた際に、SessionEventsManagerのpostClosedメソッドから発火されるイベントである。このイベントはセッションID、ユーザーID、イベント時刻、追加タグを含む。

**業務上の目的・背景**：セッションのクローズはクライアント接続の終了を意味し、セッションに紐づくリソース（SparkSession、キャッシュ等）の解放トリガーとなる。セッション終了を通知することで、UIからセッションを完了状態に更新し、接続中のクライアント数を正確に追跡でき、リソースの適切な管理が可能となる。

**通知の送信タイミング**：SessionEventsManager.postClosedメソッドにおいて、セッションのステータスがStartedからClosedに遷移する際に発火される。assertStatusにより、Started状態からのみClosedへの遷移が許可される。

**通知の受信者**：SparkListenerインターフェースを実装したすべてのリスナーが受信対象となる。主な受信者はSparkConnectServerListener（onOtherEvent経由でonSessionClosedが呼ばれ、LiveSessionDataのfinishTimestampが更新される）。

**通知内容の概要**：sessionId（セッション識別子）、userId（ユーザー識別子）、eventTime（イベント生成時刻のミリ秒）、extraTags（追加メタデータ、デフォルトは空Map）を含む。

**期待されるアクション**：リスナーはセッション終了を検知し、UIのセッション情報にfinishTimestampを設定する。セッション統計の集計やリソース解放の確認を行う。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

SparkContextのLiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャスト配信される。onOtherEventメソッドを通じてSparkConnectServerListenerに配信され、onSessionClosedハンドラが呼ばれる。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- sessionId: {セッション識別子}
- userId: {ユーザー識別子}
- eventTime: {イベント生成時刻（ミリ秒）}
- extraTags: {追加メタデータ（デフォルト: 空Map）}
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| sessionId | セッション識別子 | sessionHolder.sessionId | Yes |
| userId | ユーザー識別子 | sessionHolder.userId | Yes |
| eventTime | イベント生成時刻 | clock.getTimeMillis() | Yes |
| extraTags | 追加メタデータ | デフォルト空Map | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| セッション終了 | SessionEventsManager.postClosed呼び出し | ステータスがStartedの場合 | セッション終了処理時にpostClosedが呼ばれる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスがStarted以外 | assertStatusにより、Started以外の状態からClosedへの遷移はIllegalStateExceptionがスローされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[セッション終了要求] --> B[SessionEventsManager.postClosed]
    B --> C{status == Started?}
    C -->|Yes| D[status = Closed]
    C -->|No| E[IllegalStateException]
    D --> F[sparkContext.listenerBus.post SparkListenerConnectSessionClosed]
    F --> G[SparkConnectServerListener.onOtherEvent]
    G --> H[onSessionClosed finishTimestamp更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、データベースは使用しない）

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | SessionInfoのfinishTimestampを更新（SparkConnectServerListener経由） |

#### SessionInfo (KVStore)

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | finishTimestamp | e.eventTime | セッション終了時刻を記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不正状態遷移 | status != Startedの場合 | IllegalStateExceptionがスローされる |
| イベントドロップ | LiveListenerBusのキューが満杯の場合 | イベントはドロップされログに記録される |
| 未知のセッションID | sessionListにセッションが存在しない場合 | logWarningが出力される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（セッション終了時に1回発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。セッション終了時に随時発火される。

## セキュリティ考慮事項

本イベントにはsessionIdとuserIdが含まれる。セッション終了情報は接続のライフサイクルを示すため、アクセスログと同等のセキュリティレベルで管理すべきである。

## 備考

- SparkConnectServerListenerのonSessionClosedでは、sessionListからセッションを削除し（computeでnullを返す）、最終的にKVStoreに書き込む。
- セッション終了後のfinishTimestampに基づいて、UIのクリーンアップ処理（retainedSessionsを超えた古いセッションの削除）がトリガーされる。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SessionEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` | 行121-126: SparkListenerConnectSessionClosedケースクラスの定義を確認する |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SessionEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` | 行71-79: postClosedメソッドの処理フローを理解する |

**主要処理フロー**:
1. **行72**: assertStatus(List(SessionStatus.Started), SessionStatus.Closed)で遷移検証
2. **行73-78**: sparkContext.listenerBus.postでイベント発火
3. **行75-77**: SparkListenerConnectSessionClosed(sessionId, userId, clock.getTimeMillis())でイベント生成

#### Step 3: リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 行129: onOtherEventでSparkListenerConnectSessionClosedをマッチング |
| 3-2 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 行285-300: onSessionClosedメソッドの処理（sessionList.computeでnull返却、finishTimestamp更新）を確認する |

### プログラム呼び出し階層図

```
セッション終了処理
    |
    +-- SessionEventsManager.postClosed() [SessionEventsManager.scala:71]
           |
           +-- assertStatus(Started, Closed) [SessionEventsManager.scala:81]
           |
           +-- sparkContext.listenerBus.post(SparkListenerConnectSessionClosed) [SessionEventsManager.scala:73]
                  |
                  +-- SparkConnectServerListener.onOtherEvent() [SparkConnectServerListener.scala:118]
                         |
                         +-- onSessionClosed() [SparkConnectServerListener.scala:285]
                                |
                                +-- sessionList.compute() [SparkConnectServerListener.scala:286]
                                +-- updateStoreWithTriggerEnabled() [SparkConnectServerListener.scala:290]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

SessionHolder      ───▶ SessionEventsManager.postClosed()        ───▶ SparkListenerConnectSessionClosed
(sessionId, userId)         |                                            |
                            +-- assertStatus (Started->Closed)           +-- LiveListenerBus
                            +-- clock.getTimeMillis()                    |
                            +-- listenerBus.post()                       +-- SparkConnectServerListener
                                                                         |   (finishTimestamp更新)
                                                                         +-- KVStore (SessionInfo更新)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SessionEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` | ソース | イベントクラス定義とイベント発火元 |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | UI用のリスナー実装 |
| SessionEventsManagerSuite.scala | `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/service/SessionEventsManagerSuite.scala` | テスト | イベント発火のテスト |
