# 通知設計書 90-SparkListenerConnectOperationAnalyzed

## 概要

本ドキュメントは、Apache Spark Connect における `SparkListenerConnectOperationAnalyzed` イベント通知の設計を定義する。本イベントはConnectリクエストの分析（Analysis）が完了した際に発火する。

### 本通知の処理概要

`SparkListenerConnectOperationAnalyzed` は、Spark ConnectにおいてクライアントからのリクエストがQueryPlanningTrackerのAnalysisフェーズを完了した際に、ExecuteEventsManagerのpostAnalyzedメソッドから発火されるイベントである。このイベントはジョブタグ、オペレーションID、イベント時刻を含み、オプションで解析済みプラン（analyzedPlan）やパース済みプラン（parsedPlan）を保持する。

**業務上の目的・背景**：Spark Connectのリクエスト処理パイプラインはStarted -> Analyzed -> ReadyForExecution -> Finished/Failed/Canceledの段階を踏む。Analysis（分析）段階は、論理プランの解析・検証を行う重要なフェーズであり、この段階の完了を通知することで、分析時間のモニタリング、分析失敗の検出、プランの最適化状態の確認が可能となる。

**通知の送信タイミング**：ExecuteEventsManager.postAnalyzedメソッドにおいて、オペレーションのステータスがStartedまたはAnalyzedからAnalyzedに遷移する際に発火される。QueryPlanningTrackerCallbackのanalyzedコールバックまたはanalysisFailedコールバックから呼び出される。

**通知の受信者**：SparkListenerインターフェースを実装したすべてのリスナーが受信対象となる。主な受信者はSparkConnectServerListener（onOtherEvent経由でonOperationAnalyzedが呼ばれ、LiveExecutionDataのstateがCOMPILEDに更新される）。

**通知内容の概要**：jobTag（Sparkジョブタグ）、operationId（36文字UUID）、eventTime（イベント時刻）、extraTags（追加メタデータ）を含む。加えて、analyzedPlan（解析成功時の論理プラン）やparsedPlan（解析失敗時のパース済みプラン）がオプションで設定される。

**期待されるアクション**：リスナーはオペレーションの分析完了を検知し、UIのオペレーション状態をCOMPILEDに更新する。分析時間の統計を記録し、分析失敗時にはエラーハンドリングを行う。

## 通知種別

アプリ内通知（Sparkリスナーバス経由のイベント駆動型通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベント配信失敗時はドロップ） |

### 送信先決定ロジック

SparkContextのLiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャスト配信される。onOtherEventメソッドを通じてSparkConnectServerListenerに配信され、onOperationAnalyzedハンドラが呼ばれる。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、プログラム内イベントとして配信される。メールテンプレートは該当しない。

### 本文テンプレート

```
イベントデータ構造:
- jobTag: {Sparkジョブタグ}
- operationId: {36文字UUID}
- eventTime: {イベント生成時刻（ミリ秒）}
- extraTags: {追加メタデータ（デフォルト: 空Map）}
- parsedPlan: {パース済み論理プラン（解析失敗時、オプション）}
- analyzedPlan: {解析済み論理プラン（解析成功時、オプション）}
```

### 添付ファイル

該当なし（プログラム内イベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobTag | Sparkジョブタグ | executeHolder.jobTag | Yes |
| operationId | オペレーション識別子（UUID） | executeHolder.operationId | Yes |
| eventTime | イベント生成時刻 | clock.getTimeMillis() | Yes |
| extraTags | 追加メタデータ | デフォルト空Map | No |
| parsedPlan | パース済み論理プラン | QueryPlanningTrackerCallback.analysisFailed引数 | No |
| analyzedPlan | 解析済み論理プラン | QueryPlanningTrackerCallback.analyzed引数 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 分析完了 | QueryPlanningTracker.ANALYSISフェーズ完了 | ステータスがStartedまたはAnalyzedの場合 | QueryPlanningTrackerCallbackのanalyzedまたはanalysisFailedコールバックからpostAnalyzedが呼ばれる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスがStarted/Analyzed以外 | assertStatusにより、Started/Analyzed以外の状態からの遷移はIllegalStateExceptionがスローされる |
| セッションが未開始 | sessionHolder.eventManager.statusがStartedでない場合、IllegalStateExceptionがスローされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[QueryPlanningTracker.ANALYSISフェーズ] --> B{分析成功?}
    B -->|Yes| C[callback.analyzed analyzedPlan]
    B -->|No| D[callback.analysisFailed parsedPlan]
    C --> E[ExecuteEventsManager.postAnalyzed analyzedPlan=Some]
    D --> F[ExecuteEventsManager.postAnalyzed parsedPlan=Some]
    E --> G[assertStatus Started/Analyzed -> Analyzed]
    F --> G
    G --> H[SparkListenerConnectOperationAnalyzed生成]
    H --> I[event.analyzedPlan / event.parsedPlan設定]
    I --> J[listenerBus.post]
    J --> K[SparkConnectServerListener.onOperationAnalyzed]
    K --> L[LiveExecutionData.state = COMPILED]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリイベントバス経由の通知であり、RDBは使用しない）

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | ExecutionInfoのstateをCOMPILEDに更新する |

#### ExecutionInfo (KVStore)

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | state | COMPILED | ExecutionState.COMPILED |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不正状態遷移 | status != Started/Analyzedの場合 | IllegalStateExceptionがスローされる |
| セッション未開始 | sessionStatus != Startedの場合 | IllegalStateExceptionがスローされる |
| 未知のオペレーション | executionListにjobTagが存在しない場合 | logWarningが出力される（SparkConnectServerListener） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（分析完了時に1回以上発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。分析完了時に随時発火される。

## セキュリティ考慮事項

本イベントのanalyzedPlanとparsedPlanは@JsonIgnoreアノテーション付きであり、JSON/イベントログへのシリアライズ時には除外される。ただし、インメモリではLogicalPlanオブジェクトが保持されるため、リスナー実装内でプラン情報を外部に出力する場合はテーブル名やカラム名等の機密情報に注意が必要である。

## 備考

- postAnalyzedメソッドは、StartedまたはAnalyzedの両状態から呼び出し可能である。これは、QueryPlanningTrackerのコールバックが複数回呼ばれる場合に対応するためである。
- createQueryPlanningTrackerメソッドにより、QueryPlanningTrackerCallbackが作成され、analyzedコールバックではpostAnalyzed(Some(analyzedPlan))が、analysisFailedコールバックではpostAnalyzed(parsedPlan=Some(parsedPlan))が呼ばれる。
- SparkConnectServerListenerでは、このイベント受信時にExecutionStateをCOMPILEDに設定する。AnalyzedとCOMPILEDの名称の違いに注意（Connectレイヤーでは「Analyzed」、UIレイヤーでは「COMPILED」と表記される）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 行349-367: SparkListenerConnectOperationAnalyzedケースクラスの定義を確認する。parsedPlanとanalyzedPlanは@JsonIgnore付きvarフィールド |
| 1-2 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 行36-47: ExecuteStatus列挙でAnalyzed状態を確認する |

**読解のコツ**: parsedPlanとanalyzedPlanはcase classのコンストラクタパラメータではなく、後から設定されるvarフィールドである。解析成功時はanalyzedPlanが設定され、解析失敗時はparsedPlanが設定される（両方同時には設定されない）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 行153-162: postAnalyzedメソッドの処理フローを理解する |
| 2-2 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 行254-268: createQueryPlanningTrackerメソッドでコールバックの設定を理解する |

**主要処理フロー**:
1. **行156**: assertStatus(List(ExecuteStatus.Started, ExecuteStatus.Analyzed), ExecuteStatus.Analyzed)で遷移検証
2. **行157-158**: SparkListenerConnectOperationAnalyzed(jobTag, operationId, clock.getTimeMillis())でイベント生成
3. **行159**: event.analyzedPlan = analyzedPlanでオプションの解析済みプランを設定
4. **行160**: event.parsedPlan = parsedPlanでオプションのパース済みプランを設定
5. **行161**: listenerBus.post(event)でイベント発火

#### Step 3: コールバック経由の呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 行255-267: QueryPlanningTrackerCallbackの実装を理解する。analyzedとanalysisFailedの2つのコールバックがある |

#### Step 4: リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 行122: onOtherEventでSparkListenerConnectOperationAnalyzedをマッチング |
| 4-2 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 行195-206: onOperationAnalyzedメソッドでstateをCOMPILEDに更新する処理を確認する |

### プログラム呼び出し階層図

```
QueryPlanningTracker (Catalyst)
    |
    +-- QueryPlanningTrackerCallback.analyzed(plan) [ExecuteEventsManager.scala:256]
    |      |
    |      +-- postAnalyzed(Some(analyzedPlan)) [ExecuteEventsManager.scala:257]
    |
    +-- QueryPlanningTrackerCallback.analysisFailed(parsedPlan) [ExecuteEventsManager.scala:260]
           |
           +-- postAnalyzed(parsedPlan=Some(parsedPlan)) [ExecuteEventsManager.scala:263]
                  |
                  +-- assertStatus(Started/Analyzed, Analyzed) [ExecuteEventsManager.scala:156]
                  |
                  +-- listenerBus.post(SparkListenerConnectOperationAnalyzed) [ExecuteEventsManager.scala:161]
                         |
                         +-- SparkConnectServerListener.onOtherEvent() [SparkConnectServerListener.scala:118]
                                |
                                +-- onOperationAnalyzed() [SparkConnectServerListener.scala:195]
                                       |
                                       +-- updateLiveStore(state=COMPILED) [SparkConnectServerListener.scala:198]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

QueryPlanningTracker ───▶ ExecuteEventsManager.postAnalyzed()    ───▶ SparkListenerConnectOperationAnalyzed
(analyzed/failed)           |                                            |
                            +-- assertStatus検証                          +-- LiveListenerBus
                            +-- event構築 (jobTag, operationId, time)     |
                            +-- analyzedPlan/parsedPlan設定               +-- SparkConnectServerListener
                            +-- listenerBus.post()                       |   (state=COMPILED)
                                                                         +-- KVStore (ExecutionInfo更新)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | ソース | イベントクラス定義とイベント発火元 |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | UI用のリスナー実装 |
| QueryPlanningTracker.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/QueryPlanningTracker.scala` | ソース | 分析フェーズのコールバック元 |
| ExecuteEventsManagerSuite.scala | `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/service/ExecuteEventsManagerSuite.scala` | テスト | イベント発火のテスト |
