# 通知設計書 91-SparkListenerConnectOperationReadyForExecution

## 概要

本ドキュメントは、Apache SparkのSpark Connectモジュールにおける `SparkListenerConnectOperationReadyForExecution` イベント通知の設計を記述する。このイベントは、Connectリクエストの分析・計画フェーズが完了し、実行準備が整った際に発火する内部イベントである。

### 本通知の処理概要

本通知は、Spark ConnectサーバがクライアントからのExecutePlanRequestを受信し、SQLの分析（Analysis）およびプランニング（Planning）フェーズが完了した後、実際の実行開始前に発火するイベントを定義する。

**業務上の目的・背景**：Spark Connectは、クライアントとSparkクラスタ間のリモート接続を提供するモジュールである。クライアントから受信したリクエストは、受信 -> 分析 -> 計画 -> 実行 -> 完了という複数のフェーズを経る。本通知は「計画完了・実行準備完了」のタイミングを捕捉することで、Spark Connect Server UIにおけるオペレーションの状態遷移を正確に追跡し、管理者やユーザがリクエストの進行状況をリアルタイムに把握できるようにする。

**通知の送信タイミング**：Connectリクエストの分析（Analysis）が完了し、実行計画（Planning）が確定した後に発火する。具体的には、eagerコマンドの場合はAnalysisフェーズ完了後、その他のリクエストではPlanningフェーズ完了後にQueryPlanningTrackerのコールバックを通じて発火する。ExecuteEventsManagerのassertStatusにより、直前のステータスがAnalyzedであることが検証される。

**通知の受信者**：SparkConnectServerListener（Spark Connect Server UIコンポーネント）が主たる受信者である。LiveListenerBus経由で非同期に配信され、UIの状態表示を更新する。開発者やサードパーティのSparkListenerも受信可能である。

**通知内容の概要**：jobTag（Sparkジョブタグ、セッション・リクエスト間で一意）、operationId（36文字のUUID）、eventTime（イベント発生時刻のミリ秒タイムスタンプ）、extraTags（追加メタデータ）を含む。

**期待されるアクション**：受信したリスナーは、当該オペレーションの状態をREADYに更新する。UI上では、オペレーションが分析・計画を完了し、実行待ち状態であることが視覚的に表示される。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。SparkConnectServerListenerがonOtherEventメソッドでパターンマッチにより受信し、onOperationReadyForExecutionメソッドで処理する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerConnectOperationReadyForExecution
フィールド:
  jobTag: {jobTag}
  operationId: {operationId}
  eventTime: {eventTime}
  extraTags: {extraTags}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobTag | Sparkジョブタグ（セッション・リクエスト間で一意） | ExecuteHolder.jobTag | Yes |
| operationId | 36文字のUUID | ExecuteHolder.operationId | Yes |
| eventTime | イベント発生時刻（ミリ秒） | Clock.getTimeMillis() | Yes |
| extraTags | 追加メタデータ | デフォルト: Map.empty | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | QueryPlanningTracker.readyForExecution コールバック | 現在のステータスがAnalyzedであること | 分析・計画完了後にQueryPlanningTrackerCallbackから呼び出される |
| API（内部） | ExecuteEventsManager.postReadyForExecution() | セッションステータスがStartedであること | ExecuteEventsManagerが直接呼び出す場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスがAnalyzed以外 | assertStatusにより、直前のステータスがAnalyzedでない場合はIllegalStateExceptionがスローされる |
| セッションがStartedでない | セッションのステータスがStartedでない場合はIllegalStateExceptionがスローされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[クライアントからExecutePlanRequest受信] --> B[postStarted: Startedイベント発火]
    B --> C[SQL分析フェーズ]
    C --> D[postAnalyzed: Analyzedイベント発火]
    D --> E[実行計画フェーズ]
    E --> F[QueryPlanningTracker.readyForExecution コールバック]
    F --> G[ExecuteEventsManager.postReadyForExecution]
    G --> H{assertStatus: Analyzed?}
    H -->|Yes| I[SparkListenerConnectOperationReadyForExecution生成]
    H -->|No| J[IllegalStateException]
    I --> K[LiveListenerBus.post]
    K --> L[SparkConnectServerListener.onOperationReadyForExecution]
    L --> M[LiveExecutionData.state = READY]
    M --> N[KVStore更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | オペレーションの実行データ管理 | インメモリ。jobTagをキーとする |

### テーブル別参照項目詳細

#### executionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveExecutionData | 実行中オペレーションの状態管理 | jobTagで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | ExecutionInfoのstate をREADYに更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | state | ExecutionState.READY | LiveExecutionDataのstateフィールドを更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IllegalStateException | 現在のステータスがAnalyzedでない場合 | 例外がスローされ、呼び出し元で処理される |
| IllegalStateException | セッションステータスがStartedでない場合 | 例外がスローされ、呼び出し元で処理される |
| 不明なオペレーション | executionListにjobTagが存在しない場合 | ログ警告を出力し、処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（イベントバスのキャパシティに依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。Spark Connectサーバが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- 本イベントはSpark JVMプロセス内部のイベントバスで配信されるため、外部ネットワークへの露出はない
- jobTag、operationIdは内部識別子であり、個人情報は含まない
- extraTagsにユーザ定義のメタデータが含まれる可能性があるが、イベント自体はプロセス内配信のため暗号化は不要

## 備考

- 本イベントはExecuteStatusの状態遷移において、Analyzed -> ReadyForExecution の遷移を表す
- eagerコマンドの場合はAnalysis完了直後、その他のリクエストではPlanning完了後に発火する
- SparkConnectServerListenerはonOtherEventメソッド内でパターンマッチにより本イベントを識別する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントクラスとステータスの定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 384-389行目: SparkListenerConnectOperationReadyForExecution case classの定義。jobTag, operationId, eventTime, extraTagsフィールドを持つ |
| 1-2 | ExecuteEventsManager.scala | 同上 | 36-47行目: ExecuteStatusオブジェクトの定義。Pending, Started, Analyzed, ReadyForExecution, Finished, Failed, Canceled, Closedの状態遷移を理解する |

**読解のコツ**: ExecuteStatusはsealed abstract classで定義されており、パターンマッチで網羅性チェックが可能。ReadyForExecution(3)はAnalyzed(2)の次の状態である。

#### Step 2: エントリーポイントを理解する

処理の起点となるpostReadyForExecutionメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 168-172行目: postReadyForExecution()メソッド。assertStatusでAnalyzedからの遷移を検証し、イベントを生成してlistenerBus.postで配信する |

**主要処理フロー**:
1. **169行目**: assertStatus(List(ExecuteStatus.Analyzed), ExecuteStatus.ReadyForExecution) - ステータス検証
2. **170-171行目**: SparkListenerConnectOperationReadyForExecution生成とlistenerBus.post - イベント配信

#### Step 3: コールバックからの呼び出しを理解する

QueryPlanningTrackerCallbackからの呼び出し経路を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 254-268行目: createQueryPlanningTracker()メソッド。QueryPlanningTrackerCallbackのreadyForExecutionコールバックがpostReadyForExecution()を呼び出す |

**主要処理フロー**:
- **266行目**: readyForExecution(tracker) => postReadyForExecution() がコールバックとして登録される

#### Step 4: リスナー側の処理を理解する

SparkConnectServerListenerでの受信処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 118-132行目: onOtherEventメソッドでパターンマッチにより本イベントを識別 |
| 4-2 | SparkConnectServerListener.scala | 同上 | 208-219行目: onOperationReadyForExecutionメソッド。executionListからjobTagで検索し、stateをExecutionState.READYに更新 |

**主要処理フロー**:
- **123行目**: パターンマッチでSparkListenerConnectOperationReadyForExecutionを識別
- **212-213行目**: executionData.state = ExecutionState.READY に更新

### プログラム呼び出し階層図

```
QueryPlanningTracker (実行計画フェーズ完了)
    |
    +-- QueryPlanningTrackerCallback.readyForExecution()
            |
            +-- ExecuteEventsManager.postReadyForExecution()
                    |
                    +-- assertStatus(List(Analyzed), ReadyForExecution)
                    |
                    +-- SparkListenerConnectOperationReadyForExecution 生成
                    |
                    +-- LiveListenerBus.post(event)
                            |
                            +-- SparkConnectServerListener.onOtherEvent()
                                    |
                                    +-- onOperationReadyForExecution()
                                            |
                                            +-- executionList.get(jobTag)
                                            |
                                            +-- updateLiveStore(executionData)
                                                    |
                                                    +-- state = ExecutionState.READY
```

### データフロー図

```
[入力]                          [処理]                              [出力]

QueryPlanningTracker     -->  ExecuteEventsManager              -->  LiveListenerBus
 (Planning完了通知)             .postReadyForExecution()              (イベント配信)
                                   |
                                   v
                          SparkListenerConnect            -->  SparkConnectServerListener
                          OperationReadyForExecution            (状態更新)
                           {jobTag, operationId,                    |
                            eventTime, extraTags}                   v
                                                            LiveExecutionData
                                                             .state = READY
                                                                    |
                                                                    v
                                                            ElementTrackingStore
                                                             (KVStore永続化)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | イベント受信・UI状態更新ロジック |
| ExecuteHolder.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteHolder.scala` | ソース | ExecuteEventsManagerの保持とpostClosed呼び出し |
| SparkConnectPlanExecution.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/SparkConnectPlanExecution.scala` | ソース | 実行計画の実行とpostFinished呼び出し |
| ExecuteEventsManagerSuite.scala | `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/service/ExecuteEventsManagerSuite.scala` | テスト | イベント発火の単体テスト |
