# 通知設計書 92-SparkListenerConnectOperationCanceled

## 概要

本ドキュメントは、Apache SparkのSpark Connectモジュールにおける `SparkListenerConnectOperationCanceled` イベント通知の設計を記述する。このイベントは、Connectリクエストがキャンセルされた際に発火する内部イベントである。

### 本通知の処理概要

本通知は、Spark Connectサーバにおいてクライアントからのリクエストがキャンセルされた際に発火するイベントを定義する。ユーザによる明示的なキャンセル操作やインタラプト処理によってトリガーされる。

**業務上の目的・背景**：Spark Connectにおいて、長時間実行中のクエリやオペレーションをユーザがキャンセルする場面がある。本通知はキャンセルイベントを捕捉し、Spark Connect Server UIにおけるオペレーション状態の追跡を可能にする。管理者はUI上でどのオペレーションがキャンセルされたか、そのタイミングを確認でき、運用上の問題分析やユーザの利用状況把握に活用できる。

**通知の送信タイミング**：リクエストの処理中にインタラプトが発生し、ErrorUtils内のエラーハンドリング処理でisInterruptedがtrueと判定された場合に発火する。ExecuteEventsManagerのpostCanceledメソッドが呼ばれ、ステータスがStarted, Analyzed, ReadyForExecution, Finished, Failedのいずれかからの遷移時に発火する。

**通知の受信者**：SparkConnectServerListenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。UIの状態表示を更新する。

**通知内容の概要**：jobTag（Sparkジョブタグ）、operationId（36文字UUID）、eventTime（イベント発生時刻ミリ秒タイムスタンプ）、extraTags（追加メタデータ）を含む。

**期待されるアクション**：受信したリスナーは、当該オペレーションの状態をCANCELEDに更新し、finishTimestampを記録する。UI上でキャンセル状態が表示される。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。SparkConnectServerListenerがonOtherEventメソッドでパターンマッチにより受信し、onOperationCanceledメソッドで処理する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerConnectOperationCanceled
フィールド:
  jobTag: {jobTag}
  operationId: {operationId}
  eventTime: {eventTime}
  extraTags: {extraTags}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobTag | Sparkジョブタグ（セッション・リクエスト間で一意） | ExecuteHolder.jobTag | Yes |
| operationId | 36文字のUUID | ExecuteHolder.operationId | Yes |
| eventTime | イベント発生時刻（ミリ秒） | Clock.getTimeMillis() | Yes |
| extraTags | 追加メタデータ | デフォルト: Map.empty | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | ErrorUtils内のエラーハンドリングでisInterrupted判定 | isInterrupted == true | インタラプトによるキャンセル時 |
| API（内部） | ExecuteEventsManager.postCanceled() | ステータスがStarted, Analyzed, ReadyForExecution, Finished, Failedのいずれか | 明示的なキャンセル呼び出し時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスが許可リスト外 | assertStatusにより、直前のステータスがStarted, Analyzed, ReadyForExecution, Finished, Failedのいずれでもない場合はIllegalStateExceptionがスローされる |
| セッションがStartedでない | セッションのステータスがStartedでない場合はIllegalStateExceptionがスローされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[オペレーション実行中] --> B{インタラプト発生?}
    B -->|Yes| C[ErrorUtils: isInterrupted判定]
    C --> D[ExecuteEventsManager.postCanceled]
    D --> E{assertStatus: 有効なステータス?}
    E -->|Yes| F[canceled = Some true]
    E -->|No| G[IllegalStateException]
    F --> H[SparkListenerConnectOperationCanceled生成]
    H --> I[LiveListenerBus.post]
    I --> J[SparkConnectServerListener.onOperationCanceled]
    J --> K[finishTimestamp設定 / state = CANCELED]
    K --> L[KVStore更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | オペレーションの実行データ管理 | インメモリ。jobTagをキーとする |

### テーブル別参照項目詳細

#### executionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveExecutionData | 実行中オペレーションの状態管理 | jobTagで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | ExecutionInfoのstateをCANCELED、finishTimestampを更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | state | ExecutionState.CANCELED | LiveExecutionDataのstateフィールドを更新 |
| UPDATE | finishTimestamp | eventTime | キャンセル時刻を記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IllegalStateException | 現在のステータスが許可リスト外の場合 | 例外がスローされ、呼び出し元で処理される |
| IllegalStateException | セッションステータスがStartedでない場合 | 例外がスローされ、呼び出し元で処理される |
| 不明なオペレーション | executionListにjobTagが存在しない場合 | ログ警告を出力し、処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（イベントバスのキャパシティに依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。Spark Connectサーバが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- 本イベントはSpark JVMプロセス内部のイベントバスで配信されるため、外部ネットワークへの露出はない
- jobTag、operationIdは内部識別子であり、個人情報は含まない
- canceled内部フラグはOption[Boolean]で管理され、キャンセル状態の追跡に使用される

## 備考

- 本イベントはExecuteStatusの状態遷移において、Started/Analyzed/ReadyForExecution/Finished/Failed -> Canceled の遷移を表す
- postCanceled呼び出し時に内部のcanceledフラグがSome(true)に設定され、hasCanceledメソッドで参照可能
- ErrorUtils.scalaの338-344行目で、isInterruptedの場合はpostCanceled、そうでない場合はpostFailedが呼び分けられる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベントクラスの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 404-409行目: SparkListenerConnectOperationCanceled case classの定義。jobTag, operationId, eventTime, extraTagsフィールドを持つ |
| 1-2 | ExecuteEventsManager.scala | 同上 | 36-47行目: ExecuteStatusオブジェクトの定義。Canceled(6)の位置づけを理解する |

**読解のコツ**: Canceledは複数の先行ステータスから遷移可能であり、Finished/Failedからも遷移できる点がユニークである。

#### Step 2: エントリーポイントを理解する

postCanceledメソッドの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 177-189行目: postCanceled()メソッド。assertStatusで遷移元ステータスを検証し、canceledフラグを設定後、イベントを生成してlistenerBusに送信 |

**主要処理フロー**:
1. **178-185行目**: assertStatus - Started, Analyzed, ReadyForExecution, Finished, Failedからの遷移を許可
2. **186行目**: canceled = Some(true) - 内部フラグ設定
3. **187-188行目**: listenerBus.post - イベント配信

#### Step 3: 呼び出し元を理解する

ErrorUtilsからの呼び出しパスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ErrorUtils.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/utils/ErrorUtils.scala` | 338-344行目: isInterruptedがtrueの場合にpostCanceled、falseの場合にpostFailedを呼び分ける |

**主要処理フロー**:
- **341行目**: executeEventsManager.postCanceled() - インタラプト時に呼び出し

#### Step 4: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 222-234行目: onOperationCanceledメソッド。executionListからjobTagで検索し、finishTimestampとstateをCANCELEDに更新 |

**主要処理フロー**:
- **226行目**: executionData.finishTimestamp = e.eventTime
- **227行目**: executionData.state = ExecutionState.CANCELED

### プログラム呼び出し階層図

```
ErrorUtils (エラーハンドリング)
    |
    +-- isInterrupted判定
            |
            +-- ExecuteEventsManager.postCanceled()
                    |
                    +-- assertStatus(List(Started, Analyzed, ReadyForExecution, Finished, Failed), Canceled)
                    |
                    +-- canceled = Some(true)
                    |
                    +-- SparkListenerConnectOperationCanceled 生成
                    |
                    +-- LiveListenerBus.post(event)
                            |
                            +-- SparkConnectServerListener.onOtherEvent()
                                    |
                                    +-- onOperationCanceled()
                                            |
                                            +-- finishTimestamp = eventTime
                                            |
                                            +-- state = ExecutionState.CANCELED
```

### データフロー図

```
[入力]                          [処理]                              [出力]

インタラプト発生           -->  ErrorUtils                       -->  LiveListenerBus
 (Thread.interrupt)             .isInterrupted判定                    (イベント配信)
                                   |
                                   v
                          ExecuteEventsManager               -->  SparkConnectServerListener
                           .postCanceled()                          (状態更新)
                                   |                                    |
                                   v                                    v
                          SparkListenerConnect               LiveExecutionData
                          OperationCanceled                   .state = CANCELED
                           {jobTag, operationId,              .finishTimestamp = eventTime
                            eventTime, extraTags}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | イベント受信・UI状態更新ロジック |
| ErrorUtils.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/utils/ErrorUtils.scala` | ソース | エラーハンドリングとpostCanceled/postFailed呼び分け |
| ExecuteHolder.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteHolder.scala` | ソース | ExecuteEventsManagerの保持 |
| ExecuteEventsManagerSuite.scala | `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/service/ExecuteEventsManagerSuite.scala` | テスト | イベント発火の単体テスト |
