# 通知設計書 93-SparkListenerConnectOperationFailed

## 概要

本ドキュメントは、Apache SparkのSpark Connectモジュールにおける `SparkListenerConnectOperationFailed` イベント通知の設計を記述する。このイベントは、Connectリクエストの処理中にエラーが発生して失敗した際に発火する内部イベントである。

### 本通知の処理概要

本通知は、Spark Connectサーバにおいてクライアントからのリクエストがエラーにより失敗した際に発火するイベントを定義する。分析フェーズ、計画フェーズ、実行フェーズのいずれにおいてもエラー発生時に本イベントが生成される。

**業務上の目的・背景**：Spark Connectにおいて、クエリの実行失敗はユーザ体験や運用に直結する重要なイベントである。本通知は失敗イベントを捕捉し、エラーメッセージとともにSpark Connect Server UIに表示することで、管理者やユーザがエラーの原因特定やトラブルシューティングを効率的に行えるようにする。

**通知の送信タイミング**：リクエストの処理中にエラーが発生し、ErrorUtils内のエラーハンドリング処理でisInterruptedがfalseと判定された場合に発火する。ExecuteEventsManagerのpostFailedメソッドが呼ばれ、ステータスがStarted, Analyzed, ReadyForExecution, Finishedのいずれかからの遷移時に発火する。

**通知の受信者**：SparkConnectServerListenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。

**通知内容の概要**：jobTag、operationId、eventTime、errorMessage（エラーメッセージ）、extraTagsを含む。

**期待されるアクション**：受信したリスナーは、当該オペレーションの状態をFAILEDに更新し、finishTimestampとdetail（エラーメッセージ）を記録する。UI上でエラー状態とエラーメッセージが表示される。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 高 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。SparkConnectServerListenerがonOtherEventメソッドでパターンマッチにより受信し、onOperationFailedメソッドで処理する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerConnectOperationFailed
フィールド:
  jobTag: {jobTag}
  operationId: {operationId}
  eventTime: {eventTime}
  errorMessage: {errorMessage}
  extraTags: {extraTags}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobTag | Sparkジョブタグ（セッション・リクエスト間で一意） | ExecuteHolder.jobTag | Yes |
| operationId | 36文字のUUID | ExecuteHolder.operationId | Yes |
| eventTime | イベント発生時刻（ミリ秒） | Clock.getTimeMillis() | Yes |
| errorMessage | エラーのメッセージ | Exception.getMessage | Yes |
| extraTags | 追加メタデータ | デフォルト: Map.empty | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | ErrorUtils内のエラーハンドリングでisInterrupted == false | エラー発生かつインタラプトでない | 実行エラー時 |
| API（内部） | ExecuteEventsManager.postFailed(errorMessage) | ステータスがStarted, Analyzed, ReadyForExecution, Finishedのいずれか | 明示的な失敗通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスが許可リスト外 | assertStatusにより、直前のステータスがStarted, Analyzed, ReadyForExecution, Finishedのいずれでもない場合はIllegalStateExceptionがスローされる |
| セッションがStartedでない | セッションのステータスがStartedでない場合はIllegalStateExceptionがスローされる |
| インタラプトによるキャンセル | isInterruptedがtrueの場合はpostCanceledが呼ばれ、本イベントは発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[オペレーション実行中にエラー発生] --> B{isInterrupted?}
    B -->|Yes| C[postCanceled - 別イベント]
    B -->|No| D[ExecuteEventsManager.postFailed]
    D --> E{assertStatus: 有効なステータス?}
    E -->|Yes| F[error = Some true]
    E -->|No| G[IllegalStateException]
    F --> H[SparkListenerConnectOperationFailed生成]
    H --> I[LiveListenerBus.post]
    I --> J[SparkConnectServerListener.onOperationFailed]
    J --> K[finishTimestamp設定 / detail設定 / state = FAILED]
    K --> L[KVStore更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | オペレーションの実行データ管理 | インメモリ。jobTagをキーとする |

### テーブル別参照項目詳細

#### executionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveExecutionData | 実行中オペレーションの状態管理 | jobTagで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | ExecutionInfoのstate, finishTimestamp, detailを更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | state | ExecutionState.FAILED | LiveExecutionDataのstateフィールドを更新 |
| UPDATE | finishTimestamp | eventTime | 失敗時刻を記録 |
| UPDATE | detail | errorMessage | エラーメッセージを記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IllegalStateException | 現在のステータスが許可リスト外の場合 | 例外がスローされ、呼び出し元で処理される |
| IllegalStateException | セッションステータスがStartedでない場合 | 例外がスローされ、呼び出し元で処理される |
| 不明なオペレーション | executionListにjobTagが存在しない場合 | ログ警告を出力し、処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（イベントバスのキャパシティに依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。Spark Connectサーバが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- 本イベントはSpark JVMプロセス内部のイベントバスで配信されるため、外部ネットワークへの露出はない
- errorMessageにはスタックトレースやクエリ情報が含まれる可能性があり、ログ出力時のマスキングが推奨される
- jobTag、operationIdは内部識別子であり、個人情報は含まない

## 備考

- 本イベントはExecuteStatusの状態遷移において、Started/Analyzed/ReadyForExecution/Finished -> Failed の遷移を表す
- postFailed呼び出し時に内部のerrorフラグがSome(true)に設定され、hasErrorメソッドで参照可能
- Canceledステータスからは遷移不可（キャンセル後の失敗通知は行わない）
- ErrorUtils.scalaの343行目で、wrapped.getMessage()がerrorMessageとして渡される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベントクラスの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 426-432行目: SparkListenerConnectOperationFailed case classの定義。errorMessageフィールドが追加されている点に注目 |

**読解のコツ**: 他のOperationイベント（Canceled, Closed等）と比較して、errorMessageフィールドが追加されている唯一のイベントである。

#### Step 2: エントリーポイントを理解する

postFailedメソッドの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 197-212行目: postFailed(errorMessage)メソッド。assertStatusで遷移元ステータスを検証し、errorフラグを設定後、イベントを生成してlistenerBusに送信 |

**主要処理フロー**:
1. **198-204行目**: assertStatus - Started, Analyzed, ReadyForExecution, Finishedからの遷移を許可（CanceledとFailedは含まない）
2. **205行目**: error = Some(true) - 内部フラグ設定
3. **206-211行目**: SparkListenerConnectOperationFailed生成とlistenerBus.post - イベント配信

#### Step 3: 呼び出し元を理解する

ErrorUtilsからの呼び出しパスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ErrorUtils.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/utils/ErrorUtils.scala` | 338-344行目: isInterruptedがfalseの場合にpostFailed(wrapped.getMessage)を呼び出す |

**主要処理フロー**:
- **343行目**: executeEventsManager.postFailed(wrapped.getMessage) - エラー発生時に呼び出し

#### Step 4: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 235-248行目: onOperationFailedメソッド。finishTimestamp, detail(errorMessage), stateをFAILEDに更新 |

**主要処理フロー**:
- **239行目**: executionData.finishTimestamp = e.eventTime
- **240行目**: executionData.detail = e.errorMessage
- **241行目**: executionData.state = ExecutionState.FAILED

### プログラム呼び出し階層図

```
ErrorUtils (エラーハンドリング)
    |
    +-- !isInterrupted判定
            |
            +-- ExecuteEventsManager.postFailed(errorMessage)
                    |
                    +-- assertStatus(List(Started, Analyzed, ReadyForExecution, Finished), Failed)
                    |
                    +-- error = Some(true)
                    |
                    +-- SparkListenerConnectOperationFailed 生成
                    |       {jobTag, operationId, eventTime, errorMessage}
                    |
                    +-- LiveListenerBus.post(event)
                            |
                            +-- SparkConnectServerListener.onOtherEvent()
                                    |
                                    +-- onOperationFailed()
                                            |
                                            +-- finishTimestamp = eventTime
                                            +-- detail = errorMessage
                                            +-- state = ExecutionState.FAILED
```

### データフロー図

```
[入力]                          [処理]                              [出力]

例外発生                  -->  ErrorUtils                       -->  LiveListenerBus
 (Exception thrown)             .エラーハンドリング                    (イベント配信)
                                   |
                                   v
                          ExecuteEventsManager               -->  SparkConnectServerListener
                           .postFailed(errorMessage)                (状態更新)
                                   |                                    |
                                   v                                    v
                          SparkListenerConnect               LiveExecutionData
                          OperationFailed                     .state = FAILED
                           {jobTag, operationId,              .finishTimestamp = eventTime
                            eventTime, errorMessage}          .detail = errorMessage
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | イベント受信・UI状態更新ロジック |
| ErrorUtils.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/utils/ErrorUtils.scala` | ソース | エラーハンドリングとpostCanceled/postFailed呼び分け |
| ExecuteEventsManagerSuite.scala | `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/service/ExecuteEventsManagerSuite.scala` | テスト | イベント発火の単体テスト |
