# 通知設計書 94-SparkListenerConnectOperationFinished

## 概要

本ドキュメントは、Apache SparkのSpark Connectモジュールにおける `SparkListenerConnectOperationFinished` イベント通知の設計を記述する。このイベントは、Connectリクエストの実行が完了した後、結果がクライアントに送信される前に発火する内部イベントである。

### 本通知の処理概要

本通知は、Spark Connectサーバにおいてクライアントからのリクエスト実行が完了し、結果の生成が終わった時点で発火するイベントを定義する。結果がクライアントに送信される前のタイミングであり、実行フェーズの終了を示す。

**業務上の目的・背景**：Spark Connectにおいて、リクエストの実行完了タイミングを正確に捕捉することは、パフォーマンス分析や実行時間の計測に不可欠である。本通知は実行完了を記録し、producedRowCount（生成行数）とともにSpark Connect Server UIに反映させることで、管理者やユーザがクエリの実行結果の規模感を把握できるようにする。

**通知の送信タイミング**：リクエストの実行が完了した後に発火する。SparkConnectPlanExecutionの各実行パスにおいて、LocalTableScanExecの場合は行数計算後、パーティション実行の場合は全パーティション完了後、空結果の場合は即時に発火する。ExecuteEventsManagerのpostFinishedメソッドが呼ばれ、ステータスがStartedまたはReadyForExecutionからの遷移時に発火する。

**通知の受信者**：SparkConnectServerListenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。

**通知内容の概要**：jobTag、operationId、eventTime、producedRowCount（生成行数、Optional）、extraTags（追加メタデータ）を含む。

**期待されるアクション**：受信したリスナーは、当該オペレーションの状態をFINISHEDに更新し、finishTimestampを記録する。UI上で実行完了状態が表示される。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。SparkConnectServerListenerがonOtherEventメソッドでパターンマッチにより受信し、onOperationFinishedメソッドで処理する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerConnectOperationFinished
フィールド:
  jobTag: {jobTag}
  operationId: {operationId}
  eventTime: {eventTime}
  producedRowCount: {producedRowCount}
  extraTags: {extraTags}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobTag | Sparkジョブタグ（セッション・リクエスト間で一意） | ExecuteHolder.jobTag | Yes |
| operationId | 36文字のUUID | ExecuteHolder.operationId | Yes |
| eventTime | イベント発生時刻（ミリ秒） | Clock.getTimeMillis() | Yes |
| producedRowCount | 返却された行数 | 実行結果から算出 | No（行を返さないオペレーションではNone） |
| extraTags | 追加メタデータ | postFinished引数 or デフォルト: Map.empty | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | SparkConnectPlanExecution: コマンド実行完了 | assertCommandExecuted成功後 | 100行目付近 |
| API（内部） | SparkConnectPlanExecution: LocalTableScanExec完了 | rows.length取得後 | 210行目付近、Some(rows.length)を渡す |
| API（内部） | SparkConnectPlanExecution: 全パーティション完了 | numFinishedPartitions == numPartitions | 242行目付近、Some(totalNumRows)を渡す |
| API（内部） | SparkConnectPlanExecution: 空結果 | パーティションが0の場合 | 298行目付近、Some(0)を渡す |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスが許可リスト外 | assertStatusにより、直前のステータスがStartedまたはReadyForExecutionでない場合はIllegalStateExceptionがスローされる |
| セッションがStartedでない | セッションのステータスがStartedでない場合はIllegalStateExceptionがスローされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[オペレーション実行完了] --> B{実行パスの判定}
    B -->|コマンド| C[assertCommandExecuted]
    B -->|LocalTableScan| D[rows.length取得]
    B -->|パーティション実行| E[全パーティション完了待ち]
    B -->|空結果| F[即時完了]
    C --> G[postFinished - rowCount無し]
    D --> H[postFinished - Some rowsLength]
    E --> I[postFinished - Some totalNumRows]
    F --> J[postFinished - Some 0]
    G --> K[assertStatus / イベント生成]
    H --> K
    I --> K
    J --> K
    K --> L[LiveListenerBus.post]
    L --> M[SparkConnectServerListener.onOperationFinished]
    M --> N[finishTimestamp設定 / state = FINISHED]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | オペレーションの実行データ管理 | インメモリ。jobTagをキーとする |

### テーブル別参照項目詳細

#### executionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveExecutionData | 実行中オペレーションの状態管理 | jobTagで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | ExecutionInfoのstate, finishTimestampを更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | state | ExecutionState.FINISHED | LiveExecutionDataのstateフィールドを更新 |
| UPDATE | finishTimestamp | eventTime | 完了時刻を記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IllegalStateException | 現在のステータスがStartedまたはReadyForExecutionでない場合 | 例外がスローされ、呼び出し元で処理される |
| IllegalStateException | セッションステータスがStartedでない場合 | 例外がスローされ、呼び出し元で処理される |
| 不明なオペレーション | executionListにjobTagが存在しない場合 | ログ警告を出力し、処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（イベントバスのキャパシティに依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。Spark Connectサーバが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- 本イベントはSpark JVMプロセス内部のイベントバスで配信されるため、外部ネットワークへの露出はない
- producedRowCountは行数情報のみで、実データは含まない
- jobTag、operationIdは内部識別子であり、個人情報は含まない

## 備考

- 本イベントはExecuteStatusの状態遷移において、Started/ReadyForExecution -> Finished の遷移を表す
- producedRowCountはOption[Long]であり、行を返さないオペレーション（DDLコマンド等）ではNoneとなる
- postFinishedはproducedRowsCountOptとextraTagsの2つの引数を受け取り、内部のproducedRowCountフィールドも更新する
- 本イベント後にpostClosedイベントが続く。Finished -> Closed が通常のフロー

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベントクラスの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 451-457行目: SparkListenerConnectOperationFinished case classの定義。producedRowCount: Option[Long]フィールドに注目 |

**読解のコツ**: producedRowCountはOption型であり、None（行を返さないオペレーション）とSome(N)（N行返却）の両方を表現する。

#### Step 2: エントリーポイントを理解する

postFinishedメソッドの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 220-236行目: postFinished()メソッド。assertStatusで遷移元ステータスを検証し、producedRowCountを設定後、イベントを生成してlistenerBusに送信 |

**主要処理フロー**:
1. **223-225行目**: assertStatus - StartedまたはReadyForExecutionからの遷移を許可
2. **226行目**: producedRowCount = producedRowsCountOpt - 内部フィールド設定
3. **228-235行目**: SparkListenerConnectOperationFinished生成とlistenerBus.post

#### Step 3: 実際の呼び出し箇所を理解する

SparkConnectPlanExecutionでの各呼び出しパスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkConnectPlanExecution.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/SparkConnectPlanExecution.scala` | 100行目: コマンド実行完了後のpostFinished()（行数なし） |
| 3-2 | SparkConnectPlanExecution.scala | 同上 | 210行目: LocalTableScanExec完了後のpostFinished(Some(rows.length)) |
| 3-3 | SparkConnectPlanExecution.scala | 同上 | 242行目: 全パーティション完了後のpostFinished(Some(totalNumRows)) |
| 3-4 | SparkConnectPlanExecution.scala | 同上 | 298行目: 空結果時のpostFinished(Some(0)) |

#### Step 4: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 249-261行目: onOperationFinishedメソッド。finishTimestampとstateをFINISHEDに更新 |

**主要処理フロー**:
- **253行目**: executionData.finishTimestamp = e.eventTime
- **254行目**: executionData.state = ExecutionState.FINISHED

### プログラム呼び出し階層図

```
SparkConnectPlanExecution (実行完了)
    |
    +-- executeHolder.eventsManager.postFinished(producedRowsCountOpt)
            |
            +-- assertStatus(List(Started, ReadyForExecution), Finished)
            |
            +-- producedRowCount = producedRowsCountOpt
            |
            +-- SparkListenerConnectOperationFinished 生成
            |       {jobTag, operationId, eventTime, producedRowCount, extraTags}
            |
            +-- LiveListenerBus.post(event)
                    |
                    +-- SparkConnectServerListener.onOtherEvent()
                            |
                            +-- onOperationFinished()
                                    |
                                    +-- finishTimestamp = eventTime
                                    +-- state = ExecutionState.FINISHED
```

### データフロー図

```
[入力]                          [処理]                              [出力]

実行完了                  -->  SparkConnectPlanExecution        -->  LiveListenerBus
 (rows/partitions完了)          .postFinished(rowCount)               (イベント配信)
                                   |
                                   v
                          SparkListenerConnect               -->  SparkConnectServerListener
                          OperationFinished                        (状態更新)
                           {jobTag, operationId,                    |
                            eventTime, producedRowCount,            v
                            extraTags}                       LiveExecutionData
                                                              .state = FINISHED
                                                              .finishTimestamp = eventTime
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | イベント受信・UI状態更新ロジック |
| SparkConnectPlanExecution.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/execution/SparkConnectPlanExecution.scala` | ソース | 実行計画の実行とpostFinished呼び出し |
| ExecuteEventsManagerSuite.scala | `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/service/ExecuteEventsManagerSuite.scala` | テスト | イベント発火の単体テスト |
