# 通知設計書 95-SparkListenerConnectOperationClosed

## 概要

本ドキュメントは、Apache SparkのSpark Connectモジュールにおける `SparkListenerConnectOperationClosed` イベント通知の設計を記述する。このイベントは、Connectリクエストの実行が完了し、結果がクライアントに送信された後に発火する内部イベントであり、オペレーションのライフサイクル最終イベントである。

### 本通知の処理概要

本通知は、Spark Connectサーバにおいてクライアントからのリクエストの処理が全て完了し、リソースのクリーンアップが行われる際に発火するイベントを定義する。Finished, Failed, Canceledのいずれかの状態から遷移し、オペレーションの終了を示す。

**業務上の目的・背景**：Spark Connectにおいて、オペレーションの完全なクローズを捕捉することは、リソース管理とUIの整合性維持に不可欠である。本通知は、オペレーションが完全に終了し、関連するリソース（キャッシュされたレスポンス等）が解放されたことをリスナーに通知する。UIではオペレーションがCLOSED状態として表示され、管理者はオペレーションの全ライフサイクルを追跡できる。

**通知の送信タイミング**：ExecuteHolder.close()メソッドの終了処理において、キャッシュされたレスポンスの削除後に発火する。ステータスがFinished, Failed, Canceledのいずれかからの遷移時に発火する。

**通知の受信者**：SparkConnectServerListenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。

**通知内容の概要**：jobTag、operationId、eventTime、extraTagsを含む。

**期待されるアクション**：受信したリスナーは、当該オペレーションの状態をCLOSEDに更新し、closeTimestampを記録する。executionListからエントリを削除し、KVStoreへの永続化を行う。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。SparkConnectServerListenerがonOtherEventメソッドでパターンマッチにより受信し、onOperationClosedメソッドで処理する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerConnectOperationClosed
フィールド:
  jobTag: {jobTag}
  operationId: {operationId}
  eventTime: {eventTime}
  extraTags: {extraTags}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobTag | Sparkジョブタグ（セッション・リクエスト間で一意） | ExecuteHolder.jobTag | Yes |
| operationId | 36文字のUUID | ExecuteHolder.operationId | Yes |
| eventTime | イベント発生時刻（ミリ秒） | Clock.getTimeMillis() | Yes |
| extraTags | 追加メタデータ | デフォルト: Map.empty | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | ExecuteHolder.close() | レスポンスキャッシュ削除後 | ExecuteHolder.scalaの310行目付近 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスが許可リスト外 | assertStatusにより、直前のステータスがFinished, Failed, Canceledのいずれでもない場合はIllegalStateExceptionがスローされる |
| セッションがStartedでない | セッションのステータスがStartedでない場合はIllegalStateExceptionがスローされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[オペレーション完了/失敗/キャンセル] --> B[ExecuteHolder.close]
    B --> C[responseObserver.removeAll - キャッシュ削除]
    C --> D[ExecuteEventsManager.postClosed]
    D --> E{assertStatus: Finished/Failed/Canceled?}
    E -->|Yes| F[SparkListenerConnectOperationClosed生成]
    E -->|No| G[IllegalStateException]
    F --> H[LiveListenerBus.post]
    H --> I[SparkConnectServerListener.onOperationClosed]
    I --> J[closeTimestamp設定 / state = CLOSED]
    J --> K[updateStoreWithTriggerEnabled - KVStore永続化]
    K --> L[executionListからエントリ削除 - null返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | オペレーションの実行データ管理 | インメモリ。jobTagをキーとする |

### テーブル別参照項目詳細

#### executionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveExecutionData | 実行中オペレーションの状態管理 | jobTagで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | ExecutionInfoのstate, closeTimestampを更新 |
| executionList (ConcurrentHashMap) | DELETE | エントリを削除（nullを返すことで実現） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | state | ExecutionState.CLOSED | LiveExecutionDataのstateフィールドを更新 |
| UPDATE | closeTimestamp | eventTime | クローズ時刻を記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IllegalStateException | 現在のステータスがFinished, Failed, Canceledのいずれでもない場合 | 例外がスローされ、呼び出し元で処理される |
| IllegalStateException | セッションステータスがStartedでない場合 | 例外がスローされ、呼び出し元で処理される |
| 不明なオペレーション | executionListにjobTagが存在しない場合 | ログ警告を出力し、処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（イベントバスのキャパシティに依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。Spark Connectサーバが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- 本イベントはSpark JVMプロセス内部のイベントバスで配信されるため、外部ネットワークへの露出はない
- jobTag、operationIdは内部識別子であり、個人情報は含まない
- クローズ処理ではキャッシュされたレスポンスが削除されるため、データの適切なクリーンアップが行われる

## 備考

- 本イベントはExecuteStatusの状態遷移における最終状態であり、Finished/Failed/Canceled -> Closed の遷移を表す
- リスナー側ではexecutionList.computeメソッドを使用し、atomicにエントリの更新と削除を行う（nullを返すことでConcurrentHashMapからエントリを削除）
- updateStoreWithTriggerEnabledが使用されるため、KVStoreへの書き込みとクリーンアップトリガーが同時に実行される
- 本イベントの後にはオペレーションに関するイベントは発火しない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベントクラスの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 472-477行目: SparkListenerConnectOperationClosed case classの定義。最終状態イベントとして最もシンプルなフィールド構成 |

**読解のコツ**: Closedは状態遷移の最終地点であり、Finished/Failed/Canceledからのみ遷移可能。

#### Step 2: エントリーポイントを理解する

postClosedメソッドの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | 241-247行目: postClosed()メソッド。assertStatusでFinished/Failed/Canceledからの遷移を検証 |

**主要処理フロー**:
1. **242-243行目**: assertStatus - Finished, Failed, Canceledからの遷移を許可
2. **245-246行目**: SparkListenerConnectOperationClosed生成とlistenerBus.post

#### Step 3: 呼び出し元を理解する

ExecuteHolderのclose処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExecuteHolder.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteHolder.scala` | 308-311行目: close()メソッド内でresponseObserver.removeAll()後にeventsManager.postClosed()を呼び出す |

**主要処理フロー**:
- **308行目**: responseObserver.removeAll() - キャッシュ削除
- **310行目**: eventsManager.postClosed() - クローズイベント発火

#### Step 4: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | 262-278行目: onOperationClosedメソッド。executionList.computeを使用し、atomicに状態更新とエントリ削除を実行 |

**主要処理フロー**:
- **267-268行目**: updateStoreWithTriggerEnabled - closeTimestamp設定、state = CLOSED
- **276行目**: null返却 - ConcurrentHashMapからエントリ削除

### プログラム呼び出し階層図

```
ExecuteHolder.close()
    |
    +-- responseObserver.removeAll() -- キャッシュ削除
    |
    +-- eventsManager.postClosed()
            |
            +-- assertStatus(List(Finished, Failed, Canceled), Closed)
            |
            +-- SparkListenerConnectOperationClosed 生成
            |
            +-- LiveListenerBus.post(event)
                    |
                    +-- SparkConnectServerListener.onOtherEvent()
                            |
                            +-- onOperationClosed()
                                    |
                                    +-- executionList.compute(jobTag, ...)
                                            |
                                            +-- updateStoreWithTriggerEnabled
                                            |       closeTimestamp = eventTime
                                            |       state = CLOSED
                                            |
                                            +-- return null (エントリ削除)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ExecuteHolder.close()    -->  ExecuteEventsManager              -->  LiveListenerBus
 (リソースクリーンアップ)         .postClosed()                        (イベント配信)
                                   |
                                   v
                          SparkListenerConnect               -->  SparkConnectServerListener
                          OperationClosed                          (状態更新・エントリ削除)
                           {jobTag, operationId,                    |
                            eventTime, extraTags}                   v
                                                            executionList.compute
                                                             -> CLOSED + null返却
                                                                    |
                                                                    v
                                                            ElementTrackingStore
                                                             (KVStore永続化 + トリガー)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecuteEventsManager.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| SparkConnectServerListener.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` | ソース | イベント受信・UI状態更新ロジック |
| ExecuteHolder.scala | `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteHolder.scala` | ソース | close処理とpostClosed呼び出し |
| ExecuteEventsManagerSuite.scala | `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/service/ExecuteEventsManagerSuite.scala` | テスト | イベント発火の単体テスト |
