# 通知設計書 96-SparkListenerThriftServerSessionCreated

## 概要

本ドキュメントは、Apache SparkのHive ThriftServer2モジュールにおける `SparkListenerThriftServerSessionCreated` イベント通知の設計を記述する。このイベントは、ThriftServerにクライアントが接続しセッションが作成された際に発火する内部イベントである。

### 本通知の処理概要

本通知は、Hive ThriftServer2にクライアントが接続し、新しいセッションが確立された際に発火するイベントを定義する。JDBCやODBC経由での接続時にトリガーされる。

**業務上の目的・背景**：Hive ThriftServer2は、SparkのSQLエンジンにJDBC/ODBCインタフェースを提供するサービスである。クライアント接続の追跡は、セキュリティ監査、リソース管理、同時接続数の監視に不可欠である。本通知により、管理者はThriftServer UIでどのIPアドレスからどのユーザが接続しているかをリアルタイムに把握できる。

**通知の送信タイミング**：SparkSQLSessionManager.openSession()メソッド内で、Hiveセッションの作成が完了した直後に発火する。HiveThriftServer2EventManager.onSessionCreated()が呼び出され、System.currentTimeMillis()が開始時刻として記録される。

**通知の受信者**：HiveThriftServer2Listenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。ThriftServer UIの状態表示を更新する。

**通知内容の概要**：ip（クライアントIPアドレス）、sessionId（セッションID）、userName（ユーザ名、デフォルト"UNKNOWN"）、startTime（セッション開始時刻）を含む。

**期待されるアクション**：受信したリスナーは、新しいセッション情報をsessionListに登録し、KVStoreに永続化する。UI上で新しいセッションが表示される。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。HiveThriftServer2ListenerがonOtherEventメソッドでパターンマッチにより受信し、onSessionCreatedメソッドで処理する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerThriftServerSessionCreated
フィールド:
  ip: {ip}
  sessionId: {sessionId}
  userName: {userName}
  startTime: {startTime}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ip | クライアントIPアドレス | HiveSession.getIpAddress | Yes |
| sessionId | セッションID（文字列） | SessionHandle.getSessionId.toString | Yes |
| userName | 接続ユーザ名 | HiveSession.getUsername / デフォルト"UNKNOWN" | Yes |
| startTime | セッション開始時刻（ミリ秒） | System.currentTimeMillis() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | SparkSQLSessionManager.openSession() | super.openSession()成功後 | JDBC/ODBC接続時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| openSession失敗 | super.openSession()が例外をスローした場合はイベントは発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[JDBC/ODBCクライアント接続] --> B[SparkSQLSessionManager.openSession]
    B --> C[super.openSession - Hiveセッション作成]
    C --> D[HiveThriftServer2.eventManager.onSessionCreated]
    D --> E[SparkListenerThriftServerSessionCreated生成]
    E --> F[LiveListenerBus.post]
    F --> G[HiveThriftServer2Listener.onSessionCreated]
    G --> H[getOrCreateSession - LiveSessionData作成]
    H --> I[sessionList.put]
    I --> J[updateLiveStore - KVStore更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| sessionList (ConcurrentHashMap) | セッションデータ管理 | インメモリ。sessionIdをキーとする |

### テーブル別参照項目詳細

#### sessionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveSessionData | セッションの状態管理 | sessionIdで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sessionList (ConcurrentHashMap) | INSERT | 新しいLiveSessionDataを登録 |
| ElementTrackingStore (KVStore) | INSERT | SessionInfoを永続化 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | sessionId | e.sessionId | セッション識別子 |
| INSERT | startTimeStamp | e.startTime | セッション開始時刻 |
| INSERT | ip | e.ip | クライアントIPアドレス |
| INSERT | username | e.userName | 接続ユーザ名 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| openSession失敗 | 認証失敗やリソース不足等 | HiveThriftServerErrors.failedToOpenNewSessionErrorがスローされ、イベントは発火しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（イベントバスのキャパシティに依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ThriftServerが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- private[thriftserver]スコープで定義されており、thriftserverパッケージ外からは直接アクセスできない
- IPアドレスやユーザ名が含まれるため、ログ出力時のプライバシー考慮が必要
- 本イベントはSpark JVMプロセス内部のイベントバスで配信されるため、外部ネットワークへの露出はない

## 備考

- userName引数のデフォルト値は"UNKNOWN"であるが、SparkSQLSessionManagerではhiveSession.getUsername()が渡される
- セッション数の上限はSQLConf.THRIFTSERVER_UI_SESSION_LIMITで設定される
- 上限を超えた場合、cleanupSessionメソッドにより古いセッション情報が削除される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベントクラスの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 79-83行目: SparkListenerThriftServerSessionCreated case classの定義。ip, sessionId, userName, startTimeフィールド |

**読解のコツ**: private[thriftserver]スコープで定義されているため、thriftserverパッケージ内からのみアクセス可能。

#### Step 2: エントリーポイントを理解する

イベント発火元であるEventManagerを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 32-35行目: onSessionCreated()メソッド。SparkListenerThriftServerSessionCreatedを生成し、postLiveListenerBus経由でLiveListenerBusに送信 |

**主要処理フロー**:
1. **28-29行目**: postLiveListenerBus - sc.listenerBus.postのラッパー
2. **32-34行目**: onSessionCreated - イベント生成と送信

#### Step 3: 呼び出し元を理解する

SparkSQLSessionManagerからの呼び出しパスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkSQLSessionManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkSQLSessionManager.scala` | 54-60行目: openSession()メソッド。super.openSession()で作成したHiveセッションからIPアドレス、セッションID、ユーザ名を取得してonSessionCreatedを呼び出す |

**主要処理フロー**:
- **59行目**: HiveThriftServer2.eventManager.onSessionCreated(hiveSession.getIpAddress, sessionHandle.getSessionId.toString, hiveSession.getUsername)

#### Step 4: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | 117-130行目: onOtherEventでパターンマッチ。132-136行目: onSessionCreatedでsessionListへ登録とupdateLiveStore |

**主要処理フロー**:
- **133行目**: getOrCreateSession - LiveSessionData作成
- **134行目**: sessionList.put - インメモリ管理
- **135行目**: updateLiveStore - KVStore更新

### プログラム呼び出し階層図

```
JDBC/ODBCクライアント接続
    |
    +-- SparkSQLSessionManager.openSession()
            |
            +-- super.openSession() -- Hiveセッション作成
            |
            +-- HiveThriftServer2.eventManager.onSessionCreated(ip, sessionId, userName)
                    |
                    +-- postLiveListenerBus(SparkListenerThriftServerSessionCreated(...))
                            |
                            +-- sc.listenerBus.post(event)
                                    |
                                    +-- HiveThriftServer2Listener.onOtherEvent()
                                            |
                                            +-- onSessionCreated()
                                                    |
                                                    +-- getOrCreateSession()
                                                    +-- sessionList.put()
                                                    +-- updateLiveStore()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

JDBC/ODBC接続             -->  SparkSQLSessionManager           -->  LiveListenerBus
 (クライアント認証)               .openSession()                       (イベント配信)
                                   |
                                   v
                          HiveThriftServer2EventManager       -->  HiveThriftServer2Listener
                           .onSessionCreated()                      (状態登録)
                                   |                                    |
                                   v                                    v
                          SparkListenerThriftServer           LiveSessionData
                          SessionCreated                       {sessionId, startTimeStamp,
                           {ip, sessionId,                      ip, username}
                            userName, startTime}                     |
                                                                    v
                                                            ElementTrackingStore
                                                             (SessionInfo永続化)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | ソース | イベント受信・UI状態更新ロジック |
| SparkSQLSessionManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkSQLSessionManager.scala` | ソース | セッション作成とイベント発火の起点 |
| HiveThriftServer2ListenerSuite.scala | `sql/hive-thriftserver/src/test/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2ListenerSuite.scala` | テスト | リスナーの単体テスト |
