# 通知設計書 97-SparkListenerThriftServerSessionClosed

## 概要

本ドキュメントは、Apache SparkのHive ThriftServer2モジュールにおける `SparkListenerThriftServerSessionClosed` イベント通知の設計を記述する。このイベントは、ThriftServerセッションが閉じられた際に発火する内部イベントである。

### 本通知の処理概要

本通知は、Hive ThriftServer2からクライアントが切断し、セッションが閉じられた際に発火するイベントを定義する。

**業務上の目的・背景**：セッションのクローズを追跡することは、リソースの解放確認やセッションの利用時間計測に重要である。本通知により、管理者はThriftServer UIでセッションの開始から終了までのライフサイクルを完全に追跡でき、異常なセッション長期滞留の検知にも活用できる。

**通知の送信タイミング**：SparkSQLSessionManager.closeSession()メソッドの先頭で発火する。セッションに関連するリソース（テンポラリビュー等）のクリーンアップ前に呼び出される。

**通知の受信者**：HiveThriftServer2Listenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。

**通知内容の概要**：sessionId（セッションID）、finishTime（セッション終了時刻）を含む。

**期待されるアクション**：受信したリスナーは、当該セッションのfinishTimestampを設定し、sessionListからエントリを削除する。UI上でセッションの終了が反映される。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。HiveThriftServer2ListenerがonOtherEventメソッドでパターンマッチにより受信する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerThriftServerSessionClosed
フィールド:
  sessionId: {sessionId}
  finishTime: {finishTime}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| sessionId | セッションID（文字列） | SessionHandle.getSessionId.toString | Yes |
| finishTime | セッション終了時刻（ミリ秒） | System.currentTimeMillis() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | SparkSQLSessionManager.closeSession() | 常に発火 | クライアント切断またはセッション終了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 特になし | closeSession呼び出し時に常に発火する |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[クライアント切断/セッション終了] --> B[SparkSQLSessionManager.closeSession]
    B --> C[HiveThriftServer2.eventManager.onSessionClosed]
    C --> D[SparkListenerThriftServerSessionClosed生成]
    D --> E[LiveListenerBus.post]
    E --> F[HiveThriftServer2Listener.onSessionClosed]
    F --> G{sessionListにsessionId存在?}
    G -->|Yes| H[finishTimestamp設定]
    G -->|No| I[ログ警告出力]
    H --> J[updateStoreWithTriggerEnabled - KVStore永続化]
    J --> K[sessionList.remove - エントリ削除]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| sessionList (ConcurrentHashMap) | セッションデータ管理 | インメモリ。sessionIdをキーとする |

### テーブル別参照項目詳細

#### sessionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveSessionData | セッションの状態管理 | sessionIdで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | SessionInfoのfinishTimestampを更新 |
| sessionList (ConcurrentHashMap) | DELETE | エントリを削除 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | finishTimestamp | e.finishTime | セッション終了時刻 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不明なセッション | sessionListにsessionIdが存在しない場合 | ログ警告を出力し、処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ThriftServerが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- private[thriftserver]スコープで定義されており、thriftserverパッケージ外からは直接アクセスできない
- sessionIdのみを含み、IPアドレスやユーザ名は含まない
- 本イベントはSpark JVMプロセス内部のイベントバスで配信される

## 備考

- closeSession()ではイベント発火後にテンポラリビューのキャッシュ解除（uncacheTable）やsuper.closeSession()が実行される
- sessionListからの削除により、以降のイベントはsessionIdで関連付けできなくなる
- updateStoreWithTriggerEnabledが使用されるため、KVStoreへの書き込みとクリーンアップトリガーが同時に実行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 85-86行目: SparkListenerThriftServerSessionClosed case classの定義。sessionId, finishTimeフィールド |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 37-39行目: onSessionClosed()メソッド |

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkSQLSessionManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkSQLSessionManager.scala` | 87-88行目: closeSession()メソッドの先頭でonSessionClosedを呼び出す |

**主要処理フロー**:
- **88行目**: HiveThriftServer2.eventManager.onSessionClosed(sessionHandle.getSessionId.toString)

#### Step 4: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | 138-147行目: onSessionClosedメソッド。finishTimestamp設定、updateStoreWithTriggerEnabled、sessionList.remove |

### プログラム呼び出し階層図

```
クライアント切断/セッション終了
    |
    +-- SparkSQLSessionManager.closeSession()
            |
            +-- HiveThriftServer2.eventManager.onSessionClosed(sessionId)
            |       |
            |       +-- postLiveListenerBus(SparkListenerThriftServerSessionClosed(...))
            |               |
            |               +-- HiveThriftServer2Listener.onSessionClosed()
            |                       |
            |                       +-- sessionData.finishTimestamp = finishTime
            |                       +-- updateStoreWithTriggerEnabled()
            |                       +-- sessionList.remove(sessionId)
            |
            +-- テンポラリビューのuncacheTable
            +-- super.closeSession()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

closeSession()           -->  HiveThriftServer2EventManager    -->  LiveListenerBus
 (セッション終了要求)            .onSessionClosed()                   (イベント配信)
                                   |
                                   v
                          SparkListenerThriftServer           -->  HiveThriftServer2Listener
                          SessionClosed                            (状態更新・エントリ削除)
                           {sessionId, finishTime}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | ソース | イベント受信・UI状態更新ロジック |
| SparkSQLSessionManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkSQLSessionManager.scala` | ソース | セッション終了とイベント発火の起点 |
| HiveThriftServer2ListenerSuite.scala | `sql/hive-thriftserver/src/test/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2ListenerSuite.scala` | テスト | リスナーの単体テスト |
