# 通知設計書 98-SparkListenerThriftServerOperationStart

## 概要

本ドキュメントは、Apache SparkのHive ThriftServer2モジュールにおける `SparkListenerThriftServerOperationStart` イベント通知の設計を記述する。このイベントは、ThriftServerオペレーション（SQL文の実行）が開始された際に発火する内部イベントである。

### 本通知の処理概要

本通知は、Hive ThriftServer2でJDBC/ODBCクライアントからSQL文が送信され、オペレーションの実行が開始された際に発火するイベントを定義する。

**業務上の目的・背景**：ThriftServerにおけるSQL文の実行追跡は、パフォーマンス分析、スロークエリの検出、同時実行数の監視に不可欠である。本通知により、管理者はThriftServer UIでどのセッションからどのSQL文が実行されているかをリアルタイムに把握でき、実行中のオペレーション一覧の表示に活用される。

**通知の送信タイミング**：SparkExecuteStatementOperation等のオペレーションクラスの実行開始時にHiveThriftServer2EventManager.onStatementStart()が呼び出され発火する。System.currentTimeMillis()が開始時刻として記録される。

**通知の受信者**：HiveThriftServer2Listenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。

**通知内容の概要**：id（オペレーションID）、sessionId（セッションID）、statement（SQL文）、groupId（Sparkジョブグループ）、startTime（開始時刻）、userName（ユーザ名、デフォルト"UNKNOWN"）を含む。

**期待されるアクション**：受信したリスナーは、新しいオペレーション情報をexecutionListに登録し、関連セッションのtotalExecutionを増加させ、KVStoreに永続化する。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。HiveThriftServer2ListenerがonOtherEventメソッドでパターンマッチにより受信する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerThriftServerOperationStart
フィールド:
  id: {id}
  sessionId: {sessionId}
  statement: {statement}
  groupId: {groupId}
  startTime: {startTime}
  userName: {userName}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| id | オペレーションID | statementId | Yes |
| sessionId | セッションID | セッションハンドル | Yes |
| statement | 実行SQL文 | クライアントから送信されたSQL | Yes |
| groupId | Sparkジョブグループ | SparkContext.SPARK_JOB_GROUP_ID | Yes |
| startTime | オペレーション開始時刻（ミリ秒） | System.currentTimeMillis() | Yes |
| userName | 実行ユーザ名 | デフォルト"UNKNOWN" | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | SparkExecuteStatementOperation等の実行開始 | SQL文の実行開始時 | JDBC/ODBCクライアントからのSQL実行要求 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 特になし | オペレーション開始時に常に発火する |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[JDBC/ODBCクライアントからSQL実行要求] --> B[SparkExecuteStatementOperation実行開始]
    B --> C[HiveThriftServer2.eventManager.onStatementStart]
    C --> D[SparkListenerThriftServerOperationStart生成]
    D --> E[LiveListenerBus.post]
    E --> F[HiveThriftServer2Listener.onOperationStart]
    F --> G[getOrCreateExecution - LiveExecutionData作成]
    G --> H[state = STARTED / executionList.put]
    H --> I[groupId設定]
    I --> J[sessionListのtotalExecution増加]
    J --> K[updateLiveStore - KVStore更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | オペレーション実行データ管理 | インメモリ。execIdをキーとする |
| sessionList (ConcurrentHashMap) | セッションデータ管理 | totalExecution更新のため参照 |

### テーブル別参照項目詳細

#### sessionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveSessionData | セッションのtotalExecution更新 | sessionIdで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | INSERT | 新しいLiveExecutionDataを登録 |
| ElementTrackingStore (KVStore) | INSERT | ExecutionInfoを永続化 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | execId | e.id | オペレーション識別子 |
| INSERT | statement | e.statement | 実行SQL文 |
| INSERT | sessionId | e.sessionId | セッション識別子 |
| INSERT | startTimestamp | e.startTime | オペレーション開始時刻 |
| INSERT | userName | e.userName | 実行ユーザ名 |
| UPDATE | groupId | e.groupId | Sparkジョブグループ |
| UPDATE | state | ExecutionState.STARTED | 初期状態 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不明なセッション | sessionListにsessionIdが存在しない場合 | ログ警告を出力するが、オペレーション自体は登録される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（イベントバスのキャパシティに依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ThriftServerが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- private[thriftserver]スコープで定義されており、thriftserverパッケージ外からは直接アクセスできない
- SQL文（statement）が含まれるため、機密データを含むクエリのログ出力時にはマスキングが推奨される
- userName、sessionIdが含まれるため、プライバシー考慮が必要

## 備考

- userName引数のデフォルト値は"UNKNOWN"
- groupIdはSparkContext.SPARK_JOB_GROUP_IDに対応し、onJobStartイベントとの関連付けに使用される
- オペレーション数の上限はSQLConf.THRIFTSERVER_UI_STATEMENT_LIMITで設定される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 88-94行目: SparkListenerThriftServerOperationStart case classの定義。id, sessionId, statement, groupId, startTime, userNameフィールド |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 42-49行目: onStatementStart()メソッド。5つの引数を受け取り、SparkListenerThriftServerOperationStartを生成 |

**主要処理フロー**:
1. **48-49行目**: SparkListenerThriftServerOperationStart生成とpostLiveListenerBus

#### Step 3: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | 149-170行目: onOperationStartメソッド。LiveExecutionData作成、state設定、executionList.put、groupId設定、sessionのtotalExecution更新 |

**主要処理フロー**:
- **150-155行目**: getOrCreateExecution - LiveExecutionData作成
- **157行目**: executionData.state = ExecutionState.STARTED
- **158行目**: executionList.put(e.id, executionData)
- **159行目**: executionData.groupId = e.groupId
- **164行目**: sessionData.totalExecution += 1

### プログラム呼び出し階層図

```
JDBC/ODBCクライアント SQL実行要求
    |
    +-- SparkExecuteStatementOperation等
            |
            +-- HiveThriftServer2.eventManager.onStatementStart(id, sessionId, statement, groupId, userName)
                    |
                    +-- postLiveListenerBus(SparkListenerThriftServerOperationStart(...))
                            |
                            +-- HiveThriftServer2Listener.onOperationStart()
                                    |
                                    +-- getOrCreateExecution()
                                    +-- state = STARTED
                                    +-- executionList.put()
                                    +-- groupId設定
                                    +-- sessionData.totalExecution += 1
```

### データフロー図

```
[入力]                          [処理]                              [出力]

SQL実行要求               -->  HiveThriftServer2EventManager    -->  LiveListenerBus
 (JDBC/ODBCクライアント)         .onStatementStart()                  (イベント配信)
                                   |
                                   v
                          SparkListenerThriftServer           -->  HiveThriftServer2Listener
                          OperationStart                           (状態登録)
                           {id, sessionId, statement,               |
                            groupId, startTime, userName}           v
                                                            LiveExecutionData + LiveSessionData
                                                             (executionList + sessionList更新)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | ソース | イベント受信・UI状態更新ロジック |
| SparkExecuteStatementOperation.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` | ソース | SQL実行オペレーションの実装 |
| HiveThriftServer2ListenerSuite.scala | `sql/hive-thriftserver/src/test/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2ListenerSuite.scala` | テスト | リスナーの単体テスト |
