# 通知設計書 99-SparkListenerThriftServerOperationParsed

## 概要

本ドキュメントは、Apache SparkのHive ThriftServer2モジュールにおける `SparkListenerThriftServerOperationParsed` イベント通知の設計を記述する。このイベントは、ThriftServerオペレーションのSQL文の解析が完了した際に発火する内部イベントである。

### 本通知の処理概要

本通知は、Hive ThriftServer2で実行中のSQL文のパース・コンパイルが完了し、実行計画が生成された際に発火するイベントを定義する。

**業務上の目的・背景**：SQL文の解析完了は、オペレーションのライフサイクルにおける重要なマイルストーンである。本通知により、管理者はThriftServer UIで各オペレーションの実行計画を確認でき、パフォーマンス分析やクエリの最適化検討に活用できる。解析が完了したことで、オペレーションの状態がSTARTEDからCOMPILEDに遷移する。

**通知の送信タイミング**：SparkExecuteStatementOperation等のオペレーションクラスにおいて、SQL文のパース・コンパイルが完了した後にHiveThriftServer2EventManager.onStatementParsed()が呼び出され発火する。

**通知の受信者**：HiveThriftServer2Listenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。

**通知内容の概要**：id（オペレーションID）、executionPlan（実行計画の文字列表現）を含む。

**期待されるアクション**：受信したリスナーは、当該オペレーションのexecutePlanフィールドに実行計画を設定し、stateをCOMPILEDに更新する。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 低 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。HiveThriftServer2ListenerがonOtherEventメソッドでパターンマッチにより受信する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerThriftServerOperationParsed
フィールド:
  id: {id}
  executionPlan: {executionPlan}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| id | オペレーションID | statementId | Yes |
| executionPlan | 実行計画の文字列表現 | QueryExecution.toString等 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | SQL文のパース・コンパイル完了 | 実行計画の生成成功 | SparkExecuteStatementOperation等から呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| パース失敗 | SQL文のパースが失敗した場合は本イベントは発火せず、エラーイベントが発火する |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SQL文受信] --> B[パース・コンパイル処理]
    B -->|成功| C[HiveThriftServer2.eventManager.onStatementParsed]
    B -->|失敗| D[エラーイベント発火]
    C --> E[SparkListenerThriftServerOperationParsed生成]
    E --> F[LiveListenerBus.post]
    F --> G[HiveThriftServer2Listener.onOperationParsed]
    G --> H{executionListにid存在?}
    H -->|Yes| I[executePlan設定 / state = COMPILED]
    H -->|No| J[ログ警告出力]
    I --> K[updateLiveStore - KVStore更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | オペレーション実行データ管理 | インメモリ。execIdをキーとする |

### テーブル別参照項目詳細

#### executionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveExecutionData | オペレーションの状態管理 | idで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | ExecutionInfoのexecutePlan, stateを更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | executePlan | e.executionPlan | 実行計画の文字列表現 |
| UPDATE | state | ExecutionState.COMPILED | コンパイル完了状態 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不明なオペレーション | executionListにidが存在しない場合 | ログ警告を出力し、処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ThriftServerが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- private[thriftserver]スコープで定義されており、thriftserverパッケージ外からは直接アクセスできない
- executionPlanにはクエリの物理実行計画が含まれるため、テーブル名やカラム名等のスキーマ情報が露出する可能性がある
- 本イベントはSpark JVMプロセス内部のイベントバスで配信される

## 備考

- 本イベントにはfinishTimeフィールドは含まれない（他のThriftServerオペレーションイベントとは異なる）
- 実行計画の文字列表現のサイズに制限はないが、大規模なクエリの場合は長大な文字列になる可能性がある
- 状態遷移としてはSTARTED -> COMPILEDを表す

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 96-98行目: SparkListenerThriftServerOperationParsed case classの定義。id, executionPlanフィールドのみ（finishTimeなし） |

**読解のコツ**: 他のThriftServerオペレーションイベント（Canceled, Timeout等）にはfinishTimeが含まれるが、ParsedイベントにはidとexecutionPlanのみ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 52-53行目: onStatementParsed()メソッド。id, executionPlanの2引数のみ |

#### Step 3: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | 172-181行目: onOperationParsedメソッド。executePlanとstateをCOMPILEDに更新 |

**主要処理フロー**:
- **175行目**: executionData.executePlan = e.executionPlan
- **176行目**: executionData.state = ExecutionState.COMPILED

### プログラム呼び出し階層図

```
SQL文パース・コンパイル完了
    |
    +-- HiveThriftServer2.eventManager.onStatementParsed(id, executionPlan)
            |
            +-- postLiveListenerBus(SparkListenerThriftServerOperationParsed(...))
                    |
                    +-- HiveThriftServer2Listener.onOperationParsed()
                            |
                            +-- executionData.executePlan = executionPlan
                            +-- executionData.state = COMPILED
                            +-- updateLiveStore()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

SQL文パース完了            -->  HiveThriftServer2EventManager    -->  LiveListenerBus
 (実行計画生成)                  .onStatementParsed()                 (イベント配信)
                                   |
                                   v
                          SparkListenerThriftServer           -->  HiveThriftServer2Listener
                          OperationParsed                          (状態更新)
                           {id, executionPlan}                      |
                                                                    v
                                                            LiveExecutionData
                                                             .executePlan = executionPlan
                                                             .state = COMPILED
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | ソース | イベント受信・UI状態更新ロジック |
| SparkExecuteStatementOperation.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` | ソース | SQL実行オペレーション（onStatementParsed呼び出し元） |
| HiveThriftServer2ListenerSuite.scala | `sql/hive-thriftserver/src/test/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2ListenerSuite.scala` | テスト | リスナーの単体テスト |
