---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-SparkListenerStageSubmitted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18 セキュリティ考慮事項のProperties秘匿化**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L33-34（SparkListenerStageSubmittedケースクラス定義）
- E-02: `common/utils/src/main/scala/org/apache/spark/scheduler/SparkListenerEvent.scala` L23-28（SparkListenerEventトレイト定義）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L1688-1689（submitMissingTasks通常パス）
- E-04: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L1673-1674（submitMissingTasks例外パス）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` L46, L126-160（LiveListenerBus定義、post/postToQueuesメソッド）
- E-06: `core/src/main/scala/org/apache/spark/scheduler/AsyncEventQueue.scala` L38-61（AsyncEventQueue定義、キュー容量）
- E-07: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` L32-33（doPostEventのStageSubmittedパターンマッチ）
- E-08: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L304-314（SparkListenerInterface定義）
- E-09: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L506-509（SparkListenerデフォルト実装）
- E-10: `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` L250-261（キュー名定数定義：SHARED, APP_STATUS, EXECUTOR_MANAGEMENT, EVENT_LOG）
- E-11: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L973-976（submitJob空パーティション時のpost）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerStageSubmittedはcase classでstageInfoとpropertiesの2フィールドを持つ | E-01 | ○ |
| C-02 | SparkListenerEventトレイトを継承している | E-01, E-02 | ○ |
| C-03 | @JsonTypeInfoアノテーションによりJacksonでのポリモーフィックシリアライズに対応 | E-02 | ○ |
| C-04 | logEventプロパティはデフォルトtrue | E-02 | ○ |
| C-05 | propertiesパラメータのデフォルト値はnull | E-01 | ○ |
| C-06 | submitMissingTasks通常パス（L1688）でイベントが発火される | E-03 | ○ |
| C-07 | submitMissingTasks例外パス（L1673）でもイベントが発火される | E-04 | ○ |
| C-08 | 空パーティションのジョブ送信時にも発火される | E-11 | ○ |
| C-09 | LiveListenerBusは非同期でイベントを配信する | E-05 | ○ |
| C-10 | AsyncEventQueueはLinkedBlockingQueueでイベントをバッファリングする | E-06 | ○ |
| C-11 | キュー容量のデフォルトは設定可能（spark.scheduler.listenerbus.eventqueue.capacity） | E-06 | ○ |
| C-12 | SparkListenerBus.doPostEventでパターンマッチによりonStageSubmittedが呼ばれる | E-07 | ○ |
| C-13 | SparkListenerInterfaceにonStageSubmittedメソッドが定義されている | E-08 | ○ |
| C-14 | SparkListenerクラスはデフォルトno-op実装を提供する | E-09 | ○ |
| C-15 | キューは4種類（shared, appStatus, executorManagement, eventLog） | E-10 | ○ |
| C-16 | stopped.get()がtrueの場合postは即座にreturnする | E-05 | ○ |
| C-17 | Utils.clonePropertiesでプロパティがクローンされる | E-03 | ○ |
| C-18 | StageSubmittedのPropertiesは秘匿化されない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: Properties の秘匿化に関する正確な動作確認が不足。EventLoggingListenerのredact処理がSparkListenerEnvironmentUpdateにのみ適用されることはListenerBus.scalaのredactEventメソッド（L158-162）から推測可能だが、StageSubmittedのPropertiesに対する明示的な秘匿化コードが存在しないことの確認が必要。
  - 候補：`core/src/main/scala/org/apache/spark/util/ListenerBus.scala` / `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント定義とデータ構造は正確にソースコードと一致
- 0: 低リスク - 発火トリガーの記載はDAGScheduler.scalaの実装と一致
- 1: 中リスク - セキュリティ考慮事項のProperties秘匿化の記述は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerStageSubmittedのフィールド定義がソースコードと一致しているか
- [ ] DAGSchedulerの発火箇所（L1673, L1688）が最新コードと一致しているか
- [ ] LiveListenerBusの配信フローの記述が正確か
- [ ] Propertiesの秘匿化に関する記述が正確か（EventLoggingListener等を確認）
