---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-SparkListenerBlockManagerAdded

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L103-109（SparkListenerBlockManagerAddedケースクラス定義）
- E-02: `core/src/main/scala/org/apache/spark/storage/BlockManagerMasterEndpoint.scala` L737-744（register内のpost）
- E-03: `core/src/main/scala/org/apache/spark/storage/BlockManagerMasterEndpoint.scala` L746-758（再登録シナリオ処理）
- E-04: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` L48-49（doPostEventのBlockManagerAddedパターンマッチ）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L349-350（onBlockManagerAdded定義）
- E-06: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L523（デフォルト実装）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerBlockManagerAddedは5フィールドのケースクラス | E-01 | ○ |
| C-02 | maxOnHeapMemとmaxOffHeapMemはOption[Long]型でデフォルトNone | E-01 | ○ |
| C-03 | BlockManagerMasterEndpoint.register（L743-744）でイベントが発火 | E-02 | ○ |
| C-04 | maxMemはmaxOnHeapMemSize + maxOffHeapMemSizeの合計値 | E-02 | ○ |
| C-05 | Some(maxOnHeapMemSize)とSome(maxOffHeapMemSize)が明示的に渡される | E-02 | ○ |
| C-06 | blockManagerInfoマップへの登録後にイベントが発火 | E-02 | ○ |
| C-07 | pushBasedShuffleが有効な場合addMergerLocationが呼ばれる | E-02 | ○ |
| C-08 | 再登録失敗時にexecutorIdが"invalid"に設定される | E-03 | ○ |
| C-09 | SparkListenerBusでパターンマッチによりonBlockManagerAddedが呼ばれる | E-04 | ○ |
| C-10 | SparkListenerInterfaceにonBlockManagerAddedが定義されている | E-05 | ○ |
| C-11 | SparkListenerのデフォルト実装はno-op | E-06 | ○ |
| C-12 | SparkListenerEventを継承している | E-01 | ○ |
| C-13 | @DeveloperApiアノテーションが付与されている | E-01 | ○ |
| C-14 | timeフィールドはBlockManagerMasterEndpoint内のSystem.currentTimeMillis()相当の値 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードの根拠と一致

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerBlockManagerAddedの5フィールド定義がソースコードと一致しているか
- [ ] BlockManagerMasterEndpoint.registerの行番号が最新コードと一致しているか
- [ ] maxMemの計算式（onHeap + offHeap）が正確か
- [ ] Option型フィールドのデフォルト値とpost時の値が正確に記述されているか
