---
generated_at: 2026-02-04 10:09:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-SparkListenerThriftServerOperationCanceled

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 100-101行目 - case class定義
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 56-57行目 - onStatementCanceled()
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` 298-305行目 - cancel()
- E-04: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 183-192行目 - onOperationCanceled
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 100行目 - 通知一覧エントリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントクラスはid, finishTimeフィールドを持つ | E-01 | ○ |
| C-02 | private[thriftserver]スコープで定義されている | E-01 | ○ |
| C-03 | onStatementCanceled()でSystem.currentTimeMillis()がfinishTimeとして使用される | E-02 | ○ |
| C-04 | SparkExecuteStatementOperation.cancel()内のsynchronizedブロックで実行される | E-03 | ○ |
| C-05 | isTerminal判定で既に終了状態ならキャンセル処理がスキップされる | E-03 (299行目) | ○ |
| C-06 | setState(OperationState.CANCELED) -> cleanup() -> onStatementCanceled()の順で実行 | E-03 (301-303行目) | ○ |
| C-07 | リスナー側でfinishTimestampとstateをCANCELEDに更新する | E-04 | ○ |
| C-08 | executionListにidが存在しない場合はログ警告 | E-04 (189-191行目) | ○ |
| C-09 | SparkListenerEventを継承する | E-01 | ○ |
| C-10 | 通知一覧で「ThriftServerオペレーションがキャンセルされた際に発火」と記載 | E-05 | ○ |
| C-11 | statementIdが引数として渡される | E-03 (303行目) | ○ |
| C-12 | cleanup()でSparkContext.cancelJobGroupを呼び出す | E-03 (302行目, cleanup参照) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能。cancel処理のフローも詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HiveThriftServer2EventManager.scala 100-101行目のcase class定義がドキュメントと一致するか
- [ ] SparkExecuteStatementOperation.scala 298-305行目のcancel()処理順序が正確か
- [ ] HiveThriftServer2Listener.scala 183-192行目のリスナー処理が正しく記載されているか
