---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：101-SparkListenerThriftServerOperationTimeout

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **レート制限仕様**：LiveListenerBusの内部キューサイズやバックプレッシャー制御に関する詳細根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 103-104行目（SparkListenerThriftServerOperationTimeoutケースクラス定義）
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 60-62行目（onStatementTimeoutメソッド）
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 28-30行目（postLiveListenerBusメソッド）
- E-04: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 117-130行目（onOtherEventメソッド）
- E-05: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 194-203行目（onOperationTimeoutメソッド）
- E-06: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` 284-295行目（timeoutCancelメソッド）
- E-07: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` 56-63行目（timeout値の決定ロジック）
- E-08: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` 138-155行目（ScheduledExecutorService生成）
- E-09: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/HiveThriftServer2.scala` 142-145行目（ExecutionState列挙体定義）
- E-10: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2AppStatusStore.scala` 99-132行目（ExecutionInfo定義、isExecutionActive）
- E-11: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 316-346行目（LiveExecutionDataクラス）
- E-12: `sql/hive-thriftserver/src/test/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2ListenerSuite.scala` 165行目（タイムアウトイベントのテスト）
- E-13: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 200-202行目（不明IDのlogWarning）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerThriftServerOperationTimeoutはid, finishTimeの2フィールドを持つcase class | E-01 | ○ |
| C-02 | SparkListenerEventを継承している | E-01 | ○ |
| C-03 | private[thriftserver]スコープである | E-01 | ○ |
| C-04 | onStatementTimeoutでイベントが生成されLiveListenerBusにポストされる | E-02, E-03 | ○ |
| C-05 | HiveThriftServer2Listener.onOtherEventでパターンマッチにより受信される | E-04 | ○ |
| C-06 | onOperationTimeoutでfinishTimestampとstateがTIMEDOUTに更新される | E-05 | ○ |
| C-07 | SparkExecuteStatementOperation.timeoutCancel()がタイムアウト時に呼び出される | E-06, E-08 | ○ |
| C-08 | timeout値はグローバル設定と個別設定の小さい方が採用される | E-07 | ○ |
| C-09 | timeout > 0の場合のみScheduledExecutorServiceが生成される | E-08 | ○ |
| C-10 | timeoutCancel()はsynchronizedブロックで排他制御されている | E-06 | ○ |
| C-11 | 非終端状態の場合のみTIMEDOUTに遷移する | E-06 | ○ |
| C-12 | ExecutionState列挙体にTIMEDOUTが含まれる | E-09 | ○ |
| C-13 | isExecutionActiveでTIMEDOUTは非アクティブとして扱われる | E-10 | ○ |
| C-14 | 不明なオペレーションIDの場合はlogWarningが出力される | E-13 | ○ |
| C-15 | テストスイートでタイムアウトイベントが検証されている | E-12 | ○ |
| C-16 | cleanup()でbackgroundHandle.cancel(true)とsparkContext.cancelJobGroupが呼ばれる | E-06 (行291), SparkExecuteStatementOperation.scala 308-324行目 | ○ |
| C-17 | logメッセージに「onOperationCanceled」と記載されている不整合がある | E-05 (行201) | ○ |
| C-18 | LiveListenerBusのレート制限は特に設定されていない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: LiveListenerBusの内部キューサイズやバックプレッシャーに関する詳細仕様はLiveListenerBus本体のソースコードを確認する必要がある
  - 候補：`core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` / Spark設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント定義とフィールド構造は明確に確認済み
- 0: 低リスク - 送信トリガーとsynchronizedによる排他制御は明確
- 1: 中リスク - LiveListenerBusのバックプレッシャー時の振る舞いは未確認

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerThriftServerOperationTimeoutのフィールド定義が正確か確認
- [ ] timeoutCancel()のsynchronizedブロックによる排他制御の記述が正確か確認
- [ ] timeout値の決定ロジック（グローバル vs 個別）の記述が正確か確認
- [ ] onOperationTimeoutのログメッセージ不整合の記述が現在のコードと一致するか確認
