---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：102-SparkListenerThriftServerOperationError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **errorTraceのKVStore非永続化**：errorTraceがKVStoreに保存されない旨の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 106-110行目（SparkListenerThriftServerOperationErrorケースクラス定義）
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 64-67行目（onStatementErrorメソッド）
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 28-30行目（postLiveListenerBusメソッド）
- E-04: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 117-130行目（onOtherEvent、125行目のパターンマッチ）
- E-05: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 205-215行目（onOperationErrorメソッド）
- E-06: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` 246-272行目（execute内のcatch）
- E-07: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` 196-208行目（runInternal内のcatch）
- E-08: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkOperation.scala` 115-126行目（onError()メソッド）
- E-09: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/HiveThriftServer2.scala` 142-145行目（ExecutionState列挙体）
- E-10: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2AppStatusStore.scala` 99-132行目（ExecutionInfo）
- E-11: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 316-346行目（LiveExecutionData、detailフィールド）
- E-12: `sql/hive-thriftserver/src/test/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2ListenerSuite.scala` 166-167行目（エラーイベントテスト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerThriftServerOperationErrorはid, errorMsg, errorTrace, finishTimeの4フィールドを持つ | E-01 | ○ |
| C-02 | SparkListenerEventを継承している | E-01 | ○ |
| C-03 | private[thriftserver]スコープである | E-01 | ○ |
| C-04 | onStatementErrorでイベントが生成される | E-02, E-03 | ○ |
| C-05 | onOtherEventのパターンマッチで受信される | E-04 | ○ |
| C-06 | onOperationErrorでfinishTimestamp, detail, stateが更新される | E-05 | ○ |
| C-07 | detailにe.errorMsgが格納される | E-05 (行209) | ○ |
| C-08 | stateがFAILEDに設定される | E-05 (行210) | ○ |
| C-09 | execute()内でThrowable捕捉時にonStatementErrorが呼ばれる | E-06 | ○ |
| C-10 | runInternal()でRejectedExecutionException時にonStatementErrorが呼ばれる | E-07 | ○ |
| C-11 | SparkOperation.onError()でonStatementErrorが呼ばれる | E-08 | ○ |
| C-12 | 終端状態の場合は通知がスキップされる（execute内） | E-06 (行256) | ○ |
| C-13 | errorMsgはe.getMessage()から取得される | E-06, E-08 | ○ |
| C-14 | errorTraceはUtils.exceptionString(e)から取得される | E-06, E-08 | ○ |
| C-15 | 不明なオペレーションIDの場合はlogWarningが出力される | E-05 (行212-214) | ○ |
| C-16 | ExecutionState列挙体にFAILEDが含まれる | E-09 | ○ |
| C-17 | テストスイートでエラーイベントが検証されている | E-12 | ○ |
| C-18 | SparkGetCatalogsOperation等がonError()を使用する | E-08（トレイトとして定義されているためmixinするクラスで使用） | ○ |
| C-19 | errorTraceはKVStoreに永続化されない | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: LiveExecutionDataとExecutionInfoにはdetailフィールドはあるがerrorTraceフィールドは存在しない。しかし、明示的に「永続化されない」との記述はソース上にないため、根拠不足と判定
  - 候補：`HiveThriftServer2Listener.scala` のLiveExecutionData / `HiveThriftServer2AppStatusStore.scala` のExecutionInfo

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント定義とフィールド構造は明確に確認済み
- 0: 低リスク - 複数のエラー発生ポイントが網羅的に記述されている
- 1: 中リスク - errorTraceの永続化有無については追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerThriftServerOperationErrorの4フィールド定義が正確か確認
- [ ] execute(), runInternal(), onError()の3つのエラー発生ポイントが網羅されているか確認
- [ ] detailフィールドにerrorMsgが格納される記述が正確か確認
- [ ] errorTraceのKVStoreへの非永続化の記述が正確か確認（LiveExecutionData, ExecutionInfoの定義を参照）
