---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-SparkListenerThriftServerOperationFinish

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先的なレビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 112-114行目（SparkListenerThriftServerOperationFinishケースクラス定義）
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 69-72行目（onStatementFinishメソッド）
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` 28-30行目（postLiveListenerBusメソッド）
- E-04: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 126行目（onOtherEventのパターンマッチ）
- E-05: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 217-226行目（onOperationFinishedメソッド）
- E-06: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` 273-281行目（execute()のfinallyブロック）
- E-07: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/HiveThriftServer2.scala` 142-145行目（ExecutionState列挙体定義）
- E-08: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2AppStatusStore.scala` 117-123行目（isExecutionActive定義）
- E-09: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` 316-346行目（LiveExecutionDataクラス）
- E-10: `sql/hive-thriftserver/src/test/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2ListenerSuite.scala` 70-71行目（Finishイベントテスト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerThriftServerOperationFinishはid, finishTimeの2フィールドを持つ | E-01 | ○ |
| C-02 | SparkListenerEventを継承している | E-01 | ○ |
| C-03 | private[thriftserver]スコープである | E-01 | ○ |
| C-04 | onStatementFinishでイベントが生成されLiveListenerBusにポストされる | E-02, E-03 | ○ |
| C-05 | onOtherEventのパターンマッチで受信される | E-04 | ○ |
| C-06 | onOperationFinishedでfinishTimestampとstateがFINISHEDに更新される | E-05 | ○ |
| C-07 | execute()のfinallyブロックで非終端状態確認後に発火する | E-06 | ○ |
| C-08 | synchronizedブロック内で実行される | E-06 | ○ |
| C-09 | 終端状態の場合はイベントが発火しない | E-06 (行275) | ○ |
| C-10 | ExecutionState列挙体にFINISHEDが含まれる | E-07 | ○ |
| C-11 | FINISHED状態はisExecutionActiveでtrueを返す | E-08 | ○ |
| C-12 | FINISHED後にOperationClosedイベントが発火する | E-10（テストシーケンス70-73行目でFinish後にClosedが呼ばれる） | ○ |
| C-13 | 不明なオペレーションIDの場合はlogWarningが出力される | E-05 (行223-225) | ○ |
| C-14 | updateLiveStoreでKVStoreが更新される | E-05 (行222) | ○ |
| C-15 | テストスイートで完了イベントが検証されている | E-10 | ○ |
| C-16 | LiveExecutionDataにfinishTimestampフィールドが存在する | E-09 (行323) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はない。すべての主張にソースコードによる根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント定義とフィールド構造は明確に確認済み
- 0: 低リスク - 送信トリガーとsynchronizedによる排他制御は明確
- 0: 低リスク - FINISHEDがアクティブとして扱われる仕様もisExecutionActiveの定義から確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerThriftServerOperationFinishのフィールド定義が正確か確認
- [ ] execute()のfinallyブロック内のsynchronized処理の記述が正確か確認
- [ ] FINISHED状態がisExecutionActiveでアクティブとして扱われる記述が正確か確認
- [ ] FINISHED後にCLOSEDに遷移するライフサイクルの記述が正確か確認
