---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：11-SparkListenerBlockManagerRemoved

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ハートビートタイムアウト時の具体的な呼び出しパス**：間接的推論のため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 112行目 -- case class定義
- E-02: `core/src/main/scala/org/apache/spark/storage/BlockManagerMasterEndpoint.scala` 544行目 -- listenerBus.post呼び出し
- E-03: `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` 126行目 -- postメソッド
- E-04: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 50行目 -- doPostEventパターンマッチ
- E-05: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 899行目 -- onBlockManagerRemoved
- E-06: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 170行目 -- onBlockManagerRemoved
- E-07: `core/src/main/scala/org/apache/spark/util/JsonProtocol.scala` 115行目, 285行目, 1114行目 -- JSON変換
- E-08: `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedSchedulerBackend.scala` 499行目 -- コメントでの言及
- E-09: `core/src/main/scala/org/apache/spark/deploy/history/BasicEventFilterBuilder.scala` 166行目 -- イベントフィルタリング
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 11行目 -- 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | case class SparkListenerBlockManagerRemoved(time: Long, blockManagerId: BlockManagerId)として定義 | E-01 | ○ |
| C-02 | BlockManagerMasterEndpoint.removeBlockManagerメソッド内でイベントが発火される | E-02 | ○ |
| C-03 | LiveListenerBus経由で非同期配信される | E-03 | ○ |
| C-04 | SparkListenerBus.doPostEventでパターンマッチされlistener.onBlockManagerRemovedが呼ばれる | E-04 | ○ |
| C-05 | AppStatusListenerがUI用データを更新する | E-05 | ○ |
| C-06 | EventLoggingListenerがイベントログに記録する | E-06 | ○ |
| C-07 | JsonProtocolでJSON形式にシリアライズ・デシリアライズされる | E-07 | ○ |
| C-08 | イベントにはtimeとblockManagerIdの2フィールドが含まれる | E-01 | ○ |
| C-09 | SparkListenerEventを継承している | E-01 | ○ |
| C-10 | @DeveloperApiアノテーションが付与されている | E-01 | ○ |
| C-11 | History ServerのBasicEventFilterBuilderでフィルタリングされる | E-09 | ○ |
| C-12 | CoarseGrainedSchedulerBackendでExecutor削除時にBlockManager削除が連鎖する | E-08 | ○ |
| C-13 | System.currentTimeMillis()がタイムスタンプとして使用される | E-02 | ○ |
| C-14 | Executorハートビートタイムアウト時にBlockManager削除が発生する | **根拠なし** | △ |
| C-15 | 通知一覧にNo.11として登録されている | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-14: ハートビートタイムアウトによるBlockManager削除の具体的な呼び出しパスはHeartbeatReceiver.scalaからの間接的な推論であり、直接的なコード参照が不足している
  - 候補：HeartbeatReceiver.scala / BlockManagerMaster.scala / SparkContext.scala

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- イベントデータ構造と発火ポイントはソースコードから直接確認済み
- 0: 低リスク -- リスナー側の処理もソースコードから確認済み
- 1: 中リスク -- ハートビートタイムアウトからの呼び出しパスは間接的推論

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListener.scala 112行目のcase class定義がドキュメントと一致するか確認
- [ ] BlockManagerMasterEndpoint.scala 544行目のlistenerBus.post呼び出しを確認
- [ ] ハートビートタイムアウト時のBlockManager削除経路を実際のコードで追跡・確認
- [ ] AppStatusListener.onBlockManagerRemovedの処理内容がドキュメントの記述と一致するか確認
