---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-SparkListenerExecutorAdded

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 119行目 -- case class定義
- E-02: `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedSchedulerBackend.scala` 313行目 -- listenerBus.post（分散モード）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/local/LocalSchedulerBackend.scala` 138行目 -- listenerBus.post（ローカルモード）
- E-04: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 62行目 -- doPostEvent
- E-05: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 215行目 -- onExecutorAdded
- E-06: `core/src/main/scala/org/apache/spark/HeartbeatReceiver.scala` 182行目 -- onExecutorAdded
- E-07: `core/src/main/scala/org/apache/spark/scheduler/dynalloc/ExecutorMonitor.scala` 342行目 -- onExecutorAdded
- E-08: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 185行目 -- onExecutorAdded
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 13行目 -- 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | case class SparkListenerExecutorAdded(time, executorId, executorInfo)として定義 | E-01 | ○ |
| C-02 | CoarseGrainedSchedulerBackend 313行目でイベント発火 | E-02 | ○ |
| C-03 | LocalSchedulerBackend 138行目でイベント発火 | E-03 | ○ |
| C-04 | SparkListenerBus 62行目でlistener.onExecutorAddedが呼ばれる | E-04 | ○ |
| C-05 | AppStatusListenerがExecutor情報をKVStoreに登録 | E-05 | ○ |
| C-06 | HeartbeatReceiverがハートビート管理に登録 | E-06 | ○ |
| C-07 | ExecutorMonitorがExecutor追跡を開始 | E-07 | ○ |
| C-08 | EventLoggingListenerがイベントログに記録 | E-08 | ○ |
| C-09 | time, executorId, executorInfoの3フィールドを持つ | E-01 | ○ |
| C-10 | @DeveloperApiアノテーションが付与 | E-01 | ○ |
| C-11 | System.currentTimeMillis()がタイムスタンプとして使用（分散モード） | E-02 | ○ |
| C-12 | RegisterExecutorメッセージ処理で発火 | E-02 | ○ |
| C-13 | executorDataMapに追加後にイベント発火 | E-02 | ○ |
| C-14 | 通知一覧にNo.13として登録 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CoarseGrainedSchedulerBackend.scala 313行目のlistenerBus.post呼び出しを確認
- [ ] LocalSchedulerBackend.scala 138行目のlistenerBus.post呼び出しを確認
- [ ] AppStatusListener.onExecutorAddedの処理内容がドキュメントと一致するか確認
