---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-SparkListenerExecutorRemoved

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 123行目 -- case class定義
- E-02: `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedSchedulerBackend.scala` 487行目 -- メインパス
- E-03: `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedSchedulerBackend.scala` 502行目 -- フォールバックパス
- E-04: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 64行目 -- doPostEvent
- E-05: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 235-282行目 -- onExecutorRemoved
- E-06: `core/src/main/scala/org/apache/spark/HeartbeatReceiver.scala` 206行目 -- onExecutorRemoved
- E-07: `core/src/main/scala/org/apache/spark/scheduler/dynalloc/ExecutorMonitor.scala` 355行目 -- onExecutorRemoved
- E-08: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 189行目 -- onExecutorRemoved
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 14行目 -- 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | case class SparkListenerExecutorRemoved(time, executorId, reason)として定義 | E-01 | ○ |
| C-02 | CoarseGrainedSchedulerBackend 487行目でイベント発火（メインパス） | E-02 | ○ |
| C-03 | CoarseGrainedSchedulerBackend 502行目でイベント発火（フォールバック） | E-03 | ○ |
| C-04 | SPARK-35011対応としてメタデータ不在時もイベント発火 | E-03 | ○ |
| C-05 | SparkListenerBus 64行目でlistener.onExecutorRemovedが呼ばれる | E-04 | ○ |
| C-06 | AppStatusListenerがExecutor非活性化とRDD情報クリーンアップを実行 | E-05 | ○ |
| C-07 | HeartbeatReceiverがハートビート監視を解除 | E-06 | ○ |
| C-08 | ExecutorMonitorがExecutor追跡情報を削除 | E-07 | ○ |
| C-09 | EventLoggingListenerがイベントログに記録 | E-08 | ○ |
| C-10 | lossReasonにはExecutorKilled, ExecutorDecommission等が含まれる | E-02 | ○ |
| C-11 | scheduler.executorLostが呼び出される | E-02 | ○ |
| C-12 | totalCoreCountが減算される | E-02 | ○ |
| C-13 | BlockManagerの非同期削除がフォールバックパスで実行される | E-03 | ○ |
| C-14 | 通知一覧にNo.14として登録 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CoarseGrainedSchedulerBackend.scala 487行目と502行目の両方のパスを確認
- [ ] AppStatusListener.onExecutorRemovedのRDDクリーンアップロジックを確認
- [ ] lossReason決定ロジック（475-483行目）を確認
