---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-SparkListenerExecutorExcluded

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 134-140行目 -- case class定義と@Since
- E-02: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 291行目 -- updateExcludedForSuccessfulTaskSet内でpost
- E-03: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 254行目 -- updateExcludedForFetchFailure内でpost
- E-04: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 82行目 -- doPostEvent
- E-05: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 297行目 -- onExecutorExcluded
- E-06: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 197行目 -- onExecutorExcluded
- E-07: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 290行目 -- 後方互換SparkListenerExecutorBlacklisted
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 15行目 -- 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | case class SparkListenerExecutorExcluded(time, executorId, taskFailures)として定義 | E-01 | ○ |
| C-02 | @Since("3.1.0")アノテーションが付与 | E-01 | ○ |
| C-03 | updateExcludedForSuccessfulTaskSet 291行目でイベント発火 | E-02 | ○ |
| C-04 | updateExcludedForFetchFailure 254行目でイベント発火 | E-03 | ○ |
| C-05 | 後方互換のためSparkListenerExecutorBlacklistedも同時に発火 | E-07 | ○ |
| C-06 | SparkListenerBus 82行目でlistener.onExecutorExcludedが呼ばれる | E-04 | ○ |
| C-07 | AppStatusListenerが除外ステータスを更新 | E-05 | ○ |
| C-08 | EventLoggingListenerがイベントログに記録 | E-06 | ○ |
| C-09 | 累積失敗数 >= MAX_FAILURES_PER_EXEC で発火 | E-02 | ○ |
| C-10 | フェッチ失敗時はtaskFailures=1でハードコード | E-03 | ○ |
| C-11 | 除外済みExecutorは再除外されない | E-02 | ○ |
| C-12 | EXCLUDE_ON_FAILURE_KILL_ENABLEDでkill可能 | E-02 | ○ |
| C-13 | 通知一覧にNo.15として登録 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HealthTracker.scala 254行目と291行目の両方の発火ポイントを確認
- [ ] 後方互換のSparkListenerExecutorBlacklisted発火を確認
- [ ] MAX_FAILURES_PER_EXEC設定値のデフォルト値を確認
