---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-SparkListenerNodeExcludedForStage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 176-182行目 -- case class定義
- E-02: `core/src/main/scala/org/apache/spark/scheduler/TaskSetExcludeList.scala` 160-163行目 -- listenerBus.post
- E-03: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 80行目 -- doPostEvent
- E-04: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 315-317行目 -- onNodeExcludedForStage
- E-05: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 215-216行目 -- onNodeExcludedForStage
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 17行目 -- 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | case class SparkListenerNodeExcludedForStage(time, hostId, executorFailures, stageId, stageAttemptId)として定義 | E-01 | ○ |
| C-02 | @Since("3.1.0")アノテーションが付与 | E-01 | ○ |
| C-03 | TaskSetExcludelist 163行目でイベント発火 | E-02 | ○ |
| C-04 | 後方互換のためSparkListenerNodeBlacklistedForStageも同時発火 | E-02 | ○ |
| C-05 | SparkListenerBus 80行目でlistener.onNodeExcludedForStageが呼ばれる | E-03 | ○ |
| C-06 | AppStatusListenerがステージノード除外情報を更新 | E-04 | ○ |
| C-07 | EventLoggingListenerがイベントログに記録 | E-05 | ○ |
| C-08 | SparkListenerExecutorExcludedForStageの連鎖で発火 | E-02 | ○ |
| C-09 | excludedNodes.addがtrueの場合のみ発火 | E-02 | ○ |
| C-10 | MAX_FAILED_EXEC_PER_NODE_STAGEが閾値 | E-02 | ○ |
| C-11 | 通知一覧にNo.17として登録 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] TaskSetExcludeList.scala 160-163行目の発火ポイントを確認
- [ ] MAX_FAILED_EXEC_PER_NODE_STAGEのデフォルト値を確認
- [ ] Executor除外からノード除外への連鎖ロジックを確認
