---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-SparkListenerExecutorUnexcluded

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 191行目 -- case class定義
- E-02: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 105-143行目 -- applyExcludeOnFailureTimeout
- E-03: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 121行目 -- listenerBus.post
- E-04: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 120行目 -- 後方互換Unblacklisted
- E-05: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 84行目 -- doPostEvent
- E-06: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 338行目 -- onExecutorUnexcluded
- E-07: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 223行目 -- onExecutorUnexcluded
- E-08: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 425行目 -- DEFAULT_TIMEOUT = "1h"
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 18行目 -- 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | case class SparkListenerExecutorUnexcluded(time, executorId)として定義 | E-01 | ○ |
| C-02 | HealthTracker.applyExcludeOnFailureTimeout 121行目でイベント発火 | E-03 | ○ |
| C-03 | 後方互換のためSparkListenerExecutorUnblacklistedも同時発火 | E-04 | ○ |
| C-04 | SparkListenerBus 84行目でlistener.onExecutorUnexcludedが呼ばれる | E-05 | ○ |
| C-05 | AppStatusListenerが除外ステータスを解除 | E-06 | ○ |
| C-06 | EventLoggingListenerがイベントログに記録 | E-07 | ○ |
| C-07 | expiryTimeが現在時刻を過ぎたExecutorに対して発火 | E-02 | ○ |
| C-08 | nextExpiryTimeによる最適化で不要な処理がスキップされる | E-02 | ○ |
| C-09 | executorIdToExcludedStatusから削除される | E-02 | ○ |
| C-10 | nodeToExcludedExecsから削除される | E-02 | ○ |
| C-11 | デフォルトタイムアウトは1時間 | E-08 | ○ |
| C-12 | 通知一覧にNo.18として登録 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HealthTracker.scala 121行目の発火ポイントを確認
- [ ] applyExcludeOnFailureTimeoutの呼び出しタイミング（TaskSchedulerImpl等）を確認
- [ ] EXCLUDE_ON_FAILURE_TIMEOUT_MILLISの設定値とデフォルト値を確認
