---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-SparkListenerStageCompleted

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L37（SparkListenerStageCompletedケースクラス定義）
- E-02: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L3263（markStageAsFinished内のpost）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L3255-3258（failureReason設定）
- E-04: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` L3260-3261（outputCommitCoordinator.stageEnd）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` L34-35（doPostEventのStageCompletedパターンマッチ）
- E-06: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L309（onStageCompleted定義）
- E-07: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` L507（SparkListenerデフォルト実装）
- E-08: `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` L126-160（LiveListenerBus.post）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerStageCompletedはstageInfoのみの1フィールドケースクラス | E-01 | ○ |
| C-02 | DAGScheduler.markStageAsFinished（L3263）でイベントが発火される | E-02 | ○ |
| C-03 | 失敗時はstageInfo.stageFailedにエラーメッセージが設定される | E-03 | ○ |
| C-04 | willRetryがfalseの場合のみoutputCommitCoordinator.stageEndが呼ばれる | E-04 | ○ |
| C-05 | SparkListenerBusでパターンマッチによりonStageCompletedが呼ばれる | E-05 | ○ |
| C-06 | SparkListenerInterfaceにonStageCompletedメソッドが定義されている | E-06 | ○ |
| C-07 | SparkListenerクラスのデフォルト実装はno-op | E-07 | ○ |
| C-08 | LiveListenerBus経由で非同期配信される | E-08 | ○ |
| C-09 | 成功・失敗問わず発火される | E-02, E-03 | ○ |
| C-10 | markStageAsFinished後にrunningStagesからステージが除去される | E-02 | ○ |
| C-11 | ステージの成功・失敗はstageInfo.failureReasonで判別可能 | E-01, E-03 | ○ |
| C-12 | pushBasedShuffle情報の更新後にイベントが発火される | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードの根拠と一致

## 6) レビュアーチェックリスト（最小）
- [ ] SparkListenerStageCompletedのフィールド定義がソースコードと一致しているか
- [ ] DAGScheduler.markStageAsFinishedの行番号が最新コードと一致しているか
- [ ] ステージの成功/失敗の判定ロジックが正確に記述されているか
