---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-SparkListenerNodeUnexcluded

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 218行目 -- case class定義
- E-02: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 128-143行目 -- applyExcludeOnFailureTimeout内ノード処理
- E-03: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 137行目 -- listenerBus.post
- E-04: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 136行目 -- 後方互換NodeUnblacklisted
- E-05: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 88行目 -- doPostEvent
- E-06: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 354行目 -- onNodeUnexcluded
- E-07: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 240行目 -- onNodeUnexcluded
- E-08: `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` 139行目 -- _excludedNodeList更新
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 20行目 -- 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | case class SparkListenerNodeUnexcluded(time, hostId)として定義 | E-01 | ○ |
| C-02 | @Since("3.1.0")アノテーションが付与 | E-01 | ○ |
| C-03 | HealthTracker.applyExcludeOnFailureTimeout 137行目でイベント発火 | E-03 | ○ |
| C-04 | 後方互換のためSparkListenerNodeUnblacklistedも同時発火 | E-04 | ○ |
| C-05 | SparkListenerBus 88行目でlistener.onNodeUnexcludedが呼ばれる | E-05 | ○ |
| C-06 | AppStatusListenerがノード除外ステータスを解除 | E-06 | ○ |
| C-07 | EventLoggingListenerがイベントログに記録 | E-07 | ○ |
| C-08 | nodeIdToExcludedExpiryTimeのexpiryTimeが現在時刻を過ぎた場合に発火 | E-02 | ○ |
| C-09 | _excludedNodeListのスナップショットが更新される | E-08 | ○ |
| C-10 | Executor再有効化の後にノード再有効化が処理される | E-02 | ○ |
| C-11 | updateNextExpiryTimeで次回タイムアウト時刻が再計算される | E-02 | ○ |
| C-12 | 通知一覧にNo.20として登録 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] HealthTracker.scala 137行目の発火ポイントを確認
- [ ] Executor再有効化とノード再有効化の処理順序を確認
- [ ] _excludedNodeListのスナップショット更新タイミング（139行目）を確認
