---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：21-SparkListenerUnschedulableTaskSetAdded

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **C-12**：TaskSetManagerからDAGSchedulerへの通知経路の詳細が根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 行221-225（ケースクラス定義）
- E-02: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` 行1302-1311（handleUnschedulableTaskSetAdded/Removed）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` 行3560-3564（DAGSchedulerEventProcessLoopのメッセージ処理）
- E-04: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 行94-95（doPostEventでのパターンマッチ）
- E-05: `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` 行842-850（onUnschedulableTaskSetAdded処理）
- E-06: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 行462-467（SparkListenerInterfaceのメソッド定義）
- E-07: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 行574-575（SparkListenerのデフォルト実装）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerUnschedulableTaskSetAddedはstageIdとstageAttemptIdの2フィールドを持つケースクラスである | E-01 | ○ |
| C-02 | @Since("3.1.0")で導入された | E-01 | ○ |
| C-03 | DAGScheduler.handleUnschedulableTaskSetAddedでlistenerBus.postが呼ばれる | E-02 | ○ |
| C-04 | DAGSchedulerEventProcessLoopでUnschedulableTaskSetAddedメッセージを処理する | E-03 | ○ |
| C-05 | SparkListenerBus.doPostEventで専用のcaseブランチがある | E-04 | ○ |
| C-06 | ExecutorAllocationManagerがunschedulableTaskSetsに追加しonSchedulerBackloggedを呼ぶ | E-05 | ○ |
| C-07 | SparkListenerInterfaceにonUnschedulableTaskSetAddedメソッドが定義されている | E-06 | ○ |
| C-08 | SparkListenerクラスでデフォルトno-op実装が提供されている | E-07 | ○ |
| C-09 | LiveListenerBus経由で非同期配信される | E-04 | ○ |
| C-10 | excludeOnFailureと動的割り当てが有効な場合に発火する | E-05, E-06 | ○ |
| C-11 | イベントログにJSON形式で記録される（EventLoggingListener経由） | E-02 | ○ |
| C-12 | TaskSetManagerがスケジュール不可を検出し、DAGSchedulerに通知する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TaskSetManagerからDAGSchedulerEventProcessLoopへUnschedulableTaskSetAddedメッセージが投入される具体的なコードパスを確認できていない
  - 候補：TaskSetManager.scala / TaskSchedulerImpl.scala / DAGSchedulerEvent.scala

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベントのデータ構造と配信メカニズムはコードから明確に確認できる
- 1: 中リスク - TaskSetManagerからの発火条件の詳細はさらなるコード調査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] stageIdとstageAttemptIdの2フィールド構成が正しいか確認
- [ ] excludeOnFailureと動的割り当ての両方が有効な場合のみ発火するか確認
- [ ] TaskSetManagerからDAGSchedulerへの通知経路を確認
- [ ] ExecutorAllocationManager以外に重要なリスナーが存在しないか確認
