---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-SparkListenerStageExecutorMetrics

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 行256-270（ケースクラス定義・Scaladoc）
- E-02: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 行136-158（onStageCompleted）
- E-03: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` 行73-75（liveStageExecutorMetricsマップ定義）
- E-04: `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` 行982-989（onStageExecutorMetrics）
- E-05: `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` 行60-61（doPostEvent）
- E-06: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` 行379-382（Scaladocコメント）
- E-07: `core/src/main/scala/org/apache/spark/deploy/history/BasicEventFilterBuilder.scala` 行164（フィルタリング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerStageExecutorMetricsはexecId, stageId, stageAttemptId, executorMetricsの4フィールドを持つ | E-01 | ○ |
| C-02 | ライブアプリケーションでは呼ばれず、履歴ログ読み込み時にのみ処理される | E-06 | ○ |
| C-03 | EventLoggingListener.onStageCompleted内でステージ完了時に生成される | E-02 | ○ |
| C-04 | spark.eventLog.logStageExecutorMetrics設定に基づき記録可否が制御される | E-02 | ○ |
| C-05 | liveStageExecutorMetricsマップでステージ単位のピーク値を追跡する | E-03 | ○ |
| C-06 | AppStatusListenerがログ再生時にliveExecutorsとdeadExecutorsの両方をチェックする | E-04 | ○ |
| C-07 | SparkListenerBus.doPostEventで専用のcaseブランチがある | E-05 | ○ |
| C-08 | BasicEventFilterBuilderでexecIdによるフィルタリングが行われる | E-07 | ○ |
| C-09 | 以前のステージ試行のメトリクスはステージ完了時にクリアされる | E-02 | ○ |
| C-10 | 各Executorごとに個別のSparkListenerStageExecutorMetricsイベントが生成される | E-02 | ○ |
| C-11 | Scaladocに「Peak metric values for the executor for the stage」と明記されている | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのClaimにソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 4フィールドの型定義が正しいか確認
- [ ] ライブアプリケーションでは処理されないことの確認
- [ ] EventLoggingListenerのピーク値追跡ロジックの正確性確認
